/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.RuleBaseImpl;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.TupleSource;
import org.drools.rule.LiteralConstraint;
import org.drools.spi.FieldValue;
import org.drools.util.ReflectiveVisitor;
import org.drools.visualize.ReteooJungViewer;

public class ReteooToJungVisitor
extends ReflectiveVisitor {
    private static final String NULL_STRING = "<NULL>";
    private static final String INDENT = "    ";
    private Map visitedNodes = new HashMap();
    private Graph graph;
    private Vertex rootVertex;
    private Vertex parentVertex;

    public ReteooToJungVisitor(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Vertex getRootVertex() {
        return this.rootVertex;
    }

    public void visitRuleBaseImpl(RuleBaseImpl ruleBase) {
        this.visit(ruleBase.getRete());
    }

    public void visitRete(Rete rete) {
        this.rootVertex = (ReteNodeVertex)this.visitedNodes.get(ReteooToJungVisitor.dotId(rete));
        if (this.rootVertex == null) {
            this.rootVertex = new ReteNodeVertex(rete);
            this.visitedNodes.put(ReteooToJungVisitor.dotId(rete), this.rootVertex);
        }
        this.graph.addVertex(this.rootVertex);
        this.parentVertex = this.rootVertex;
        Iterator i = rete.objectTypeNodeIterator();
        while (i.hasNext()) {
            Object nextNode = i.next();
            this.visitNode(nextNode);
        }
    }

    public void visitBaseNode(BaseNode node) {
        Vertex vertex = (Vertex)this.visitedNodes.get(ReteooToJungVisitor.dotId(node));
        if (vertex == null) {
            try {
                String name = node.getClass().getName();
                name = name.substring(name.lastIndexOf(46) + 1) + "Vertex";
                Class<?> clazz = Class.forName("org.drools.reteoo.ReteooToJungVisitor$" + name);
                vertex = (Vertex)clazz.getConstructor(node.getClass()).newInstance(node);
            }
            catch (Exception e) {
                throw new RuntimeException("problem visiting node " + node.getClass().getName(), e);
            }
            this.graph.addVertex(vertex);
            this.visitedNodes.put(ReteooToJungVisitor.dotId(node), vertex);
            this.graph.addEdge((Edge)new DroolsDirectedEdge(this.parentVertex, vertex));
            Vertex oldParentVertex = this.parentVertex;
            this.parentVertex = vertex;
            List list = null;
            if (node instanceof ObjectSource) {
                list = ((ObjectSource)node).getObjectSinksAsList();
            } else if (node instanceof TupleSource) {
                list = ((TupleSource)node).getTupleSinks();
            }
            if (list != null) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Object nextNode = it.next();
                    this.visitNode(nextNode);
                }
            }
            this.parentVertex = oldParentVertex;
        } else {
            this.graph.addEdge((Edge)new DroolsDirectedEdge(this.parentVertex, vertex));
        }
    }

    private void visitNode(Object node) {
        this.visit(node);
    }

    private static String dotId(Object object) {
        return Integer.toHexString(System.identityHashCode(object)).toUpperCase();
    }

    public static abstract class BaseNodeVertex
    extends DirectedSparseVertex
    implements ReteooJungViewer.DroolsVertex {
        public String getHtml() {
            return this.getClass().getName().toString();
        }

        public Paint getFillPaint() {
            return Color.WHITE;
        }

        public Paint getDrawPaint() {
            return Color.BLACK;
        }
    }

    static class TerminalNodeVertex
    extends BaseNodeVertex {
        private final TerminalNode node;

        public TerminalNodeVertex(TerminalNode node) {
            this.node = node;
        }

        public String getHtml() {
            return "TerminalNode : " + this.node.getId();
        }

        public String toString() {
            return "TerminalNode";
        }

        public Paint getFillPaint() {
            return Color.DARK_GRAY;
        }
    }

    static class EvalConditionNodeVertex
    extends BaseNodeVertex {
        private final EvalConditionNode node;

        public EvalConditionNodeVertex(EvalConditionNode node) {
            this.node = node;
        }

        public String getHtml() {
            return "EvalConditionNode : " + this.node.getId();
        }

        public String toString() {
            return "EvalConditionNode";
        }
    }

    static class NotNodeVertex
    extends BaseNodeVertex {
        private final NotNode node;

        public NotNodeVertex(NotNode node) {
            this.node = node;
        }

        public String getHtml() {
            return "NotNode : " + this.node.getId();
        }

        public String toString() {
            return "NotNode";
        }

        public Paint getFillPaint() {
            return Color.CYAN;
        }
    }

    static class JoinNodeVertex
    extends BaseNodeVertex {
        private final JoinNode node;

        public JoinNodeVertex(JoinNode node) {
            this.node = node;
        }

        public String getHtml() {
            return "JoinNode : " + this.node.getId();
        }

        public String toString() {
            return "JoinNode";
        }

        public Paint getFillPaint() {
            return Color.GREEN;
        }
    }

    static class RightInputAdapterNodeVertex
    extends BaseNodeVertex {
        private final RightInputAdapterNode node;

        public RightInputAdapterNodeVertex(RightInputAdapterNode node) {
            this.node = node;
        }

        public String getHtml() {
            return "RightInputAdapterNodeVertex : " + this.node.getId();
        }

        public String toString() {
            return "RightInputAdapterNodeVertex";
        }

        public Paint getFillPaint() {
            return Color.ORANGE;
        }
    }

    static class LeftInputAdapterNodeVertex
    extends BaseNodeVertex {
        private final LeftInputAdapterNode node;

        public LeftInputAdapterNodeVertex(LeftInputAdapterNode node) {
            this.node = node;
        }

        public String getHtml() {
            return "LeftInputAdapterNode : " + this.node.getId();
        }

        public String toString() {
            return "leftInputAdapter";
        }

        public Paint getFillPaint() {
            return Color.YELLOW;
        }
    }

    static class AlphaNodeVertex
    extends BaseNodeVertex {
        private final AlphaNode node;

        public AlphaNodeVertex(AlphaNode node) {
            this.node = node;
        }

        public String getHtml() {
            LiteralConstraint constraint = (LiteralConstraint)this.node.getConstraint();
            FieldValue field = constraint.getField();
            return "AlphaNode<br>field name : <br>evaluator : " + constraint.getEvaluator() + "<br>value :  " + field.getValue();
        }

        public String toString() {
            return "AlphaNode";
        }

        public Paint getFillPaint() {
            return Color.BLUE;
        }
    }

    static class ObjectTypeNodeVertex
    extends BaseNodeVertex {
        private final ObjectTypeNode node;

        public ObjectTypeNodeVertex(ObjectTypeNode node) {
            this.node = node;
        }

        public String getHtml() {
            return "ObjectTypeNode : " + this.node.getObjectType();
        }

        public String toString() {
            return "ObjectTypeNode";
        }

        public Paint getFillPaint() {
            return Color.RED;
        }
    }

    static class ReteNodeVertex
    extends BaseNodeVertex {
        private final Rete node;

        public ReteNodeVertex(Rete node) {
            this.node = node;
        }

        public String getHtml() {
            return "Rete : " + this.node.getId();
        }

        public String toString() {
            return "Rete";
        }
    }

    class DroolsDirectedEdge
    extends DirectedSparseEdge {
        public DroolsDirectedEdge(Vertex v1, Vertex v2) {
            super(v1, v2);
        }
    }
}

