/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.FactException;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.NodeMemory;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.ObjectType;
import org.drools.spi.ObjectTypeResolver;
import org.drools.spi.PropagationContext;

class Rete
extends ObjectSource
implements Serializable,
ObjectSink,
NodeMemory {
    private final Map objectTypeNodes = new HashMap();
    private ObjectTypeNode lastAddedNode = null;
    private final ObjectTypeResolver resolver;

    public Rete() {
        this(null);
    }

    public Rete(ObjectTypeResolver resolver) {
        super(0);
        this.resolver = resolver;
    }

    public void assertObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) {
        Object object;
        HashMap memory = (HashMap)workingMemory.getNodeMemory(this);
        ObjectTypeNode[] cachedNodes = (ObjectTypeNode[])memory.get((object = handle.getObject()).getClass());
        if (cachedNodes == null) {
            cachedNodes = this.getMatchingNodes(object);
            memory.put(object.getClass(), cachedNodes);
        }
        int length = cachedNodes.length;
        for (int i = 0; i < length; ++i) {
            cachedNodes[i].assertObject(handle, context, workingMemory);
        }
    }

    public void retractObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) {
        Object object;
        HashMap memory = (HashMap)workingMemory.getNodeMemory(this);
        ObjectTypeNode[] cachedNodes = (ObjectTypeNode[])memory.get((object = handle.getObject()).getClass());
        if (cachedNodes == null) {
            cachedNodes = this.getMatchingNodes(object);
            memory.put(object.getClass(), cachedNodes);
        }
        for (int i = 0; i < cachedNodes.length; ++i) {
            cachedNodes[i].retractObject(handle, context, workingMemory);
        }
    }

    public void modifyObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) {
        Object object;
        HashMap memory = (HashMap)workingMemory.getNodeMemory(this);
        ObjectTypeNode[] cachedNodes = (ObjectTypeNode[])memory.get((object = handle.getObject()).getClass());
        if (cachedNodes == null) {
            cachedNodes = this.getMatchingNodes(object);
            memory.put(object.getClass(), cachedNodes);
        }
        for (int i = 0; i < cachedNodes.length; ++i) {
            cachedNodes[i].modifyObject(handle, context, workingMemory);
        }
    }

    private ObjectTypeNode[] getMatchingNodes(Object object) throws FactException {
        ArrayList<ObjectTypeNode> cache = new ArrayList<ObjectTypeNode>();
        Iterator it = this.objectTypeNodeIterator();
        while (it.hasNext()) {
            ObjectTypeNode node = (ObjectTypeNode)it.next();
            if (!node.matches(object)) continue;
            cache.add(node);
        }
        return cache.toArray(new ObjectTypeNode[cache.size()]);
    }

    Collection getObjectTypeNodes() {
        return this.objectTypeNodes.values();
    }

    Iterator objectTypeNodeIterator() {
        return this.objectTypeNodes.values().iterator();
    }

    ObjectTypeNode getObjectTypeNode(ObjectType objectType) {
        return (ObjectTypeNode)this.objectTypeNodes.get(objectType);
    }

    private void addObjectTypeNode(ObjectTypeNode node) {
        this.lastAddedNode = node;
        this.objectTypeNodes.put(node.getObjectType(), node);
    }

    protected void addObjectSink(ObjectSink objectSink) {
        this.addObjectTypeNode((ObjectTypeNode)objectSink);
    }

    protected void removeObjectSink(ObjectSink objectSink) {
        this.objectTypeNodes.remove(objectSink);
    }

    public void attach() {
    }

    public void attach(WorkingMemoryImpl[] workingMemories) {
    }

    public void updateNewNode(WorkingMemoryImpl workingMemory, PropagationContext context) {
        if (this.lastAddedNode != null) {
            ObjectType objType = this.lastAddedNode.getObjectType();
            Iterator i = workingMemory.getFactHandleMap().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!objType.matches(entry.getKey())) continue;
                this.lastAddedNode.assertObject((FactHandleImpl)entry.getValue(), context, workingMemory);
            }
            this.lastAddedNode = null;
        }
    }

    public void remove(BaseNode node, WorkingMemoryImpl[] workingMemories) {
        ObjectTypeNode objectTypeNode = (ObjectTypeNode)node;
        this.removeObjectSink(objectTypeNode);
    }

    public Object createMemory() {
        return new HashMap();
    }
}

