/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkList;
import org.drools.reteoo.ObjectSinkListFactory;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.PropagationContext;

abstract class ObjectSource
extends BaseNode
implements Serializable {
    protected ObjectSinkList objectSinks = ObjectSinkListFactory.newObjectSinkList(this);

    ObjectSource(int id) {
        super(id);
    }

    protected void addObjectSink(ObjectSink objectSink) {
        if (!this.objectSinks.contains(objectSink)) {
            this.objectSinks.add(objectSink);
        }
    }

    protected void removeObjectSink(ObjectSink objectSink) {
        this.objectSinks.remove(objectSink);
    }

    protected void propagateAssertObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) {
        Iterator i = this.objectSinks.iterator(workingMemory, handle);
        while (i.hasNext()) {
            ((ObjectSink)i.next()).assertObject(handle, context, workingMemory);
        }
    }

    protected void propagateRetractObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) {
        Iterator i = this.objectSinks.iterator();
        while (i.hasNext()) {
            ((ObjectSink)i.next()).retractObject(handle, context, workingMemory);
        }
    }

    protected void propagateModifyObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) {
        Iterator i = this.objectSinks.iterator();
        while (i.hasNext()) {
            ((ObjectSink)i.next()).modifyObject(handle, context, workingMemory);
        }
    }

    public ObjectSinkList getObjectSinks() {
        return this.objectSinks;
    }

    public List getObjectSinksAsList() {
        return this.objectSinks.getObjectsAsList();
    }
}

