/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.common.BetaNodeBinder;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.ObjectMatches;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleMatch;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.PropagationContext;

class JoinNode
extends BetaNode {
    JoinNode(int id, TupleSource leftInput, ObjectSource rightInput) {
        super(id, leftInput, rightInput);
    }

    JoinNode(int id, TupleSource leftInput, ObjectSource rightInput, BetaNodeBinder binder) {
        super(id, leftInput, rightInput, binder);
    }

    public void assertTuple(ReteTuple leftTuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.add((WorkingMemory)workingMemory, leftTuple);
        BetaNodeBinder binder = this.getJoinNodeBinder();
        Iterator it = memory.rightObjectIterator(workingMemory, leftTuple);
        while (it.hasNext()) {
            ObjectMatches objectMatches = (ObjectMatches)it.next();
            FactHandleImpl handle = objectMatches.getFactHandle();
            TupleMatch tupleMatch = this.attemptJoin(leftTuple, handle, objectMatches, binder, workingMemory);
            if (tupleMatch == null) continue;
            this.propagateAssertTuple(new ReteTuple(leftTuple, handle), tupleMatch, context, workingMemory);
        }
    }

    public void assertObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        ObjectMatches objectMatches = memory.add((WorkingMemory)workingMemory, handle);
        BetaNodeBinder binder = this.getJoinNodeBinder();
        Iterator it = memory.leftTupleIterator(workingMemory, handle);
        while (it.hasNext()) {
            ReteTuple leftTuple = (ReteTuple)it.next();
            TupleMatch tupleMatch = this.attemptJoin(leftTuple, handle, objectMatches, binder, workingMemory);
            if (tupleMatch == null) continue;
            this.propagateAssertTuple(new ReteTuple(leftTuple, handle), tupleMatch, context, workingMemory);
        }
    }

    public void retractObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        ObjectMatches objectMatches = memory.remove((WorkingMemory)workingMemory, handle);
        for (TupleMatch tupleMatch = objectMatches.getFirstTupleMatch(); tupleMatch != null; tupleMatch = (TupleMatch)tupleMatch.getNext()) {
            ReteTuple leftTuple = tupleMatch.getTuple();
            leftTuple.removeMatch(handle);
            this.propagateRetractTuple(tupleMatch, context, workingMemory);
        }
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.remove((WorkingMemory)workingMemory, leftTuple);
        Map matches = leftTuple.getTupleMatches();
        if (!matches.isEmpty()) {
            Iterator it = matches.values().iterator();
            while (it.hasNext()) {
                TupleMatch tupleMatch = (TupleMatch)it.next();
                tupleMatch.getObjectMatches().remove(tupleMatch);
                this.propagateRetractTuple(tupleMatch, context, workingMemory);
            }
        }
    }

    public void modifyTuple(ReteTuple leftTuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.remove((WorkingMemory)workingMemory, leftTuple);
        Map matches = leftTuple.getTupleMatches();
        if (matches.isEmpty()) {
            this.assertTuple(leftTuple, context, workingMemory);
        } else {
            memory.add((WorkingMemory)workingMemory, leftTuple);
            BetaNodeBinder binder = this.getJoinNodeBinder();
            Iterator rightIterator = memory.rightObjectIterator(workingMemory, leftTuple);
            while (rightIterator.hasNext()) {
                TupleMatch tupleMatch;
                ObjectMatches objectMatches = (ObjectMatches)rightIterator.next();
                FactHandleImpl handle = objectMatches.getFactHandle();
                if (binder.isAllowed(handle, leftTuple, workingMemory)) {
                    tupleMatch = (TupleMatch)leftTuple.getTupleMatches().get(handle);
                    if (tupleMatch != null) {
                        this.propagateModifyTuple(tupleMatch, context, workingMemory);
                        continue;
                    }
                    tupleMatch = objectMatches.add(leftTuple);
                    leftTuple.addTupleMatch(handle, tupleMatch);
                    this.propagateAssertTuple(new ReteTuple(leftTuple, handle), tupleMatch, context, workingMemory);
                    continue;
                }
                tupleMatch = leftTuple.removeMatch(handle);
                if (tupleMatch == null) continue;
                objectMatches.remove(tupleMatch);
                this.propagateRetractTuple(tupleMatch, context, workingMemory);
            }
        }
    }

    public void modifyObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        ObjectMatches objectMatches = memory.remove((WorkingMemory)workingMemory, handle);
        memory.add((WorkingMemory)workingMemory, objectMatches);
        TupleMatch tupleMatch = objectMatches.getFirstTupleMatch();
        BetaNodeBinder binder = this.getJoinNodeBinder();
        Iterator it = memory.leftTupleIterator(workingMemory, handle);
        while (it.hasNext()) {
            ReteTuple leftTuple = (ReteTuple)it.next();
            if (tupleMatch != null && tupleMatch.getTuple() == leftTuple) {
                if (binder.isAllowed(handle, leftTuple, workingMemory)) {
                    this.propagateModifyTuple(tupleMatch, context, workingMemory);
                } else {
                    leftTuple.removeMatch(handle);
                    objectMatches.remove(tupleMatch);
                    this.propagateRetractTuple(tupleMatch, context, workingMemory);
                }
                tupleMatch = (TupleMatch)tupleMatch.getNext();
                continue;
            }
            TupleMatch newTupleMatch = this.attemptJoin(leftTuple, handle, objectMatches, binder, workingMemory);
            if (newTupleMatch == null) continue;
            this.propagateAssertTuple(new ReteTuple(leftTuple, handle), newTupleMatch, context, workingMemory);
        }
    }

    public void updateNewNode(WorkingMemoryImpl workingMemory, PropagationContext context) {
        this.attachingNewNode = true;
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.getRightObjectMemory().iterator();
        while (it.hasNext()) {
            ObjectMatches objectMatches = (ObjectMatches)it.next();
            FactHandleImpl handle = objectMatches.getFactHandle();
            for (TupleMatch tupleMatch = objectMatches.getFirstTupleMatch(); tupleMatch != null; tupleMatch = (TupleMatch)tupleMatch.getNext()) {
                ReteTuple tuple = new ReteTuple(tupleMatch.getTuple(), handle);
                TupleSink sink = (TupleSink)this.tupleSinks.get(this.tupleSinks.size() - 1);
                if (sink == null) {
                    throw new RuntimeException("Possible BUG: trying to propagate an assert to a node that was the last added node");
                }
                tupleMatch.addJoinedTuple(tuple);
                sink.assertTuple(tuple, context, workingMemory);
            }
        }
        this.attachingNewNode = false;
    }

    public List getPropagatedTuples(WorkingMemoryImpl workingMemory, TupleSink sink) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        int index = this.getTupleSinks().indexOf(sink);
        ArrayList propagatedTuples = new ArrayList();
        Iterator it = memory.getRightObjectMemory().iterator();
        while (it.hasNext()) {
            ObjectMatches objectMatches = (ObjectMatches)it.next();
            for (TupleMatch tupleMatch = objectMatches.getFirstTupleMatch(); tupleMatch != null; tupleMatch = (TupleMatch)tupleMatch.getNext()) {
                propagatedTuples.add(tupleMatch.getJoinedTuples().get(index));
            }
        }
        return propagatedTuples;
    }
}

