/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Arrays;
import org.drools.FactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.reteoo.FactHandleImpl;

final class FactHandleList
implements Serializable {
    static final FactHandleList EMPTY_LIST = new FactHandleList();
    private final InternalFactHandle[] handles;
    private final int hashCode;

    private FactHandleList() {
        this.handles = new FactHandleImpl[0];
        this.hashCode = 0;
    }

    public FactHandleList(FactHandleList left, InternalFactHandle handle) {
        this.handles = new FactHandleImpl[left.handles.length + 1];
        System.arraycopy(left.handles, 0, this.handles, 0, left.handles.length);
        this.handles[left.handles.length] = handle;
        this.hashCode = left.hashCode + handle.hashCode();
    }

    public FactHandleList(FactHandleImpl handle) {
        this.handles = new FactHandleImpl[]{handle};
        this.hashCode = handle.hashCode();
    }

    public InternalFactHandle get(int index) {
        return this.handles[index];
    }

    public boolean contains(FactHandle handle) {
        for (int i = this.handles.length - 1; i >= 0; --i) {
            if (!handle.equals(this.handles[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(FactHandleList other) {
        if (other.handles.length > this.handles.length) {
            return false;
        }
        for (int i = other.handles.length - 1; i >= 0; --i) {
            InternalFactHandle handle = other.handles[i];
            if (handle == null || handle.equals(this.handles[i])) continue;
            return false;
        }
        return true;
    }

    InternalFactHandle[] getHandles() {
        return this.handles;
    }

    public int size() {
        return this.handles.length;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.handles, ((FactHandleList)object).handles);
    }
}

