/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.NodeMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.EvalCondition;
import org.drools.spi.PropagationContext;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListObjectWrapper;

class EvalConditionNode
extends TupleSource
implements TupleSink,
NodeMemory {
    private final EvalCondition condition;
    private final TupleSource tupleSource;
    static /* synthetic */ Class class$org$drools$reteoo$EvalConditionNode;

    EvalConditionNode(int id, TupleSource tupleSource, EvalCondition eval) {
        super(id);
        this.condition = eval;
        this.tupleSource = tupleSource;
        this.hasMemory = true;
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(WorkingMemoryImpl[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            WorkingMemoryImpl workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.tupleSource.updateNewNode(workingMemory, propagationContext);
        }
    }

    public EvalCondition getCondition() {
        return this.condition;
    }

    public void assertTuple(ReteTuple tuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        boolean allowed = this.condition.isAllowed(tuple, workingMemory);
        if (allowed) {
            LinkedList memory = (LinkedList)workingMemory.getNodeMemory(this);
            memory.add(tuple);
            this.propagateAssertTuple(tuple, context, workingMemory);
        }
    }

    public void retractTuple(ReteTuple tuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        LinkedList memory = (LinkedList)workingMemory.getNodeMemory(this);
        if (tuple.getLinkedTuples() != null && !tuple.getLinkedTuples().isEmpty()) {
            memory.remove(tuple);
            this.propagateRetractTuple(tuple, context, workingMemory);
        }
    }

    public void modifyTuple(ReteTuple tuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        boolean allowed;
        boolean exists;
        LinkedList memory = (LinkedList)workingMemory.getNodeMemory(this);
        boolean bl = exists = tuple.getLinkedTuples() != null && !tuple.getLinkedTuples().isEmpty();
        if (exists) {
            memory.remove(tuple);
        }
        if (allowed = this.condition.isAllowed(tuple, workingMemory)) {
            memory.add(tuple);
            if (!exists) {
                this.propagateAssertTuple(tuple, context, workingMemory);
            } else {
                this.propagateModifyTuple(tuple, context, workingMemory);
            }
        } else {
            this.propagateRetractTuple(tuple, context, workingMemory);
        }
    }

    public void updateNewNode(WorkingMemoryImpl workingMemory, PropagationContext context) {
        this.attachingNewNode = true;
        LinkedList memory = (LinkedList)workingMemory.getNodeMemory(this);
        Iterator it = memory.iterator();
        while (it.hasNext()) {
            ReteTuple tuple = (ReteTuple)it.next();
            ReteTuple child = new ReteTuple(tuple);
            tuple.addLinkedTuple(new LinkedListObjectWrapper(child));
            ((TupleSink)this.getTupleSinks().get(this.getTupleSinks().size() - 1)).assertTuple(child, context, workingMemory);
        }
        this.attachingNewNode = false;
    }

    public String toString() {
        return "[ConditionNode: cond=" + this.condition + "]";
    }

    public int hashCode() {
        return this.tupleSource.hashCode() ^ this.condition.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != (class$org$drools$reteoo$EvalConditionNode == null ? (class$org$drools$reteoo$EvalConditionNode = EvalConditionNode.class$("org.drools.reteoo.EvalConditionNode")) : class$org$drools$reteoo$EvalConditionNode)) {
            return false;
        }
        EvalConditionNode other = (EvalConditionNode)object;
        return this.tupleSource.equals(other.tupleSource) && this.condition.equals(other.condition);
    }

    public void remove(BaseNode node, WorkingMemoryImpl[] workingMemories) {
        this.getTupleSinks().remove(node);
        this.removeShare();
        if (this.sharedCount < 0) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
            this.tupleSource.remove(this, workingMemories);
        }
    }

    public Object createMemory() {
        return new LinkedList();
    }

    public List getPropagatedTuples(WorkingMemoryImpl workingMemory, TupleSink sink) {
        LinkedList memory = (LinkedList)workingMemory.getNodeMemory(this);
        int index = this.getTupleSinks().indexOf(sink);
        ArrayList<Object> propagatedTuples = new ArrayList<Object>();
        Iterator it = memory.iterator();
        while (it.hasNext()) {
            ReteTuple leftTuple = (ReteTuple)it.next();
            LinkedList linkedTuples = leftTuple.getLinkedTuples();
            LinkedListObjectWrapper wrapper = (LinkedListObjectWrapper)linkedTuples.getFirst();
            for (int i = 0; i < index; ++i) {
                wrapper = (LinkedListObjectWrapper)wrapper.getNext();
            }
            propagatedTuples.add(wrapper.getObject());
        }
        return propagatedTuples;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

