/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.common.BetaNodeBinder;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.NodeMemory;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.PropagationContext;

abstract class BetaNode
extends TupleSource
implements TupleSink,
ObjectSink,
NodeMemory {
    private final TupleSource leftInput;
    private final ObjectSource rightInput;
    private final BetaNodeBinder joinNodeBinder;

    BetaNode(int id, TupleSource leftInput, ObjectSource rightInput) {
        this(id, leftInput, rightInput, BetaNodeBinder.simpleBinder);
    }

    BetaNode(int id, TupleSource leftInput, ObjectSource rightInput, BetaNodeBinder joinNodeBinder) {
        super(id);
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.joinNodeBinder = joinNodeBinder;
    }

    public void attach() {
        this.leftInput.addTupleSink(this);
        this.rightInput.addObjectSink(this);
    }

    public void attach(WorkingMemoryImpl[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            WorkingMemoryImpl workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.leftInput.updateNewNode(workingMemory, propagationContext);
            this.rightInput.updateNewNode(workingMemory, propagationContext);
        }
    }

    public void remove(BaseNode node, WorkingMemoryImpl[] workingMemories) {
        this.getTupleSinks().remove(node);
        this.removeShare();
        if (this.sharedCount < 0) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
            this.rightInput.remove(this, workingMemories);
            this.leftInput.remove(this, workingMemories);
        }
    }

    BetaNodeBinder getJoinNodeBinder() {
        return this.joinNodeBinder;
    }

    public String toString() {
        return "";
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BetaNode other = (BetaNode)object;
        return this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.joinNodeBinder.equals(other.joinNodeBinder);
    }

    public Object createMemory() {
        return new BetaMemory(this.getJoinNodeBinder());
    }

    public abstract /* synthetic */ void modifyTuple(ReteTuple var1, PropagationContext var2, WorkingMemoryImpl var3);

    public abstract /* synthetic */ void retractTuple(ReteTuple var1, PropagationContext var2, WorkingMemoryImpl var3);

    public abstract /* synthetic */ void assertTuple(ReteTuple var1, PropagationContext var2, WorkingMemoryImpl var3);

    public abstract /* synthetic */ void modifyObject(FactHandleImpl var1, PropagationContext var2, WorkingMemoryImpl var3);

    public abstract /* synthetic */ void retractObject(FactHandleImpl var1, PropagationContext var2, WorkingMemoryImpl var3);

    public abstract /* synthetic */ void assertObject(FactHandleImpl var1, PropagationContext var2, WorkingMemoryImpl var3);
}

