/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.reteoo.AlphaNode;
import org.drools.rule.LiteralConstraint;

public class AlphaNodeSwitch
implements Serializable {
    private final LiteralConstraint constraint;
    private final Map alphaSwitch;

    public AlphaNodeSwitch(LiteralConstraint constraint) {
        this.constraint = constraint;
        this.alphaSwitch = new HashMap();
    }

    public void addAlphaNode(AlphaNode node) {
        LiteralConstraint constraint = (LiteralConstraint)node.getConstraint();
        this.alphaSwitch.put(constraint.getField().getValue(), node);
    }

    public boolean removeAlphaNode(AlphaNode node) {
        LiteralConstraint constraint = (LiteralConstraint)node.getConstraint();
        return this.alphaSwitch.remove(constraint.getField().getValue()) != null;
    }

    public AlphaNode getNode(WorkingMemory workingMemory, InternalFactHandle handle) {
        Object value = this.constraint.getFieldExtractor().getValue(handle.getObject());
        return (AlphaNode)this.alphaSwitch.get(value);
    }

    public int getSwitchCount() {
        return this.alphaSwitch.size();
    }

    public Collection getAllNodes() {
        return this.alphaSwitch.values();
    }

    public boolean equals(Object otherConstraint) {
        if (this == otherConstraint) {
            return true;
        }
        if (otherConstraint != null && otherConstraint instanceof AlphaNodeSwitch) {
            AlphaNodeSwitch other = (AlphaNodeSwitch)otherConstraint;
            if (this.constraint.getEvaluator().getOperator() == other.constraint.getEvaluator().getOperator() && this.constraint.getFieldExtractor().getIndex() == other.constraint.getFieldExtractor().getIndex()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.constraint.getEvaluator().getOperator() * 17 + this.constraint.getFieldExtractor().getIndex();
    }
}

