/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.FactException;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.NodeMemory;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.FieldConstraint;
import org.drools.spi.PropagationContext;

class AlphaNode
extends ObjectSource
implements ObjectSink,
NodeMemory {
    private final FieldConstraint constraint;
    private final ObjectSource objectSource;

    AlphaNode(int id, FieldConstraint constraint, ObjectSource objectSource) {
        super(id);
        this.constraint = constraint;
        this.objectSource = objectSource;
        this.setHasMemory(true);
    }

    public FieldConstraint getConstraint() {
        return this.constraint;
    }

    public void attach() {
        this.objectSource.addObjectSink(this);
    }

    public void attach(WorkingMemoryImpl[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            WorkingMemoryImpl workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.objectSource.updateNewNode(workingMemory, propagationContext);
        }
    }

    public void assertObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) throws FactException {
        Set memory = (Set)workingMemory.getNodeMemory(this);
        if (this.constraint.isAllowed(handle, null, workingMemory)) {
            memory.add(handle);
            this.propagateAssertObject(handle, context, workingMemory);
        }
    }

    public void retractObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) {
        Set memory = (Set)workingMemory.getNodeMemory(this);
        if (memory.remove(handle)) {
            this.propagateRetractObject(handle, context, workingMemory);
        }
    }

    public void modifyObject(FactHandleImpl handle, PropagationContext context, WorkingMemoryImpl workingMemory) {
        Set memory = (Set)workingMemory.getNodeMemory(this);
        if (this.constraint.isAllowed(handle, null, workingMemory)) {
            if (memory.add(handle)) {
                this.propagateAssertObject(handle, context, workingMemory);
            } else {
                this.propagateModifyObject(handle, context, workingMemory);
            }
        } else if (memory.remove(handle)) {
            this.propagateRetractObject(handle, context, workingMemory);
        }
    }

    public void updateNewNode(WorkingMemoryImpl workingMemory, PropagationContext context) {
        this.attachingNewNode = true;
        Set memory = (Set)workingMemory.getNodeMemory(this);
        Iterator it = memory.iterator();
        while (it.hasNext()) {
            FactHandleImpl handle = (FactHandleImpl)it.next();
            ObjectSink sink = this.objectSinks.getLastObjectSink();
            if (sink != null) {
                sink.assertObject(handle, context, workingMemory);
                continue;
            }
            throw new RuntimeException("Possible BUG: trying to propagate an assert to a node that was the last added node");
        }
        this.attachingNewNode = false;
    }

    public Object createMemory() {
        return new HashSet();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AlphaNode other = (AlphaNode)object;
        return this.objectSource.equals(other.objectSource) && this.constraint.equals(other.constraint);
    }

    public int hashCode() {
        return this.objectSource.hashCode() * 17 + (this.constraint != null ? this.constraint.hashCode() : 0);
    }

    public void remove(BaseNode node, WorkingMemoryImpl[] workingMemories) {
        this.objectSinks.remove((ObjectSink)((Object)node));
        this.removeShare();
        if (this.sharedCount < 0) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
            this.objectSource.remove(this, workingMemories);
        }
    }
}

