/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.WorkingMemory;
import org.drools.leaps.ColumnConstraints;
import org.drools.leaps.util.BaseTableIterator;
import org.drools.leaps.util.BaseTableReverseOrderIterator;
import org.drools.leaps.util.ConstrainedFactTableIterator;
import org.drools.leaps.util.TableIterator;
import org.drools.leaps.util.TableRecord;

public class Table
implements Serializable {
    private final TreeMap map;
    protected TableRecord headRecord;
    protected TableRecord tailRecord;
    private boolean empty = true;
    private int count = 0;

    public Table(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    protected void clear() {
        this.headRecord = new TableRecord(null);
        this.empty = true;
        this.count = 0;
        this.map.clear();
    }

    public void add(Object object) {
        boolean foundEqualObject = false;
        TableRecord newRecord = new TableRecord(object);
        if (this.empty) {
            this.headRecord = newRecord;
            this.empty = false;
        } else {
            SortedMap bufMap = this.map.headMap(object);
            try {
                bufMap.firstKey();
                TableRecord bufRec = (TableRecord)this.map.get(bufMap.lastKey());
                if (bufRec.right != null) {
                    bufRec.right.left = newRecord;
                }
                newRecord.right = bufRec.right;
                bufRec.right = newRecord;
                newRecord.left = bufRec;
            }
            catch (NoSuchElementException nsee) {
                this.headRecord.left = newRecord;
                newRecord.right = this.headRecord;
                this.headRecord = newRecord;
            }
        }
        if (!foundEqualObject) {
            if (newRecord.right == null) {
                this.tailRecord = newRecord;
            }
            ++this.count;
            this.map.put(object, newRecord);
        }
    }

    public void remove(Object object) {
        if (!this.empty) {
            TableRecord record = (TableRecord)this.map.get(object);
            if (record != null) {
                if (record == this.headRecord) {
                    if (record.right != null) {
                        this.headRecord = record.right;
                        this.headRecord.left = null;
                    } else {
                        this.tailRecord = this.headRecord = new TableRecord(null);
                        this.empty = true;
                    }
                } else if (record == this.tailRecord) {
                    this.tailRecord = record.left;
                    this.tailRecord.right = null;
                } else {
                    record.left.right = record.right;
                    record.right.left = record.left;
                }
                record.left = null;
                record.right = null;
            }
            --this.count;
            this.map.remove(object);
        }
    }

    public boolean contains(Object object) {
        boolean ret = false;
        if (!this.empty) {
            ret = this.map.containsKey(object);
        }
        return ret;
    }

    public TableIterator iterator() {
        BaseTableIterator ret = this.empty ? new BaseTableIterator(null, null, null) : new BaseTableIterator(this.headRecord, this.headRecord, this.tailRecord);
        return ret;
    }

    public TableIterator reverseOrderIterator() {
        BaseTableReverseOrderIterator ret = this.empty ? new BaseTableReverseOrderIterator(null, null, null) : new BaseTableReverseOrderIterator(this.tailRecord, this.tailRecord, this.headRecord);
        return ret;
    }

    public TableIterator tailConstrainedIterator(WorkingMemory workingMemory, ColumnConstraints constraints, Object objectAtStart, Object objectAtPosition) {
        Markers markers = this.getTailIteratorMarkers(objectAtStart, objectAtPosition);
        return new ConstrainedFactTableIterator(workingMemory, constraints, markers.start, markers.current, markers.last);
    }

    public TableIterator tailIterator(Object objectAtStart, Object objectAtPosition) {
        Markers markers = this.getTailIteratorMarkers(objectAtStart, objectAtPosition);
        return new BaseTableIterator(markers.start, markers.current, markers.last);
    }

    private Markers getTailIteratorMarkers(Object objectAtStart, Object objectAtPosition) {
        Markers ret = new Markers();
        ret.start = null;
        ret.current = null;
        ret.last = null;
        if (this.map.comparator().compare(objectAtStart, objectAtPosition) > 0) {
            return ret;
        }
        TableRecord startRecord = null;
        TableRecord currentRecord = null;
        TableRecord lastRecord = this.tailRecord;
        if (!this.empty && this.map.comparator().compare(objectAtStart, this.tailRecord.object) <= 0) {
            SortedMap bufMap = this.map.tailMap(objectAtStart);
            try {
                bufMap.firstKey();
                startRecord = (TableRecord)bufMap.get(bufMap.firstKey());
                if (this.map.comparator().compare(objectAtStart, objectAtPosition) == 0) {
                    currentRecord = startRecord;
                } else {
                    bufMap = bufMap.tailMap(objectAtPosition);
                    try {
                        bufMap.firstKey();
                        currentRecord = (TableRecord)bufMap.get(bufMap.firstKey());
                    }
                    catch (NoSuchElementException nsee) {
                        currentRecord = startRecord;
                    }
                }
                ret.start = startRecord;
                ret.current = currentRecord;
                ret.last = lastRecord;
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
        }
        return ret;
    }

    public TableIterator headIterator(Object objectAtEnd) {
        Markers markers = this.getHeadIteratorMarkers(objectAtEnd);
        return new BaseTableIterator(markers.start, markers.current, markers.last);
    }

    public TableIterator headReverseOrderIterator(Object objectAtEnd) {
        Markers markers = this.getHeadIteratorMarkers(objectAtEnd);
        return new BaseTableReverseOrderIterator(markers.last, markers.last, markers.start);
    }

    private Markers getHeadIteratorMarkers(Object objectAtEnd) {
        Markers ret = new Markers();
        ret.start = null;
        ret.current = null;
        ret.last = null;
        TableRecord startRecord = this.headRecord;
        TableRecord currentRecord = this.headRecord;
        TableRecord lastRecord = null;
        if (!this.empty && this.map.comparator().compare(this.headRecord.object, objectAtEnd) <= 0) {
            SortedMap bufMap = this.map.headMap(objectAtEnd);
            try {
                bufMap.firstKey();
                lastRecord = (TableRecord)bufMap.get(bufMap.lastKey());
                if (lastRecord.right != null && this.map.comparator().compare(lastRecord.right.object, objectAtEnd) == 0) {
                    lastRecord = lastRecord.right;
                }
                ret.start = startRecord;
                ret.current = currentRecord;
                ret.last = lastRecord;
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String toString() {
        String ret = "";
        TableIterator it = this.iterator();
        while (it.hasNext()) {
            ret = ret + it.next() + "\n";
        }
        return ret;
    }

    public int size() {
        return this.count;
    }

    public Object top() {
        return this.headRecord.object;
    }

    public Object bottom() {
        return this.tailRecord.object;
    }

    public static TableIterator singleItemIterator(Object object) {
        return new BaseTableIterator(new TableRecord(object));
    }

    class Markers {
        TableRecord start;
        TableRecord current;
        TableRecord last;

        Markers() {
        }
    }
}

