/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps.conflict;

import java.util.Comparator;
import org.drools.leaps.conflict.AbstractConflictResolver;

class CompositeConflictResolver
extends AbstractConflictResolver {
    final Comparator[] factResolvers;
    final Comparator[] ruleResolvers;

    public CompositeConflictResolver(Comparator[] factResolvers, Comparator[] ruleResolvers) {
        this.factResolvers = factResolvers;
        this.ruleResolvers = ruleResolvers;
    }

    public final Comparator getFactConflictResolver() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int ret = 0;
                if (o1 != o2) {
                    int length = CompositeConflictResolver.this.factResolvers.length;
                    for (int i = 0; ret == 0 && i < length; ++i) {
                        ret = CompositeConflictResolver.this.factResolvers[i].compare(o1, o2);
                    }
                }
                return ret;
            }
        };
    }

    public final Comparator getRuleConflictResolver() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int ret = 0;
                if (o1 != o2) {
                    int length = CompositeConflictResolver.this.ruleResolvers.length;
                    for (int i = 0; ret == 0 && i < length; ++i) {
                        ret = CompositeConflictResolver.this.ruleResolvers[i].compare(o1, o2);
                    }
                }
                return ret;
            }
        };
    }
}

