/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import org.drools.leaps.ColumnConstraints;
import org.drools.leaps.FactHandleImpl;
import org.drools.leaps.FactTable;
import org.drools.leaps.LeapsRule;
import org.drools.leaps.LeapsTuple;
import org.drools.leaps.NoMatchesFoundException;
import org.drools.leaps.Token;
import org.drools.leaps.WorkingMemoryImpl;
import org.drools.leaps.util.Table;
import org.drools.leaps.util.TableIterator;
import org.drools.rule.EvalCondition;
import org.drools.rule.InvalidRuleException;

final class TokenEvaluator {
    TokenEvaluator() {
    }

    protected static final void evaluate(Token token) throws NoMatchesFoundException, InvalidRuleException {
        WorkingMemoryImpl workingMemory = (WorkingMemoryImpl)token.getWorkingMemory();
        LeapsRule leapsRule = token.getCurrentRuleHandle().getLeapsRule();
        int numberOfColumns = leapsRule.getNumberOfColumns();
        int dominantFactPosition = token.getCurrentRuleHandle().getDominantPosition();
        FactHandleImpl dominantFactHandle = token.getDominantFactHandle();
        if (leapsRule.getColumnConstraintsAtPosition(dominantFactPosition).isAllowedAlpha(dominantFactHandle, token, workingMemory)) {
            TableIterator currentIterator;
            Class dominantClass = leapsRule.getColumnClassObjectTypeAtPosition(dominantFactPosition);
            TableIterator[] iterators = new TableIterator[numberOfColumns];
            for (int i = 0; i < numberOfColumns; ++i) {
                FactHandleImpl startFactHandle;
                if (i == dominantFactPosition) {
                    iterators[i] = Table.singleItemIterator(dominantFactHandle);
                    continue;
                }
                Class columnClass = leapsRule.getColumnClassObjectTypeAtPosition(i);
                ColumnConstraints constraints = leapsRule.getColumnConstraintsAtPosition(i);
                FactTable factTable = workingMemory.getFactTable(columnClass);
                FactHandleImpl factHandleImpl = startFactHandle = dominantClass == columnClass ? new FactHandleImpl(dominantFactHandle.getId() - 1L, null) : dominantFactHandle;
                iterators[i] = i > 0 && constraints.isAlphaPresent() ? factTable.tailConstrainedIterator(workingMemory, constraints, startFactHandle, token.isResume() ? (FactHandleImpl)token.get(i) : startFactHandle) : factTable.tailIterator(startFactHandle, token.isResume() ? (FactHandleImpl)token.get(i) : startFactHandle);
            }
            boolean doReset = false;
            boolean skip = token.isResume();
            for (int i = 0; i < numberOfColumns; ++i) {
                currentIterator = iterators[i];
                if (currentIterator.isEmpty()) {
                    throw new NoMatchesFoundException();
                }
                if (!doReset) {
                    if (!skip || !currentIterator.hasNext() || currentIterator.peekNext().equals(token.get(i))) continue;
                    skip = false;
                    doReset = true;
                    continue;
                }
                currentIterator.reset();
            }
            int jj = 0;
            boolean done = false;
            int stopIteratingCount = numberOfColumns - 1;
            while (!done) {
                currentIterator = iterators[jj];
                if (!currentIterator.hasNext()) {
                    if (jj == 0) {
                        done = true;
                        continue;
                    }
                    currentIterator.reset();
                    --jj;
                    if (!skip) continue;
                    skip = false;
                    continue;
                }
                FactHandleImpl currentFactHandle = (FactHandleImpl)currentIterator.next();
                boolean localMatch = false;
                if (!skip) {
                    localMatch = jj != 0 || jj == dominantFactPosition ? leapsRule.getColumnConstraintsAtPosition(jj).isAllowedBeta(currentFactHandle, token, workingMemory) : leapsRule.getColumnConstraintsAtPosition(jj).isAllowed(currentFactHandle, token, workingMemory);
                }
                if (!localMatch && !skip) continue;
                token.set(jj, currentFactHandle);
                if (jj == stopIteratingCount) {
                    if (!skip) {
                        if (!TokenEvaluator.processAfterAllPositiveConstraintOk(token.getTuple(), leapsRule, workingMemory)) continue;
                        return;
                    }
                    skip = false;
                    continue;
                }
                ++jj;
            }
        }
        throw new NoMatchesFoundException();
    }

    static final boolean processAfterAllPositiveConstraintOk(LeapsTuple tuple, LeapsRule leapsRule, WorkingMemoryImpl workingMemory) {
        if (leapsRule.containsEvalConditions() && !TokenEvaluator.evaluateEvalConditions(leapsRule, tuple, workingMemory)) {
            return false;
        }
        if (leapsRule.containsExistsColumns()) {
            TokenEvaluator.evaluateExistsConditions(tuple, leapsRule, workingMemory);
        }
        if (leapsRule.containsNotColumns()) {
            TokenEvaluator.evaluateNotConditions(tuple, leapsRule, workingMemory);
        }
        Class[] classes = leapsRule.getExistsNotColumnsClasses();
        int length = classes.length;
        for (int i = 0; i < length; ++i) {
            workingMemory.getFactTable(classes[i]).addTuple(tuple);
        }
        if (tuple.isReadyForActivation()) {
            workingMemory.assertTuple(tuple);
            return true;
        }
        return false;
    }

    private static final boolean evaluateEvalConditions(LeapsRule leapsRule, LeapsTuple tuple, WorkingMemoryImpl workingMemory) {
        EvalCondition[] evals = leapsRule.getEvalConditions();
        for (int i = 0; i < evals.length; ++i) {
            if (evals[i].isAllowed(tuple, workingMemory)) continue;
            return false;
        }
        return true;
    }

    static final void evaluateNotConditions(LeapsTuple tuple, LeapsRule rule, WorkingMemoryImpl workingMemory) {
        ColumnConstraints[] not = rule.getNotColumnConstraints();
        int length = not.length;
        for (int i = 0; i < length; ++i) {
            ColumnConstraints constraint = not[i];
            TableIterator tableIterator = workingMemory.getFactTable(constraint.getClassType()).reverseOrderIterator();
            boolean done = false;
            while (!done && tableIterator.hasNext()) {
                FactHandleImpl factHandle = (FactHandleImpl)tableIterator.next();
                if (!constraint.isAllowed(factHandle, tuple, workingMemory)) continue;
                tuple.setBlockingNotFactHandle(factHandle, i);
                factHandle.addNotTuple(tuple, i);
                done = true;
            }
        }
    }

    static final void evaluateNotCondition(FactHandleImpl startFactHandle, int index, LeapsTuple tuple, WorkingMemoryImpl workingMemory) {
        LeapsRule rule = tuple.getLeapsRule();
        ColumnConstraints constraint = rule.getNotColumnConstraints()[index];
        TableIterator tableIterator = workingMemory.getFactTable(constraint.getClassType()).headReverseOrderIterator(startFactHandle);
        boolean done = false;
        while (!done && tableIterator.hasNext()) {
            FactHandleImpl factHandle = (FactHandleImpl)tableIterator.next();
            if (!constraint.isAllowed(factHandle, tuple, workingMemory)) continue;
            tuple.setBlockingNotFactHandle(factHandle, index);
            factHandle.addNotTuple(tuple, index);
            done = true;
        }
    }

    private static final void evaluateExistsConditions(LeapsTuple tuple, LeapsRule rule, WorkingMemoryImpl workingMemory) {
        ColumnConstraints[] exists = rule.getExistsColumnConstraints();
        int length = exists.length;
        for (int i = 0; i < length; ++i) {
            ColumnConstraints constraint = exists[i];
            TableIterator tableIterator = workingMemory.getFactTable(constraint.getClassType()).reverseOrderIterator();
            boolean done = false;
            while (!done && tableIterator.hasNext()) {
                FactHandleImpl factHandle = (FactHandleImpl)tableIterator.next();
                if (!constraint.isAllowed(factHandle, tuple, workingMemory)) continue;
                tuple.setExistsFactHandle(factHandle, i);
                factHandle.addExistsTuple(tuple, i);
                done = true;
            }
        }
    }

    static final void evaluateExistsCondition(FactHandleImpl startFactHandle, int index, LeapsTuple tuple, WorkingMemoryImpl workingMemory) {
        LeapsRule rule = tuple.getLeapsRule();
        ColumnConstraints constraint = rule.getExistsColumnConstraints()[index];
        TableIterator tableIterator = workingMemory.getFactTable(constraint.getClassType()).headReverseOrderIterator(startFactHandle);
        boolean done = false;
        while (!done && tableIterator.hasNext()) {
            FactHandleImpl factHandle = (FactHandleImpl)tableIterator.next();
            if (!constraint.isAllowed(factHandle, tuple, workingMemory)) continue;
            tuple.setExistsFactHandle(factHandle, index);
            factHandle.addExistsTuple(tuple, index);
            done = true;
        }
    }
}

