/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.io.Serializable;
import java.util.Iterator;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.common.PropagationContextImpl;
import org.drools.leaps.FactHandleImpl;
import org.drools.leaps.LeapsTuple;
import org.drools.leaps.RuleHandle;
import org.drools.leaps.WorkingMemoryImpl;
import org.drools.leaps.util.TableIterator;
import org.drools.rule.Declaration;
import org.drools.spi.Activation;
import org.drools.spi.Tuple;

public class Token
implements Tuple,
Serializable {
    private static final long serialVersionUID = 1L;
    private WorkingMemoryImpl workingMemory;
    private final FactHandleImpl dominantFactHandle;
    private RuleHandle currentRuleHandle = null;
    private FactHandleImpl[] currentFactHandles = new FactHandleImpl[0];
    boolean resume = false;
    private Iterator rules = null;
    private final PropagationContextImpl propagationContext;

    public Token(WorkingMemoryImpl workingMemory, FactHandleImpl factHandle, PropagationContextImpl propagationContext) {
        this.workingMemory = workingMemory;
        this.dominantFactHandle = factHandle;
        this.propagationContext = propagationContext;
    }

    private Iterator rulesIterator() {
        if (this.rules == null && this.dominantFactHandle != null) {
            this.rules = this.workingMemory.getFactTable(this.dominantFactHandle.getObject().getClass()).getRulesIterator();
        }
        return this.rules;
    }

    public RuleHandle nextRuleHandle() {
        this.currentRuleHandle = (RuleHandle)this.rules.next();
        this.currentFactHandles = new FactHandleImpl[this.currentRuleHandle.getLeapsRule().getNumberOfColumns()];
        return this.currentRuleHandle;
    }

    public boolean hasNextRuleHandle() {
        boolean ret = false;
        if (this.rulesIterator() != null) {
            long levelId = this.workingMemory.getIdLastFireAllAt();
            if (this.dominantFactHandle == null || this.dominantFactHandle.getId() >= levelId) {
                ret = this.rules.hasNext();
            } else {
                boolean done = false;
                while (!done) {
                    if (this.rules.hasNext()) {
                        if (((RuleHandle)((TableIterator)this.rules).peekNext()).getId() > levelId) {
                            ret = true;
                            done = true;
                            continue;
                        }
                        this.rules.next();
                        continue;
                    }
                    ret = false;
                    done = true;
                }
            }
        }
        return ret;
    }

    public int hashCode() {
        if (this.dominantFactHandle != null) {
            return this.dominantFactHandle.hashCode();
        }
        return 0;
    }

    public void set(int idx, FactHandleImpl factHandle) {
        this.currentFactHandles[idx] = factHandle;
    }

    public FactHandleImpl getDominantFactHandle() {
        return this.dominantFactHandle;
    }

    public RuleHandle getCurrentRuleHandle() {
        return this.currentRuleHandle;
    }

    public boolean isResume() {
        return this.resume;
    }

    public void setResume(boolean resume) {
        this.resume = resume;
    }

    public boolean equals(Object that) {
        return this.dominantFactHandle.getId() == ((Token)that).dominantFactHandle.getId();
    }

    public InternalFactHandle get(int idx) {
        return this.currentFactHandles[idx];
    }

    public InternalFactHandle get(Declaration declaration) {
        return this.get(declaration.getColumn());
    }

    public InternalFactHandle[] getFactHandles() {
        return this.currentFactHandles;
    }

    public long getRecency() {
        return 0L;
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public String toString() {
        String ret = "TOKEN [" + this.dominantFactHandle + "]\n" + "\tRULE : " + this.currentRuleHandle + "\n";
        if (this.currentFactHandles != null) {
            int length = this.currentFactHandles.length;
            for (int i = 0; i < length; ++i) {
                ret = ret + (i == this.currentRuleHandle.getDominantPosition() ? "***" : "") + "\t" + i + " -> " + this.currentFactHandles[i].getObject() + "\n";
            }
        }
        return ret;
    }

    LeapsTuple getTuple() {
        return new LeapsTuple(this.currentFactHandles, this.currentRuleHandle.getLeapsRule(), this.propagationContext);
    }

    public boolean dependsOn(FactHandle handle) {
        int length = this.currentFactHandles.length;
        for (int i = 0; i < length; ++i) {
            if (!this.currentFactHandles[i].equals(handle)) continue;
            return true;
        }
        return false;
    }

    public void setActivation(Activation activation) {
    }

    public PropagationContextImpl getPropagationContext() {
        return this.propagationContext;
    }
}

