/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.event.ObjectAssertedEvent;
import org.drools.event.ObjectModifiedEvent;
import org.drools.event.ObjectRetractedEvent;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.spi.PropagationContext;

public class WorkingMemoryEventSupport
implements Serializable {
    private final List listeners = Collections.synchronizedList(new ArrayList());
    private final WorkingMemory workingMemory;

    public WorkingMemoryEventSupport(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public void addEventListener(WorkingMemoryEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(WorkingMemoryEventListener listener) {
        this.listeners.remove(listener);
    }

    public List getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireObjectAsserted(PropagationContext propagationContext, FactHandle handle, Object object) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectAssertedEvent event = new ObjectAssertedEvent(this.workingMemory, propagationContext, handle, object);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((WorkingMemoryEventListener)this.listeners.get(i)).objectAsserted(event);
        }
    }

    public void fireObjectModified(PropagationContext propagationContext, FactHandle handle, Object oldObject, Object object) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectModifiedEvent event = new ObjectModifiedEvent(this.workingMemory, propagationContext, handle, oldObject, object);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((WorkingMemoryEventListener)this.listeners.get(i)).objectModified(event);
        }
    }

    public void fireObjectRetracted(PropagationContext propagationContext, FactHandle handle, Object oldObject) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectRetractedEvent event = new ObjectRetractedEvent(this.workingMemory, propagationContext, handle, oldObject);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((WorkingMemoryEventListener)this.listeners.get(i)).objectRetracted(event);
        }
    }
}

