/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Declaration;
import org.drools.spi.FieldConstraint;
import org.drools.spi.Tuple;

public class BetaNodeBinder
implements Serializable {
    public static final BetaNodeBinder simpleBinder = new BetaNodeBinder();
    private final FieldConstraint[] constraints;
    private static final FieldConstraint[] EMPTY_CONSTRAINTS = new FieldConstraint[0];

    public BetaNodeBinder() {
        this.constraints = EMPTY_CONSTRAINTS;
    }

    public BetaNodeBinder(FieldConstraint constraint) {
        this.constraints = new FieldConstraint[]{constraint};
    }

    public BetaNodeBinder(FieldConstraint[] constraints) {
        this.constraints = constraints;
    }

    public boolean isAllowed(InternalFactHandle handle, Tuple tuple, WorkingMemory workingMemory) {
        if (this.constraints == null) {
            return true;
        }
        for (int i = 0; i < this.constraints.length; ++i) {
            if (this.constraints[i].isAllowed(handle, tuple, workingMemory)) continue;
            return false;
        }
        return true;
    }

    public Set getRequiredDeclarations() {
        HashSet<Declaration> declarations = new HashSet<Declaration>();
        for (int i = 0; i < this.constraints.length; ++i) {
            Declaration[] array = this.constraints[i].getRequiredDeclarations();
            for (int j = 0; j < array.length; ++j) {
                declarations.add(array[j]);
            }
        }
        return declarations;
    }

    public int hashCode() {
        return this.constraints.hashCode();
    }

    public FieldConstraint[] getConstraints() {
        return this.constraints;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BetaNodeBinder other = (BetaNodeBinder)object;
        if (this.constraints == other.constraints) {
            return true;
        }
        if (this.constraints.length != other.constraints.length) {
            return false;
        }
        for (int i = 0; i < this.constraints.length; ++i) {
            if (this.constraints[i].equals(other.constraints[i])) continue;
            return false;
        }
        return true;
    }
}

