/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.drools.PackageIntegrationException;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.ObjectInputStreamWithLoader;
import org.drools.rule.CompositePackageClassLoader;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Package;
import org.drools.rule.PackageCompilationData;
import org.drools.rule.Rule;
import org.drools.spi.FactHandleFactory;

public abstract class AbstractRuleBase
implements RuleBase,
Externalizable {
    private Map pkgs;
    private transient CompositePackageClassLoader packageClassLoader;
    private FactHandleFactory factHandleFactory;
    private Map globals;
    private transient Map workingMemories;
    private static final Object PRESENT = new Object();

    public AbstractRuleBase(FactHandleFactory factHandleFactory) {
        this.factHandleFactory = factHandleFactory;
        this.packageClassLoader = new CompositePackageClassLoader(Thread.currentThread().getContextClassLoader());
        this.pkgs = new HashMap();
        this.globals = new HashMap();
        this.workingMemories = new WeakHashMap();
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeObject(this.pkgs);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this.factHandleFactory);
        out.writeObject(this.globals);
        stream.writeObject(bos.toByteArray());
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        this.pkgs = (Map)stream.readObject();
        this.packageClassLoader = new CompositePackageClassLoader(Thread.currentThread().getContextClassLoader());
        Iterator it = this.pkgs.values().iterator();
        while (it.hasNext()) {
            this.packageClassLoader.addClassLoader(((Package)it.next()).getPackageCompilationData().getClassLoader());
        }
        byte[] bytes = (byte[])stream.readObject();
        ObjectInputStreamWithLoader streamWithLoader = new ObjectInputStreamWithLoader(new ByteArrayInputStream(bytes), this.packageClassLoader);
        this.factHandleFactory = (FactHandleFactory)streamWithLoader.readObject();
        this.globals = (Map)streamWithLoader.readObject();
        this.workingMemories = new WeakHashMap();
    }

    public WorkingMemory newWorkingMemory() {
        return this.newWorkingMemory(true);
    }

    public abstract WorkingMemory newWorkingMemory(boolean var1);

    public void disposeWorkingMemory(WorkingMemory workingMemory) {
        this.workingMemories.remove(workingMemory);
    }

    public FactHandleFactory getFactHandleFactory() {
        return this.factHandleFactory;
    }

    public FactHandleFactory newFactHandleFactory() {
        return this.factHandleFactory.newInstance();
    }

    public Package[] getPackages() {
        return this.pkgs.values().toArray(new Package[this.pkgs.size()]);
    }

    public Map getGlobals() {
        return this.globals;
    }

    public void addPackage(Package newPkg) throws PackageIntegrationException {
        newPkg.checkValidity();
        Package pkg = (Package)this.pkgs.get(newPkg.getName());
        Iterator it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)it.next();
            workingMemory.getLock().lock();
        }
        if (pkg != null) {
            this.mergePackage(pkg, newPkg);
        } else {
            this.pkgs.put(newPkg.getName(), newPkg);
        }
        Map newGlobals = newPkg.getGlobals();
        Iterator it2 = newGlobals.keySet().iterator();
        while (it2.hasNext()) {
            String identifier = (String)it2.next();
            Class type = (Class)newGlobals.get(identifier);
            if (!this.globals.containsKey(identifier) || this.globals.get(identifier).equals(type)) continue;
            throw new PackageIntegrationException(pkg);
        }
        this.globals.putAll(newGlobals);
        Rule[] rules = newPkg.getRules();
        for (int i = 0; i < rules.length; ++i) {
            this.addRule(rules[i]);
        }
        this.packageClassLoader.addClassLoader(newPkg.getPackageCompilationData().getClassLoader());
        Iterator it3 = this.workingMemories.keySet().iterator();
        while (it3.hasNext()) {
            AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)it3.next();
            workingMemory.fireAllRules();
            workingMemory.getLock().unlock();
        }
    }

    private void mergePackage(Package pkg, Package newPkg) throws PackageIntegrationException {
        Map globals = pkg.getGlobals();
        List imports = pkg.getImports();
        PackageCompilationData compilationData = pkg.getPackageCompilationData();
        PackageCompilationData newCompilationData = newPkg.getPackageCompilationData();
        String[] files = newCompilationData.list();
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            compilationData.write(files[i], newCompilationData.read(files[i]));
        }
        imports.addAll(newPkg.getImports());
        compilationData.putAllInvokers(newCompilationData.getInvokers());
        Iterator it = globals.keySet().iterator();
        while (it.hasNext()) {
            String identifier = (String)it.next();
            Class type = (Class)globals.get(identifier);
            if (!globals.containsKey(identifier) || globals.get(identifier).equals(type)) continue;
            throw new PackageIntegrationException("Unable to merge new Package", newPkg);
        }
    }

    protected void addRule(Rule rule) throws InvalidPatternException {
        if (!rule.isValid()) {
            throw new IllegalArgumentException("The rule called " + rule.getName() + " is not valid. Check for compile errors reported.");
        }
    }

    public void removePackage(String packageName) {
        Package pkg = (Package)this.pkgs.get(packageName);
        Iterator it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)it.next();
            workingMemory.getLock().lock();
        }
        Rule[] rules = pkg.getRules();
        for (int i = 0; i < rules.length; ++i) {
            this.removeRule(rules[i]);
        }
        this.packageClassLoader.removeClassLoader(pkg.getPackageCompilationData().getClassLoader());
        pkg.clear();
        Iterator it2 = this.workingMemories.keySet().iterator();
        while (it2.hasNext()) {
            AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)it2.next();
            workingMemory.getLock().unlock();
        }
    }

    public void removeRule(String packageName, String ruleName) {
        AbstractWorkingMemory workingMemory;
        Package pkg = (Package)this.pkgs.get(packageName);
        Rule rule = pkg.getRule(ruleName);
        Iterator it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            workingMemory = (AbstractWorkingMemory)it.next();
            workingMemory.getLock().lock();
        }
        this.removeRule(rule);
        pkg.removeRule(rule);
        it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            workingMemory = (AbstractWorkingMemory)it.next();
            workingMemory.getLock().unlock();
        }
    }

    protected abstract void removeRule(Rule var1);

    protected void addWorkingMemory(WorkingMemory workingMemory, boolean keepReference) {
        if (keepReference) {
            this.workingMemories.put(workingMemory, PRESENT);
        }
    }

    public Set getWorkingMemories() {
        return this.workingMemories.keySet();
    }
}

