/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class IntegerFactory {
    public static Evaluator getIntegerEvaluator(int operator) {
        switch (operator) {
            case 1: {
                return IntegerEqualEvaluator.INSTANCE;
            }
            case 10: {
                return IntegerNotEqualEvaluator.INSTANCE;
            }
            case 20: {
                return IntegerLessEvaluator.INSTANCE;
            }
            case 30: {
                return IntegerLessOrEqualEvaluator.INSTANCE;
            }
            case 40: {
                return IntegerGreaterEvaluator.INSTANCE;
            }
            case 50: {
                return IntegerGreaterOrEqualEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for IntegerEvaluator");
    }

    static class IntegerGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final Evaluator INSTANCE = new IntegerGreaterOrEqualEvaluator();

        private IntegerGreaterOrEqualEvaluator() {
            super(130, 50);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).intValue() >= ((Number)object2).intValue();
        }

        public String toString() {
            return "Integer >=";
        }
    }

    static class IntegerGreaterEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new IntegerGreaterEvaluator();

        private IntegerGreaterEvaluator() {
            super(130, 40);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).intValue() > ((Number)object2).intValue();
        }

        public String toString() {
            return "Integer >";
        }
    }

    static class IntegerLessOrEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new IntegerLessOrEqualEvaluator();

        private IntegerLessOrEqualEvaluator() {
            super(130, 30);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).intValue() <= ((Number)object2).intValue();
        }

        public String toString() {
            return "Integer <=";
        }
    }

    static class IntegerLessEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new IntegerLessEvaluator();

        private IntegerLessEvaluator() {
            super(130, 20);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).intValue() < ((Number)object2).intValue();
        }

        public String toString() {
            return "Integer <";
        }
    }

    static class IntegerNotEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new IntegerNotEqualEvaluator();

        private IntegerNotEqualEvaluator() {
            super(130, 10);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 != null;
            }
            return !((Number)object1).equals(object2);
        }

        public String toString() {
            return "Integer !=";
        }
    }

    static class IntegerEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new IntegerEqualEvaluator();

        private IntegerEqualEvaluator() {
            super(130, 1);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return ((Number)object1).equals(object2);
        }

        public String toString() {
            return "Integer ==";
        }
    }
}

