/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class DateFactory {
    private static final String DEFAULT_FORMAT_MASK = "dd-MMM-yyyy";
    private static String DATE_FORMAT_MASK = DateFactory.getDateFormatMask();

    public static Evaluator getDateEvaluator(int operator) {
        switch (operator) {
            case 1: {
                return DateEqualEvaluator.INSTANCE;
            }
            case 10: {
                return DateNotEqualEvaluator.INSTANCE;
            }
            case 20: {
                return DateLessEvaluator.INSTANCE;
            }
            case 30: {
                return DateLessOrEqualEvaluator.INSTANCE;
            }
            case 40: {
                return DateGreaterEvaluator.INSTANCE;
            }
            case 50: {
                return DateGreaterOrEqualEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for DateEvaluator");
    }

    private static Date parseDate(String input) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_MASK);
        try {
            return df.parse(input);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid date input format: [" + input + "] it should follow: [" + DATE_FORMAT_MASK + "]");
        }
    }

    private static Date getRightDate(Object object2) {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof String) {
            return DateFactory.parseDate((String)object2);
        }
        if (object2 instanceof Date) {
            return (Date)object2;
        }
        throw new IllegalArgumentException("Unable to convert " + object2.getClass() + " to a Date.");
    }

    private static String getDateFormatMask() {
        String fmt = System.getProperty("drools.dateformat");
        if (fmt == null) {
            fmt = DEFAULT_FORMAT_MASK;
        }
        return fmt;
    }

    static class DateGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final Evaluator INSTANCE = new DateGreaterOrEqualEvaluator();

        private DateGreaterOrEqualEvaluator() {
            super(190, 50);
        }

        public boolean evaluate(Object object1, Object object2) {
            Date left = (Date)object1;
            return left.compareTo(DateFactory.getRightDate(object2)) >= 0;
        }

        public String toString() {
            return "Date >=";
        }
    }

    static class DateGreaterEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new DateGreaterEvaluator();

        private DateGreaterEvaluator() {
            super(190, 40);
        }

        public boolean evaluate(Object object1, Object object2) {
            Date left = (Date)object1;
            return left.compareTo(DateFactory.getRightDate(object2)) > 0;
        }

        public String toString() {
            return "Date >";
        }
    }

    static class DateLessOrEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new DateLessOrEqualEvaluator();

        private DateLessOrEqualEvaluator() {
            super(190, 30);
        }

        public boolean evaluate(Object object1, Object object2) {
            Date left = (Date)object1;
            return left.compareTo(DateFactory.getRightDate(object2)) <= 0;
        }

        public String toString() {
            return "Date <=";
        }
    }

    static class DateLessEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new DateLessEvaluator();

        private DateLessEvaluator() {
            super(190, 20);
        }

        public boolean evaluate(Object object1, Object object2) {
            Date left = (Date)object1;
            return left.compareTo(DateFactory.getRightDate(object2)) < 0;
        }

        public String toString() {
            return "Date <";
        }
    }

    static class DateNotEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new DateNotEqualEvaluator();

        private DateNotEqualEvaluator() {
            super(190, 10);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 != null;
            }
            if (object2 == null) {
                return true;
            }
            Date left = (Date)object1;
            return left.compareTo(DateFactory.getRightDate(object2)) != 0;
        }

        public String toString() {
            return "Date !=";
        }
    }

    static class DateEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new DateEqualEvaluator();

        private DateEqualEvaluator() {
            super(190, 1);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            if (object2 == null) {
                return false;
            }
            Date left = (Date)object1;
            return left.compareTo(DateFactory.getRightDate(object2)) == 0;
        }

        public String toString() {
            return "Date ==";
        }
    }
}

