/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class CharacterFactory {
    public static Evaluator getCharacterEvaluator(int operator) {
        switch (operator) {
            case 1: {
                return CharacterEqualEvaluator.INSTANCE;
            }
            case 10: {
                return CharacterNotEqualEvaluator.INSTANCE;
            }
            case 20: {
                return CharacterLessEvaluator.INSTANCE;
            }
            case 30: {
                return CharacterLessOrEqualEvaluator.INSTANCE;
            }
            case 40: {
                return CharacterGreaterEvaluator.INSTANCE;
            }
            case 50: {
                return CharacterGreaterOrEqualEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for CharacterEvaluator");
    }

    static class CharacterGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final Evaluator INSTANCE = new CharacterGreaterOrEqualEvaluator();

        private CharacterGreaterOrEqualEvaluator() {
            super(100, 50);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Character)object1).charValue() >= ((Character)object2).charValue();
        }

        public String toString() {
            return "Character >=";
        }
    }

    static class CharacterGreaterEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new CharacterGreaterEvaluator();

        private CharacterGreaterEvaluator() {
            super(100, 40);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Character)object1).charValue() > ((Character)object2).charValue();
        }

        public String toString() {
            return "Character >";
        }
    }

    static class CharacterLessOrEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new CharacterLessOrEqualEvaluator();

        private CharacterLessOrEqualEvaluator() {
            super(100, 30);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Character)object1).charValue() <= ((Character)object2).charValue();
        }

        public String toString() {
            return "Character <=";
        }
    }

    static class CharacterLessEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new CharacterLessEvaluator();

        private CharacterLessEvaluator() {
            super(100, 20);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Character)object1).charValue() < ((Character)object2).charValue();
        }

        public String toString() {
            return "Character <";
        }
    }

    static class CharacterNotEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new CharacterNotEqualEvaluator();

        private CharacterNotEqualEvaluator() {
            super(100, 10);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 != null;
            }
            return !((Character)object1).equals(object2);
        }

        public String toString() {
            return "Character !=";
        }
    }

    static class CharacterEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new CharacterEqualEvaluator();

        private CharacterEqualEvaluator() {
            super(100, 1);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return ((Character)object1).equals(object2);
        }

        public String toString() {
            return "Character ==";
        }
    }
}

