/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class ByteFactory {
    public static Evaluator getByteEvaluator(int operator) {
        switch (operator) {
            case 1: {
                return ByteEqualEvaluator.INSTANCE;
            }
            case 10: {
                return ByteNotEqualEvaluator.INSTANCE;
            }
            case 20: {
                return ByteLessEvaluator.INSTANCE;
            }
            case 30: {
                return ByteLessOrEqualEvaluator.INSTANCE;
            }
            case 40: {
                return ByteGreaterEvaluator.INSTANCE;
            }
            case 50: {
                return ByteGreaterOrEqualEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for ByteEvaluator");
    }

    static class ByteGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final Evaluator INSTANCE = new ByteGreaterOrEqualEvaluator();

        private ByteGreaterOrEqualEvaluator() {
            super(110, 50);
        }

        public boolean evaluate(Object object1, Object object2) {
            return (Byte)object1 >= (Byte)object2;
        }

        public String toString() {
            return "Byte >=";
        }
    }

    static class ByteGreaterEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new ByteGreaterEvaluator();

        private ByteGreaterEvaluator() {
            super(110, 40);
        }

        public boolean evaluate(Object object1, Object object2) {
            return (Byte)object1 > (Byte)object2;
        }

        public String toString() {
            return "Byte >";
        }
    }

    static class ByteLessOrEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new ByteLessOrEqualEvaluator();

        private ByteLessOrEqualEvaluator() {
            super(110, 30);
        }

        public boolean evaluate(Object object1, Object object2) {
            return (Byte)object1 <= (Byte)object2;
        }

        public String toString() {
            return "Byte <=";
        }
    }

    static class ByteLessEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new ByteLessEvaluator();

        private ByteLessEvaluator() {
            super(110, 20);
        }

        public boolean evaluate(Object object1, Object object2) {
            return (Byte)object1 < (Byte)object2;
        }

        public String toString() {
            return "Byte <";
        }
    }

    static class ByteNotEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new ByteNotEqualEvaluator();

        private ByteNotEqualEvaluator() {
            super(110, 10);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 != null;
            }
            return !((Byte)object1).equals(object2);
        }

        public String toString() {
            return "Byte !=";
        }
    }

    static class ByteEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new ByteEqualEvaluator();

        private ByteEqualEvaluator() {
            super(110, 1);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return ((Byte)object1).equals(object2);
        }

        public String toString() {
            return "Byte ==";
        }
    }
}

