/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import org.drools.base.evaluators.ArrayFactory;
import org.drools.base.evaluators.BooleanFactory;
import org.drools.base.evaluators.ByteFactory;
import org.drools.base.evaluators.CharacterFactory;
import org.drools.base.evaluators.DateFactory;
import org.drools.base.evaluators.DoubleFactory;
import org.drools.base.evaluators.FloatFactory;
import org.drools.base.evaluators.IntegerFactory;
import org.drools.base.evaluators.LongFactory;
import org.drools.base.evaluators.ObjectFactory;
import org.drools.base.evaluators.ShortFactory;
import org.drools.base.evaluators.StringFactory;
import org.drools.spi.Evaluator;

public class EvaluatorFactory {
    private static final EvaluatorFactory INSTANCE = new EvaluatorFactory();

    public static EvaluatorFactory getInstance() {
        return INSTANCE;
    }

    private EvaluatorFactory() {
    }

    public static Evaluator getEvaluator(int type, String operator) {
        Evaluator evaluator = null;
        if (operator.equals("==")) {
            evaluator = EvaluatorFactory.getEvaluator(type, 1);
        } else if (operator.equals("!=")) {
            evaluator = EvaluatorFactory.getEvaluator(type, 10);
        } else if (operator.equals("<")) {
            evaluator = EvaluatorFactory.getEvaluator(type, 20);
        } else if (operator.equals("<=")) {
            evaluator = EvaluatorFactory.getEvaluator(type, 30);
        } else if (operator.equals(">")) {
            evaluator = EvaluatorFactory.getEvaluator(type, 40);
        } else if (operator.equals(">=")) {
            evaluator = EvaluatorFactory.getEvaluator(type, 50);
        } else if (operator.equals("contains")) {
            evaluator = EvaluatorFactory.getEvaluator(type, 60);
        } else if (operator.equals("matches")) {
            evaluator = EvaluatorFactory.getEvaluator(type, 70);
        } else if (operator.equals("excludes")) {
            evaluator = EvaluatorFactory.getEvaluator(type, 80);
        } else {
            throw new IllegalArgumentException("Unknown operator: '" + operator + "'");
        }
        return evaluator;
    }

    public static Evaluator getEvaluator(int type, int operator) {
        switch (type) {
            case 180: {
                return StringFactory.getStringEvaluator(operator);
            }
            case 210: {
                return ObjectFactory.getObjectEvaluator(operator);
            }
            case 120: {
                return ShortFactory.getShortEvaluator(operator);
            }
            case 130: {
                return IntegerFactory.getIntegerEvaluator(operator);
            }
            case 170: {
                return BooleanFactory.getBooleanEvaluator(operator);
            }
            case 160: {
                return DoubleFactory.getDoubleEvaluator(operator);
            }
            case 100: {
                return CharacterFactory.getCharacterEvaluator(operator);
            }
            case 110: {
                return ByteFactory.getByteEvaluator(operator);
            }
            case 150: {
                return FloatFactory.getFloatEvaluator(operator);
            }
            case 140: {
                return LongFactory.getLongEvaluator(operator);
            }
            case 190: {
                return DateFactory.getDateEvaluator(operator);
            }
            case 200: {
                return ArrayFactory.getArrayEvaluator(operator);
            }
        }
        throw new RuntimeException("Type '" + type + "' does not exist for BaseEvaluatorFactory");
    }
}

