/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.asm.ClassWriter;
import org.drools.asm.Label;
import org.drools.asm.MethodVisitor;
import org.drools.base.BaseClassFieldExtractor;
import org.drools.base.ClassObjectType;
import org.drools.util.asm.ClassFieldInspector;

public class ClassFieldExtractorFactory {
    private static final String GETTER = "get";
    private static final String BOOLEAN_GETTER = "is";
    private static final String BASE_PACKAGE = "org/drools/base";
    private static final String BASE_EXTRACTOR = "org/drools/base/BaseClassFieldExtractor";
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static BaseClassFieldExtractor getClassFieldExtractor(Class clazz, String fieldName) {
        try {
            ClassFieldInspector inspector = new ClassFieldInspector(clazz);
            Class fieldType = (Class)inspector.getFieldTypes().get(fieldName);
            String originalClassName = clazz.getName().replace('.', '/');
            String getterName = ((Method)inspector.getGetterMethods().get(fieldName)).getName();
            String className = "org/drools/base/" + originalClassName + "$" + getterName;
            String typeName = ClassFieldExtractorFactory.getTypeName(fieldType);
            byte[] bytes = ClassFieldExtractorFactory.dump(originalClassName, className, getterName, typeName, fieldType, clazz.isInterface());
            ByteArrayClassLoader classLoader = new ByteArrayClassLoader(Thread.currentThread().getContextClassLoader());
            Class newClass = classLoader.defineClass(className.replace('/', '.'), bytes);
            Object[] params = new Object[]{clazz, fieldName};
            return (BaseClassFieldExtractor)newClass.getConstructors()[0].newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    private static byte[] dump(String originalClassName, String className, String getterName, String typeName, Class fieldType, boolean isInterface) throws Exception {
        ClassWriter cw = new ClassWriter(true);
        cw.visit(46, 33, className, null, BASE_EXTRACTOR, null);
        cw.visitSource(null, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/Class;Ljava/lang/String;)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(10, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, BASE_EXTRACTOR, "<init>", "(Ljava/lang/Class;Ljava/lang/String;)V");
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(11, l1);
        mv.visitInsn(177);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l2, 0);
        mv.visitLocalVariable("clazz", "Ljava/lang/Class;", null, l0, l2, 1);
        mv.visitLocalVariable("fieldName", "Ljava/lang/String;", null, l0, l2, 2);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        if (fieldType.isPrimitive()) {
            String primitiveTypeTag = ClassFieldExtractorFactory.getPrimitiveTag(fieldType);
            mv = cw.visitMethod(1, "getValue", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            mv.visitCode();
            Label l02 = new Label();
            mv.visitLabel(l02);
            mv.visitLineNumber(14, l02);
            mv.visitTypeInsn(187, typeName);
            mv.visitInsn(89);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, originalClassName);
            if (isInterface) {
                mv.visitMethodInsn(185, originalClassName, getterName, "()" + primitiveTypeTag);
            } else {
                mv.visitMethodInsn(182, originalClassName, getterName, "()" + primitiveTypeTag);
            }
            mv.visitMethodInsn(183, typeName, "<init>", "(" + primitiveTypeTag + ")V");
            mv.visitInsn(176);
            Label l12 = new Label();
            mv.visitLabel(l12);
            mv.visitLocalVariable("this", "L" + className + ";", null, l02, l12, 0);
            mv.visitLocalVariable("object", "Ljava/lang/Object;", null, l02, l12, 1);
            mv.visitMaxs(3, 2);
            mv.visitEnd();
        } else {
            mv = cw.visitMethod(1, "getValue", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(15, l0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, originalClassName);
            if (isInterface) {
                mv.visitMethodInsn(185, originalClassName, getterName, "()L" + typeName + ";");
            } else {
                mv.visitMethodInsn(182, originalClassName, getterName, "()L" + typeName + ";");
            }
            mv.visitInsn(176);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "L" + className + ";", null, l0, l1, 0);
            mv.visitLocalVariable("object", "Ljava/lang/Object;", null, l0, l1, 1);
            mv.visitMaxs(1, 2);
            mv.visitEnd();
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected static ClassObjectType getClassObjectType(Class fieldType) throws IntrospectionException {
        Class returnClass = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Character.TYPE) {
                returnClass = class$java$lang$Character == null ? (class$java$lang$Character = ClassFieldExtractorFactory.class$("java.lang.Character")) : class$java$lang$Character;
            } else if (fieldType == Byte.TYPE) {
                returnClass = class$java$lang$Byte == null ? (class$java$lang$Byte = ClassFieldExtractorFactory.class$("java.lang.Byte")) : class$java$lang$Byte;
            } else if (fieldType == Short.TYPE) {
                returnClass = class$java$lang$Short == null ? (class$java$lang$Short = ClassFieldExtractorFactory.class$("java.lang.Short")) : class$java$lang$Short;
            } else if (fieldType == Integer.TYPE) {
                returnClass = class$java$lang$Integer == null ? (class$java$lang$Integer = ClassFieldExtractorFactory.class$("java.lang.Integer")) : class$java$lang$Integer;
            } else if (fieldType == Long.TYPE) {
                returnClass = class$java$lang$Long == null ? (class$java$lang$Long = ClassFieldExtractorFactory.class$("java.lang.Long")) : class$java$lang$Long;
            } else if (fieldType == Float.TYPE) {
                returnClass = class$java$lang$Float == null ? (class$java$lang$Float = ClassFieldExtractorFactory.class$("java.lang.Float")) : class$java$lang$Float;
            } else if (fieldType == Double.TYPE) {
                returnClass = class$java$lang$Double == null ? (class$java$lang$Double = ClassFieldExtractorFactory.class$("java.lang.Double")) : class$java$lang$Double;
            } else if (fieldType == Boolean.TYPE) {
                returnClass = class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassFieldExtractorFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        } else {
            returnClass = fieldType;
        }
        return new ClassObjectType(returnClass);
    }

    private static String getTypeName(Class fieldType) {
        String ret = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Character.TYPE) {
                ret = "java/lang/Character";
            } else if (fieldType == Byte.TYPE) {
                ret = "java/lang/Byte";
            } else if (fieldType == Short.TYPE) {
                ret = "java/lang/Short";
            } else if (fieldType == Integer.TYPE) {
                ret = "java/lang/Integer";
            } else if (fieldType == Long.TYPE) {
                ret = "java/lang/Long";
            } else if (fieldType == Float.TYPE) {
                ret = "java/lang/Float";
            } else if (fieldType == Double.TYPE) {
                ret = "java/lang/Double";
            } else if (fieldType == Boolean.TYPE) {
                ret = "java/lang/Boolean";
            }
        } else {
            ret = fieldType.getName().replace('.', '/');
        }
        return ret;
    }

    private static String getPrimitiveTag(Class fieldType) {
        String ret = null;
        if (fieldType == Character.TYPE) {
            ret = "C";
        } else if (fieldType == Byte.TYPE) {
            ret = "B";
        } else if (fieldType == Short.TYPE) {
            ret = "S";
        } else if (fieldType == Integer.TYPE) {
            ret = "I";
        } else if (fieldType == Long.TYPE) {
            ret = "J";
        } else if (fieldType == Float.TYPE) {
            ret = "F";
        } else if (fieldType == Double.TYPE) {
            ret = "D";
        } else if (fieldType == Boolean.TYPE) {
            ret = "Z";
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ByteArrayClassLoader
    extends ClassLoader {
        public ByteArrayClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class defineClass(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }
}

