/*
 * Decompiled with CFR 0.152.
 */
package org.drools.asm.tree.analysis;

import java.util.List;
import org.drools.asm.Type;
import org.drools.asm.tree.AbstractInsnNode;
import org.drools.asm.tree.FieldInsnNode;
import org.drools.asm.tree.MethodInsnNode;
import org.drools.asm.tree.analysis.AnalyzerException;
import org.drools.asm.tree.analysis.BasicInterpreter;
import org.drools.asm.tree.analysis.BasicValue;
import org.drools.asm.tree.analysis.Value;

public class BasicVerifier
extends BasicInterpreter {
    /*
     * WARNING - void declaration
     */
    public Value copyOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        void var3_3;
        switch (insn.getOpcode()) {
            case 21: 
            case 54: {
                Value expected = BasicValue.INT_VALUE;
                break;
            }
            case 23: 
            case 56: {
                Value expected = BasicValue.FLOAT_VALUE;
                break;
            }
            case 22: 
            case 55: {
                Value expected = BasicValue.LONG_VALUE;
                break;
            }
            case 24: 
            case 57: {
                Value expected = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 25: {
                if (!((BasicValue)value).isReference()) {
                    throw new AnalyzerException(null, "an object reference", value);
                }
                return value;
            }
            case 58: {
                if (!((BasicValue)value).isReference() && value != BasicValue.RETURNADDRESS_VALUE) {
                    throw new AnalyzerException(null, "an object reference or a return address", value);
                }
                return value;
            }
            default: {
                return value;
            }
        }
        if (value != var3_3) {
            throw new AnalyzerException(null, var3_3, value);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public Value unaryOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        void var3_3;
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 145: 
            case 146: 
            case 147: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 188: 
            case 189: {
                Value expected = BasicValue.INT_VALUE;
                break;
            }
            case 118: 
            case 139: 
            case 140: 
            case 141: 
            case 174: {
                Value expected = BasicValue.FLOAT_VALUE;
                break;
            }
            case 117: 
            case 136: 
            case 137: 
            case 138: 
            case 173: {
                Value expected = BasicValue.LONG_VALUE;
                break;
            }
            case 119: 
            case 142: 
            case 143: 
            case 144: 
            case 175: {
                Value expected = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 180: {
                Value expected = this.newValue(Type.getType("L" + ((FieldInsnNode)insn).owner + ";"));
                break;
            }
            case 192: {
                if (!((BasicValue)value).isReference()) {
                    throw new AnalyzerException(null, "an object reference", value);
                }
                return super.unaryOperation(insn, value);
            }
            case 190: {
                if (!this.isArrayValue(value)) {
                    throw new AnalyzerException(null, "an array reference", value);
                }
                return super.unaryOperation(insn, value);
            }
            case 176: 
            case 191: 
            case 193: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                if (!((BasicValue)value).isReference()) {
                    throw new AnalyzerException(null, "an object reference", value);
                }
                return super.unaryOperation(insn, value);
            }
            case 179: {
                Value expected = this.newValue(Type.getType(((FieldInsnNode)insn).desc));
                break;
            }
            default: {
                throw new RuntimeException("Internal error.");
            }
        }
        if (!this.isSubTypeOf(value, (Value)var3_3)) {
            throw new AnalyzerException(null, var3_3, value);
        }
        return super.unaryOperation(insn, value);
    }

    /*
     * WARNING - void declaration
     */
    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) throws AnalyzerException {
        void var5_5;
        void var4_4;
        switch (insn.getOpcode()) {
            case 46: {
                Value expected1 = this.newValue(Type.getType("[I"));
                Value expected2 = BasicValue.INT_VALUE;
                break;
            }
            case 51: {
                Value expected1 = !this.isSubTypeOf(value1, this.newValue(Type.getType("[Z"))) ? this.newValue(Type.getType("[B")) : this.newValue(Type.getType("[Z"));
                Value expected2 = BasicValue.INT_VALUE;
                break;
            }
            case 52: {
                Value expected1 = this.newValue(Type.getType("[C"));
                Value expected2 = BasicValue.INT_VALUE;
                break;
            }
            case 53: {
                Value expected1 = this.newValue(Type.getType("[S"));
                Value expected2 = BasicValue.INT_VALUE;
                break;
            }
            case 47: {
                Value expected1 = this.newValue(Type.getType("[J"));
                Value expected2 = BasicValue.INT_VALUE;
                break;
            }
            case 48: {
                Value expected1 = this.newValue(Type.getType("[F"));
                Value expected2 = BasicValue.INT_VALUE;
                break;
            }
            case 49: {
                Value expected1 = this.newValue(Type.getType("[D"));
                Value expected2 = BasicValue.INT_VALUE;
                break;
            }
            case 50: {
                Value expected1 = this.newValue(Type.getType("[Ljava/lang/Object;"));
                Value expected2 = BasicValue.INT_VALUE;
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                Value expected1 = BasicValue.INT_VALUE;
                Value expected2 = BasicValue.INT_VALUE;
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 149: 
            case 150: {
                Value expected1 = BasicValue.FLOAT_VALUE;
                Value expected2 = BasicValue.FLOAT_VALUE;
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: 
            case 148: {
                Value expected1 = BasicValue.LONG_VALUE;
                Value expected2 = BasicValue.LONG_VALUE;
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                Value expected1 = BasicValue.LONG_VALUE;
                Value expected2 = BasicValue.INT_VALUE;
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 151: 
            case 152: {
                Value expected1 = BasicValue.DOUBLE_VALUE;
                Value expected2 = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 165: 
            case 166: {
                Value expected1 = BasicValue.REFERENCE_VALUE;
                Value expected2 = BasicValue.REFERENCE_VALUE;
                break;
            }
            case 181: {
                FieldInsnNode fin = (FieldInsnNode)insn;
                Value expected1 = this.newValue(Type.getType("L" + fin.owner + ";"));
                Value expected2 = this.newValue(Type.getType(fin.desc));
                break;
            }
            default: {
                throw new RuntimeException("Internal error.");
            }
        }
        if (!this.isSubTypeOf(value1, (Value)var4_4)) {
            throw new AnalyzerException("First argument", var4_4, value1);
        }
        if (!this.isSubTypeOf(value2, (Value)var5_5)) {
            throw new AnalyzerException("Second argument", var5_5, value2);
        }
        if (insn.getOpcode() == 50) {
            return this.getElementValue(value1);
        }
        return super.binaryOperation(insn, value1, value2);
    }

    /*
     * WARNING - void declaration
     */
    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) throws AnalyzerException {
        void var6_6;
        void var5_5;
        switch (insn.getOpcode()) {
            case 79: {
                Value expected1 = this.newValue(Type.getType("[I"));
                Value expected3 = BasicValue.INT_VALUE;
                break;
            }
            case 84: {
                Value expected1 = !this.isSubTypeOf(value1, this.newValue(Type.getType("[Z"))) ? this.newValue(Type.getType("[B")) : this.newValue(Type.getType("[Z"));
                Value expected3 = BasicValue.INT_VALUE;
                break;
            }
            case 85: {
                Value expected1 = this.newValue(Type.getType("[C"));
                Value expected3 = BasicValue.INT_VALUE;
                break;
            }
            case 86: {
                Value expected1 = this.newValue(Type.getType("[S"));
                Value expected3 = BasicValue.INT_VALUE;
                break;
            }
            case 80: {
                Value expected1 = this.newValue(Type.getType("[J"));
                Value expected3 = BasicValue.LONG_VALUE;
                break;
            }
            case 81: {
                Value expected1 = this.newValue(Type.getType("[F"));
                Value expected3 = BasicValue.FLOAT_VALUE;
                break;
            }
            case 82: {
                Value expected1 = this.newValue(Type.getType("[D"));
                Value expected3 = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 83: {
                Value expected1 = value1;
                Value expected3 = BasicValue.REFERENCE_VALUE;
                break;
            }
            default: {
                throw new RuntimeException("Internal error.");
            }
        }
        if (!this.isSubTypeOf(value1, (Value)var5_5)) {
            throw new AnalyzerException("First argument", "a " + var5_5 + " array reference", value1);
        }
        if (value2 != BasicValue.INT_VALUE) {
            throw new AnalyzerException("Second argument", BasicValue.INT_VALUE, value2);
        }
        if (!this.isSubTypeOf(value3, (Value)var6_6)) {
            throw new AnalyzerException("Third argument", var6_6, value3);
        }
        return null;
    }

    public Value naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i) == BasicValue.INT_VALUE) continue;
                throw new AnalyzerException(null, BasicValue.INT_VALUE, (Value)values.get(i));
            }
        } else {
            int i = 0;
            int j = 0;
            if (opcode != 184) {
                String own = ((MethodInsnNode)insn).owner;
                if (own.charAt(0) != '[') {
                    own = "L" + own + ";";
                }
                Type owner = Type.getType(own);
                if (!this.isSubTypeOf((Value)values.get(i++), this.newValue(owner))) {
                    throw new AnalyzerException("Method owner", this.newValue(owner), (Value)values.get(0));
                }
            }
            Type[] args = Type.getArgumentTypes(((MethodInsnNode)insn).desc);
            while (i < values.size()) {
                Value encountered;
                Value expected = this.newValue(args[j++]);
                if (this.isSubTypeOf(encountered = (Value)values.get(i++), expected)) continue;
                throw new AnalyzerException("Argument " + j, expected, encountered);
            }
        }
        return super.naryOperation(insn, values);
    }

    protected boolean isArrayValue(Value value) {
        return ((BasicValue)value).isReference();
    }

    protected Value getElementValue(Value objectArrayValue) throws AnalyzerException {
        return BasicValue.REFERENCE_VALUE;
    }

    protected boolean isSubTypeOf(Value value, Value expected) {
        return value == expected;
    }
}

