/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.BehaviorContext;
import org.drools.core.rule.BehaviorRuntime;
import org.kie.api.runtime.rule.FactHandle;

public class BehaviorManager
implements Externalizable {
    public static final BehaviorRuntime[] NO_BEHAVIORS = new BehaviorRuntime[0];
    private BehaviorRuntime[] behaviors;

    public BehaviorManager() {
        this(NO_BEHAVIORS);
    }

    public BehaviorManager(List<BehaviorRuntime> behaviors) {
        this.behaviors = behaviors.toArray(new BehaviorRuntime[behaviors.size()]);
    }

    public BehaviorManager(BehaviorRuntime[] behaviors) {
        this.behaviors = behaviors;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.behaviors = (BehaviorRuntime[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.behaviors);
    }

    public BehaviorContext[] createBehaviorContext() {
        BehaviorContext[] behaviorCtx = new BehaviorContext[this.behaviors.length];
        for (int i = 0; i < this.behaviors.length; ++i) {
            behaviorCtx[i] = this.behaviors[i].createContext();
        }
        return behaviorCtx;
    }

    public boolean assertFact(Object behaviorContext, InternalFactHandle factHandle, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        boolean result = true;
        for (int i = 0; i < this.behaviors.length; ++i) {
            result = result && this.behaviors[i].assertFact(((Object[])behaviorContext)[i], factHandle, pctx, reteEvaluator);
        }
        return result;
    }

    public void retractFact(Object behaviorContext, FactHandle factHandle, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        for (int i = 0; i < this.behaviors.length; ++i) {
            this.behaviors[i].retractFact(((Object[])behaviorContext)[i], factHandle, pctx, reteEvaluator);
        }
    }

    public BehaviorRuntime[] getBehaviors() {
        return this.behaviors;
    }
}

