/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.drools.base.rule.Declaration;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.ObjectTypeNodeId;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.Tuple;
import org.drools.core.util.index.TupleList;
import org.kie.api.runtime.rule.FactHandle;

public abstract class TupleImpl
implements Tuple<TupleImpl> {
    private static final long serialVersionUID = 540L;
    private int index;
    private TupleImpl parent;
    private TupleImpl rightParent;
    private TupleImpl rightParentPrevious;
    private TupleImpl rightParentNext;
    private short stagedType;
    private Object contextObject;
    protected InternalFactHandle handle;
    private PropagationContext propagationContext;
    protected TupleImpl stagedNext;
    protected TupleImpl stagedPrevious;
    private TupleImpl previous;
    private TupleImpl next;
    private TupleImpl leftParent;
    protected TupleImpl handlePrevious;
    protected TupleImpl handleNext;
    private Sink sink;
    private boolean expired;
    protected TupleList memory;
    protected TupleImpl firstChild;
    protected TupleImpl lastChild;
    private TupleImpl peer;
    private short stagedTypeForQueries;

    public TupleImpl() {
    }

    public TupleImpl(InternalFactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        this.setSink(sink);
        this.handle = factHandle;
        if (leftTupleMemoryEnabled) {
            factHandle.addLastLeftTuple(this);
        }
    }

    public TupleImpl(InternalFactHandle factHandle, TupleImpl leftTuple, Sink sink) {
        this.setSink(sink);
        this.handle = factHandle;
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple.getNextParentWithHandle();
        this.leftParent = leftTuple;
    }

    public TupleImpl(TupleImpl leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        this.setSink(sink);
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple.getNextParentWithHandle();
        this.leftParent = leftTuple;
        this.setPropagationContext(pctx);
        if (leftTupleMemoryEnabled) {
            if (leftTuple.getLastChild() != null) {
                this.handlePrevious = leftTuple.getLastChild();
                this.handlePrevious.setHandleNext(this);
            } else {
                leftTuple.setFirstChild(this);
            }
            leftTuple.setLastChild(this);
        }
    }

    public TupleImpl(TupleImpl leftTuple, TupleImpl rightTuple, Sink sink) {
        this.setSink(sink);
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple.getNextParentWithHandle();
        this.leftParent = leftTuple;
        this.rightParent = rightTuple;
        this.handle = rightTuple.getFactHandle();
        this.setPropagationContext(rightTuple.getPropagationContext());
        if (leftTuple.getLastChild() != null) {
            this.handlePrevious = leftTuple.getLastChild();
            this.handlePrevious.setHandleNext(this);
        } else {
            leftTuple.setFirstChild(this);
        }
        leftTuple.setLastChild(this);
        if (rightTuple.getLastChild() != null) {
            this.rightParentPrevious = rightTuple.getLastChild();
            this.rightParentPrevious.setRightParentNext(this);
        } else {
            rightTuple.setFirstChild(this);
        }
        rightTuple.setLastChild(this);
    }

    public TupleImpl(TupleImpl leftTuple, TupleImpl rightTuple, TupleImpl currentLeftChild, TupleImpl currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        this.setSink(sink);
        this.handle = rightTuple.getFactHandle();
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple.getNextParentWithHandle();
        this.leftParent = leftTuple;
        this.rightParent = rightTuple;
        this.setPropagationContext(rightTuple.getPropagationContext());
        if (leftTupleMemoryEnabled) {
            if (currentLeftChild == null) {
                if (leftTuple.getLastChild() != null) {
                    this.handlePrevious = leftTuple.getLastChild();
                    this.handlePrevious.setHandleNext(this);
                } else {
                    leftTuple.setFirstChild(this);
                }
                leftTuple.setLastChild(this);
            } else {
                this.handleNext = currentLeftChild;
                this.handlePrevious = currentLeftChild.getHandlePrevious();
                currentLeftChild.setHandlePrevious(this);
                if (this.handlePrevious == null) {
                    this.leftParent.setFirstChild(this);
                } else {
                    this.handlePrevious.setHandleNext(this);
                }
            }
            if (currentRightChild == null) {
                if (rightTuple.getLastChild() != null) {
                    this.rightParentPrevious = rightTuple.getLastChild();
                    this.rightParentPrevious.setRightParentNext(this);
                } else {
                    rightTuple.setFirstChild(this);
                }
                rightTuple.setLastChild(this);
            } else {
                this.rightParentNext = currentRightChild;
                this.rightParentPrevious = currentRightChild.getRightParentPrevious();
                currentRightChild.setRightParentPrevious(this);
                if (this.rightParentPrevious == null) {
                    this.rightParent.setFirstChild(this);
                } else {
                    this.rightParentPrevious.setRightParentNext(this);
                }
            }
        }
    }

    public Object getObject(Declaration declaration) {
        return this.getObject(declaration.getTupleIndex());
    }

    @Override
    public Object getContextObject() {
        return this.contextObject;
    }

    @Override
    public final void setContextObject(Object contextObject) {
        this.contextObject = contextObject;
    }

    @Override
    public short getStagedType() {
        return this.stagedType;
    }

    @Override
    public void setStagedType(short stagedType) {
        this.stagedType = stagedType;
    }

    @Override
    public TupleImpl getFirstChild() {
        return this.firstChild;
    }

    @Override
    public void setFirstChild(TupleImpl firstChild) {
        this.firstChild = firstChild;
    }

    @Override
    public TupleImpl getLastChild() {
        return this.lastChild;
    }

    @Override
    public void setLastChild(TupleImpl lastChild) {
        this.lastChild = lastChild;
    }

    public TupleImpl getRightParent() {
        return this.rightParent;
    }

    public void setRightParent(TupleImpl rightParent) {
        this.rightParent = rightParent;
    }

    public TupleImpl getRightParentPrevious() {
        return this.rightParentPrevious;
    }

    public void setRightParentPrevious(TupleImpl rightParentLeft) {
        this.rightParentPrevious = rightParentLeft;
    }

    public TupleImpl getRightParentNext() {
        return this.rightParentNext;
    }

    public void setRightParentNext(TupleImpl rightParentRight) {
        this.rightParentNext = rightParentRight;
    }

    public FactHandle get(int index) {
        TupleImpl entry = this;
        while (entry.getIndex() != index) {
            entry = entry.getParent();
        }
        return entry.getFactHandle();
    }

    public FactHandle[] toFactHandles() {
        FactHandle[] handles = new FactHandle[((LeftTupleSinkNode)this.getSink()).getLeftTupleSource().getObjectCount()];
        TupleImpl entry = this.skipEmptyHandles();
        for (int i = handles.length - 1; i >= 0; --i) {
            handles[i] = entry.getFactHandle();
            entry = entry.getParent();
        }
        return handles;
    }

    public Object[] toObjects(boolean reverse) {
        Object[] objs = new Object[((LeftTupleSinkNode)this.getSink()).getLeftTupleSource().getObjectCount()];
        TupleImpl entry = this.skipEmptyHandles();
        if (!reverse) {
            for (int i = objs.length - 1; i >= 0; --i) {
                objs[i] = entry.getFactHandle().getObject();
                entry = entry.getParent();
            }
        } else {
            for (int i = 0; i < objs.length; ++i) {
                objs[i] = entry.getFactHandle().getObject();
                entry = entry.getParent();
            }
        }
        return objs;
    }

    public void clearBlocker() {
        throw new UnsupportedOperationException();
    }

    public void setBlocker(RightTuple blocker) {
        throw new UnsupportedOperationException();
    }

    public RightTuple getBlocker() {
        throw new UnsupportedOperationException();
    }

    public LeftTuple getBlockedPrevious() {
        throw new UnsupportedOperationException();
    }

    public void setBlockedPrevious(LeftTuple blockerPrevious) {
        throw new UnsupportedOperationException();
    }

    public LeftTuple getBlockedNext() {
        throw new UnsupportedOperationException();
    }

    public void setBlockedNext(LeftTuple blockerNext) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (TupleImpl entry = this.skipEmptyHandles(); entry != null; entry = entry.getParent()) {
            buffer.append(entry.getFactHandle());
            if (entry.getParent() == null) continue;
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public int hashCode() {
        return this.getFactHandle() == null ? 0 : this.getFactHandle().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        TupleImpl other = (TupleImpl)object;
        if (this.hashCode() != other.hashCode() || this.getFactHandle() != other.getFactHandle()) {
            return false;
        }
        if (this.parent == null) {
            return other.getParent() == null;
        }
        return this.parent.equals(other.getParent());
    }

    public int size() {
        return this.index + 1;
    }

    @Override
    public TupleImpl getStagedNext() {
        return this.stagedNext;
    }

    @Override
    public TupleImpl getStagedPrevious() {
        return this.stagedPrevious;
    }

    @Override
    public void clearStaged() {
        if (this.getContextObject() == Boolean.TRUE) {
            this.setContextObject(null);
        }
        this.stagedType = 0;
        this.stagedNext = null;
        this.stagedPrevious = null;
    }

    public TupleImpl getPeer() {
        return this.peer;
    }

    public void setPeer(TupleImpl peer) {
        this.peer = peer;
    }

    @Override
    public TupleImpl getSubTuple(int elements) {
        TupleImpl entry = this;
        if (elements <= this.size()) {
            int lastindex = elements - 1;
            while (entry.getIndex() != lastindex) {
                entry = entry.getParent();
            }
        }
        return entry;
    }

    @Override
    public TupleImpl getParent() {
        return this.parent;
    }

    protected String toExternalString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%08X", System.identityHashCode(this))).append(":");
        long[] ids = new long[this.index + 1];
        for (TupleImpl entry = this.skipEmptyHandles(); entry != null; entry = entry.getParent()) {
            ids[entry.getIndex()] = entry.getFactHandle().getId();
        }
        builder.append(Arrays.toString(ids)).append(" sink=").append(this.getSink().getClass().getSimpleName()).append("(").append(this.getSink().getId()).append(")");
        return builder.toString();
    }

    @Override
    public void clear() {
        this.previous = null;
        this.next = null;
        this.memory = null;
    }

    public InternalFactHandle getFactHandle() {
        return this.handle;
    }

    @Override
    public InternalFactHandle getOriginalFactHandle() {
        DefaultEventHandle linkedFH = this.handle.isEvent() ? ((DefaultEventHandle)this.handle).getLinkedFactHandle() : null;
        return linkedFH != null ? linkedFH : this.handle;
    }

    @Override
    public void setFactHandle(FactHandle handle) {
        this.handle = (InternalFactHandle)handle;
    }

    @Override
    public PropagationContext getPropagationContext() {
        return this.propagationContext;
    }

    @Override
    public void setPropagationContext(PropagationContext propagationContext) {
        this.propagationContext = propagationContext;
    }

    @Override
    public void setStagedNext(TupleImpl stageNext) {
        this.stagedNext = stageNext;
    }

    @Override
    public void setStagedPrevious(TupleImpl stagedPrevious) {
        this.stagedPrevious = stagedPrevious;
    }

    @Override
    public TupleImpl getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(TupleImpl previous) {
        this.previous = previous;
    }

    @Override
    public TupleImpl getNext() {
        return this.next;
    }

    @Override
    public void setNext(TupleImpl next) {
        this.next = next;
    }

    public FactHandle get(Declaration declaration) {
        return this.get(declaration.getTupleIndex());
    }

    public TupleImpl getTuple(int index) {
        TupleImpl entry = this;
        while (entry.getIndex() != index) {
            entry = entry.getParent();
        }
        return entry;
    }

    @Override
    public TupleImpl getRootTuple() {
        return this.getTuple(0);
    }

    @Override
    public TupleImpl skipEmptyHandles() {
        return this.getFactHandle() == null ? this.getParent() : this;
    }

    public TupleImpl getLeftParent() {
        return this.leftParent;
    }

    public void setLeftParent(TupleImpl leftParent) {
        this.leftParent = leftParent;
    }

    public TupleImpl getNextParentWithHandle() {
        return this.handle != null ? this : (this.parent != null ? this.parent.getNextParentWithHandle() : this);
    }

    @Override
    public abstract void reAdd();

    public void reAddLeft() {
        if (this.handleNext != null) {
            if (this.handlePrevious != null) {
                this.handlePrevious.setHandleNext(this.handleNext);
                this.handleNext.setHandlePrevious(this.handlePrevious);
            } else {
                if (this.leftParent.getFirstChild() == this) {
                    this.leftParent.setFirstChild(this.getHandleNext());
                }
                this.handleNext.setHandlePrevious(null);
            }
            this.handlePrevious = this.leftParent.getLastChild();
            this.handlePrevious.setHandleNext(this);
            this.leftParent.setLastChild(this);
            this.handleNext = null;
        }
    }

    public void reAddRight() {
        if (this.rightParentNext != null) {
            if (this.rightParentPrevious != null) {
                this.rightParentPrevious.setRightParentNext(this.rightParentNext);
                this.rightParentNext.setRightParentPrevious(this.rightParentPrevious);
            } else {
                if (this.rightParent.getFirstChild() == this) {
                    this.rightParent.setFirstChild(this.rightParentNext);
                }
                this.rightParentNext.setRightParentPrevious(null);
            }
            this.rightParentPrevious = this.rightParent.getLastChild();
            this.rightParentPrevious.setRightParentNext(this);
            this.rightParent.setLastChild(this);
            this.rightParentNext = null;
        }
    }

    @Override
    public void unlinkFromLeftParent() {
        TupleImpl previousParent = this.getHandlePrevious();
        TupleImpl nextParent = this.getHandleNext();
        if (previousParent != null && nextParent != null) {
            this.handlePrevious.setHandleNext(nextParent);
            this.handleNext.setHandlePrevious(previousParent);
        } else if (nextParent != null) {
            if (this.leftParent != null) {
                this.leftParent.setFirstChild(nextParent);
            } else {
                this.getFactHandle().removeLeftTuple(this);
            }
            nextParent.setHandlePrevious(null);
        } else if (previousParent != null) {
            if (this.leftParent != null) {
                this.leftParent.setLastChild(previousParent);
            } else {
                this.getFactHandle().removeLeftTuple(this);
            }
            previousParent.setHandleNext(null);
        } else if (this.leftParent != null) {
            this.leftParent.setFirstChild(null);
            this.leftParent.setLastChild(null);
        } else {
            this.getFactHandle().removeLeftTuple(this);
        }
        this.handlePrevious = null;
        this.handleNext = null;
    }

    @Override
    public void unlinkFromRightParent() {
        this.doUnlinkFromRightParent();
    }

    public void doUnlinkFromRightParent() {
        if (this.rightParent == null) {
            return;
        }
        TupleImpl previousParent = this.rightParentPrevious;
        TupleImpl nextParent = this.rightParentNext;
        if (previousParent != null && nextParent != null) {
            this.rightParentPrevious.setRightParentNext(this.rightParentNext);
            this.rightParentNext.setRightParentPrevious(this.rightParentPrevious);
        } else if (nextParent != null) {
            this.rightParent.setFirstChild(nextParent);
            nextParent.setRightParentPrevious(null);
        } else if (previousParent != null) {
            this.rightParent.setLastChild(previousParent);
            previousParent.setRightParentNext(null);
        } else {
            this.rightParent.setFirstChild(null);
            this.rightParent.setLastChild(null);
        }
        this.rightParentPrevious = null;
        this.rightParentNext = null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setLeftTupleSink(LeftTupleSink sink) {
        this.setSink(sink);
    }

    @Override
    public TupleImpl getHandlePrevious() {
        return this.handlePrevious;
    }

    @Override
    public void setHandlePrevious(TupleImpl handlePrevious) {
        this.handlePrevious = handlePrevious;
    }

    @Override
    public TupleImpl getHandleNext() {
        return this.handleNext;
    }

    @Override
    public void setHandleNext(TupleImpl handleNext) {
        this.handleNext = handleNext;
    }

    @Override
    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired() {
        this.expired = true;
    }

    @Override
    public Sink getSink() {
        return this.sink;
    }

    protected void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public TupleList getMemory() {
        return this.memory;
    }

    @Override
    public void setMemory(TupleList memory) {
        this.memory = memory;
    }

    public void initPeer(TupleImpl original, Sink sink) {
        this.index = original.index;
        this.parent = original.parent;
        this.leftParent = original.leftParent;
        this.setFactHandle(original.getFactHandle());
        this.setPropagationContext(original.getPropagationContext());
        this.setSink(sink);
    }

    public Object getObject(int index) {
        return this.get(index).getObject();
    }

    @Override
    public abstract ObjectTypeNodeId getInputOtnId();

    public InternalFactHandle getFactHandleForEvaluation() {
        throw new UnsupportedOperationException("Only RightTupleImpl implements this");
    }

    public short getStagedTypeForQueries() {
        return this.stagedTypeForQueries;
    }

    public void setStagedTypeForQueries(short stagedTypeForQueries) {
        this.stagedTypeForQueries = stagedTypeForQueries;
    }

    public boolean isStagedOnRight() {
        return false;
    }

    public Collection<Object> getAccumulatedObjects() {
        if (this.getFirstChild() == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.getContextObject() instanceof AccumulateNode.AccumulateContext) {
            for (TupleImpl child = this.getFirstChild(); child != null; child = child.getHandleNext()) {
                result.add(child.getContextObject());
            }
        }
        if (this.getFirstChild().getRightParent().isSubnetworkTuple()) {
            TupleImpl leftParent = this.getFirstChild().getRightParent().getLeftParent();
            result.addAll(leftParent.getAccumulatedObjects());
        }
        return result;
    }

    public abstract boolean isLeftTuple();

    public boolean isFullMatch() {
        return false;
    }

    public boolean isSubnetworkTuple() {
        return false;
    }
}

