/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class BigDecimalMaxAccumulateFunction
extends AbstractAccumulateFunction<MaxData> {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public MaxData createContext() {
        return new MaxData();
    }

    public void init(MaxData data) {
        data.max = null;
    }

    public void accumulate(MaxData data, Object value) {
        if (value != null) {
            BigDecimal bdValue = (BigDecimal)value;
            data.max = data.max == null || data.max.compareTo(bdValue) < 0 ? bdValue : data.max;
        }
    }

    public void reverse(MaxData data, Object value) {
    }

    public boolean tryReverse(MaxData data, Object value) {
        if (value != null) {
            return data.max.compareTo((BigDecimal)value) > 0;
        }
        return true;
    }

    public Object getResult(MaxData data) {
        return data.max;
    }

    public boolean supportsReverse() {
        return false;
    }

    public Class<?> getResultType() {
        return BigDecimal.class;
    }

    protected static class MaxData
    implements Externalizable {
        public BigDecimal max = null;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.max = (BigDecimal)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.max);
        }

        public String toString() {
            return "max";
        }
    }
}

