/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.lang.annotation.Annotation;
import java.util.function.Predicate;
import org.drools.base.common.MissingDependencyException;
import org.drools.base.definitions.rule.impl.QueryImpl;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystem;
import org.kie.api.internal.utils.KieService;

public interface TruthMaintenanceSystemFactory
extends KieService {
    public static final String NO_TMS = "You're trying to use the Truth Maintenance System without having imported it. Please add the module org.drools:drools-tms to your classpath.";

    public TruthMaintenanceSystem getOrCreateTruthMaintenanceSystem(ReteEvaluator var1);

    public TruthMaintenanceSystem getOrCreateTruthMaintenanceSystem(InternalWorkingMemoryEntryPoint var1);

    public void clearTruthMaintenanceSystem(InternalWorkingMemoryEntryPoint var1);

    public static TruthMaintenanceSystemFactory get() {
        return TruthMaintenanceSystemFactory.present() ? Holder.INSTANCE : (TruthMaintenanceSystemFactory)TruthMaintenanceSystemFactory.throwExceptionForMissingTms();
    }

    public static boolean present() {
        return Holder.INSTANCE != null;
    }

    public static QueryImpl createQuery(String name, Predicate<Class<? extends Annotation>> hasAnnotation) {
        return TruthMaintenanceSystemFactory.present() ? TruthMaintenanceSystemFactory.get().createTmsQuery(name, hasAnnotation) : new QueryImpl(name);
    }

    public QueryImpl createTmsQuery(String var1, Predicate<Class<? extends Annotation>> var2);

    public static <T> T throwExceptionForMissingTms() {
        throw new MissingDependencyException(NO_TMS);
    }

    public static class Holder {
        private static final TruthMaintenanceSystemFactory INSTANCE = (TruthMaintenanceSystemFactory)KieService.load(TruthMaintenanceSystemFactory.class);
    }
}

