/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.base.extractors.SelfReferenceClassFieldReader;
import org.drools.base.base.field.ObjectFieldImpl;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.accessor.Evaluator;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.time.Interval;
import org.drools.core.base.extractors.ConstantValueReader;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Operator;

public class EvaluatorWrapper
implements Evaluator {
    private static final long serialVersionUID = 520L;
    private static final SelfReferenceClassFieldReader extractor = new SelfReferenceClassFieldReader(Object.class);
    private Evaluator evaluator;
    private Declaration leftBinding;
    private Declaration rightBinding;
    private boolean selfLeft;
    private boolean selfRight;
    private String bindingName;
    private transient boolean rightLiteral;
    private transient Long leftTimestamp;
    private transient Long rightTimestamp;

    public EvaluatorWrapper(Evaluator evaluator, Declaration leftBinding, Declaration rightBinding) {
        this.evaluator = evaluator;
        this.leftBinding = leftBinding;
        this.rightBinding = rightBinding;
        this.init();
    }

    private void init() {
        this.selfLeft = this.leftBinding == null || this.leftBinding.getIdentifier().equals("this");
        this.selfRight = this.rightBinding == null || this.rightBinding.getIdentifier().equals("this");
    }

    public boolean evaluate(ReteEvaluator reteEvaluator, Object left, Object right) {
        Object leftValue = this.leftTimestamp != null ? this.leftTimestamp : left;
        Object rightValue = this.rightTimestamp != null ? this.rightTimestamp : right;
        return this.rightLiteral ? this.evaluator.evaluate((ValueResolver)reteEvaluator, (ReadAccessor)new ConstantValueReader(leftValue), (FactHandle)InternalFactHandle.dummyFactHandleOf((Object)leftValue), (FieldValue)new ObjectFieldImpl(rightValue)) : this.evaluator.evaluate((ValueResolver)reteEvaluator, (ReadAccessor)new ConstantValueReader(leftValue), (FactHandle)InternalFactHandle.dummyFactHandleOf((Object)leftValue), (ReadAccessor)new ConstantValueReader(rightValue), (FactHandle)InternalFactHandle.dummyFactHandleOf((Object)rightValue));
    }

    public ValueType getValueType() {
        return this.evaluator.getValueType();
    }

    public Operator getOperator() {
        return this.evaluator.getOperator();
    }

    public ValueType getCoercedValueType() {
        return this.evaluator.getCoercedValueType();
    }

    public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor, FactHandle factHandle, FieldValue value) {
        return this.evaluator.evaluate(valueResolver, extractor, factHandle, value);
    }

    public boolean evaluate(ValueResolver valueResolver, ReadAccessor leftExtractor, FactHandle left, ReadAccessor rightExtractor, FactHandle right) {
        return this.evaluator.evaluate(valueResolver, leftExtractor, left, rightExtractor, right);
    }

    public boolean isTemporal() {
        return this.evaluator.isTemporal();
    }

    public Interval getInterval() {
        return this.evaluator.getInterval();
    }

    public void loadHandles(FactHandle[] handles, FactHandle rightHandle) {
        FactHandle localLeftHandle = this.selfLeft ? null : EvaluatorWrapper.getFactHandle(this.leftBinding, handles);
        FactHandle localRightHandle = this.selfRight ? rightHandle : EvaluatorWrapper.getFactHandle(this.rightBinding, handles);
        boolean bl = this.rightLiteral = localRightHandle == null;
        if (this.isTemporal()) {
            if (localLeftHandle == null) {
                localLeftHandle = rightHandle;
            }
            this.leftTimestamp = localLeftHandle instanceof DefaultEventHandle ? Long.valueOf(((DefaultEventHandle)localLeftHandle).getStartTimestamp()) : null;
            this.rightTimestamp = localRightHandle instanceof DefaultEventHandle ? Long.valueOf(((DefaultEventHandle)localRightHandle).getStartTimestamp()) : null;
        }
    }

    public String toString() {
        return this.evaluator.toString();
    }

    public static SelfReferenceClassFieldReader getExtractor() {
        return extractor;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    private static FactHandle getFactHandle(Declaration declaration, FactHandle[] handles) {
        return handles != null && handles.length > declaration.getObjectIndex() ? handles[declaration.getObjectIndex()] : null;
    }
}

