/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.drools.compiler.builder.impl.BuildResultCollector;
import org.drools.compiler.builder.impl.BuildResultCollectorImpl;
import org.drools.compiler.builder.impl.CompositeKnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.resources.DecisionTableResourceHandler;
import org.drools.compiler.builder.impl.resources.DrlResourceHandler;
import org.drools.compiler.builder.impl.resources.DslrResourceHandler;
import org.drools.compiler.builder.impl.resources.ResourceHandler;
import org.drools.compiler.builder.impl.resources.TemplateResourceHandler;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.lang.dsl.DefaultExpander;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class PackageDescrBuilder {
    private final BuildResultCollector buildResultCollector = new BuildResultCollectorImpl();
    private final List<ResourceHandler> mappers;
    private final List<ResourceType> orderedResourceTypes;
    private RuntimeException buildException;

    public PackageDescrBuilder(KnowledgeBuilderConfigurationImpl configuration, ReleaseId releaseId, Supplier<DefaultExpander> dslExpander) {
        this.mappers = Arrays.asList(new DrlResourceHandler(configuration), new TemplateResourceHandler(configuration, releaseId, dslExpander), new DslrResourceHandler(configuration, dslExpander), new DecisionTableResourceHandler(configuration, releaseId));
        this.orderedResourceTypes = Arrays.asList(ResourceType.DRL, ResourceType.GDRL, ResourceType.RDRL, ResourceType.DESCR, ResourceType.DSLR, ResourceType.RDSLR, ResourceType.DTABLE, ResourceType.TDRL, ResourceType.TEMPLATE);
    }

    public Collection<CompositePackageDescr> build(Map<ResourceType, List<CompositeKnowledgeBuilderImpl.ResourceDescr>> resourcesByType) {
        HashMap<String, CompositePackageDescr> packages = new HashMap<String, CompositePackageDescr>();
        for (ResourceType type : this.orderedResourceTypes) {
            ResourceHandler mapper = this.handlerForType(type);
            this.buildResource(packages, type, mapper, resourcesByType);
        }
        return packages.values();
    }

    public Collection<? extends KnowledgeBuilderResult> getResults() {
        return this.buildResultCollector.getAllResults();
    }

    public RuntimeException getBuildException() {
        return this.buildException;
    }

    private ResourceHandler handlerForType(ResourceType type) {
        for (ResourceHandler mapper : this.mappers) {
            if (!mapper.handles(type)) continue;
            return mapper;
        }
        throw new IllegalArgumentException("No registered mapper for type " + type);
    }

    private void buildResource(Map<String, CompositePackageDescr> packages, ResourceType resourceType, ResourceHandler mapper, Map<ResourceType, List<CompositeKnowledgeBuilderImpl.ResourceDescr>> resourcesByType) {
        List<CompositeKnowledgeBuilderImpl.ResourceDescr> resourceDescrs = resourcesByType.remove(resourceType);
        if (resourceDescrs != null) {
            for (CompositeKnowledgeBuilderImpl.ResourceDescr resourceDescr : resourceDescrs) {
                try {
                    PackageDescr packageDescr = mapper.process(resourceDescr.resource, resourceDescr.configuration);
                    mapper.getResults().forEach(this.buildResultCollector::addBuilderResult);
                    this.registerPackageDescr(resourceDescr, packages, resourceDescr.resource, packageDescr);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
    }

    private void registerPackageDescr(CompositeKnowledgeBuilderImpl.ResourceDescr resourceDescr, Map<String, CompositePackageDescr> packages, Resource resource, PackageDescr packageDescr) {
        if (packageDescr == null) {
            return;
        }
        CompositePackageDescr compositePackageDescr = packages.get(packageDescr.getNamespace());
        if (compositePackageDescr == null) {
            compositePackageDescr = this.makeCompositePackageDescr(resource, packageDescr);
            packages.put(packageDescr.getNamespace(), compositePackageDescr);
        } else {
            compositePackageDescr.addPackageDescr(resource, packageDescr);
        }
        compositePackageDescr.addFilter(resourceDescr.getFilter());
    }

    private CompositePackageDescr makeCompositePackageDescr(Resource resource, PackageDescr packageDescr) {
        CompositePackageDescr compositePackageDescr = packageDescr instanceof CompositePackageDescr ? (CompositePackageDescr)packageDescr : new CompositePackageDescr(resource, packageDescr);
        return compositePackageDescr;
    }
}

