/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.core.util.IoUtils;
import org.kie.memorycompiler.resources.KiePath;
import org.kie.memorycompiler.resources.ResourceReader;

public class DiskResourceReader
implements ResourceReader {
    private final File root;
    private final KiePath rootPath;
    private Map<KiePath, Integer> filesHashing;

    public DiskResourceReader(File root) {
        this.root = root;
        this.rootPath = KiePath.of((String)root.getAbsolutePath());
    }

    public boolean isAvailable(KiePath resourcePath) {
        return new File(this.root, resourcePath.asString()).exists();
    }

    public byte[] getBytes(KiePath resourcePath) {
        try {
            return IoUtils.readBytesFromInputStream((InputStream)new FileInputStream(new File(this.root, resourcePath.asString())));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Collection<KiePath> getFilePaths() {
        ArrayList<KiePath> list = new ArrayList<KiePath>();
        this.list(this.root, list);
        return list;
    }

    public void mark() {
        this.filesHashing = this.hashFiles();
    }

    public Collection<String> getModifiedResourcesSinceLastMark() {
        HashSet<String> modifiedResources = new HashSet<String>();
        Map<KiePath, Integer> newHashing = this.hashFiles();
        for (Map.Entry<KiePath, Integer> entry : newHashing.entrySet()) {
            Integer oldHashing = this.filesHashing.get(entry.getKey());
            if (oldHashing != null && oldHashing.equals(entry.getValue())) continue;
            modifiedResources.add(entry.getKey().asString());
        }
        for (KiePath oldFile : this.filesHashing.keySet()) {
            if (newHashing.containsKey(oldFile)) continue;
            modifiedResources.add(oldFile.asString());
        }
        return modifiedResources;
    }

    private Map<KiePath, Integer> hashFiles() {
        HashMap<KiePath, Integer> hashing = new HashMap<KiePath, Integer>();
        for (KiePath filePath : this.getFilePaths()) {
            byte[] bytes = this.getBytes(filePath);
            if (bytes == null) continue;
            hashing.put(filePath, Arrays.hashCode(bytes));
        }
        return hashing;
    }

    private void list(File pFile, List<KiePath> pFiles) {
        if (pFile.isDirectory()) {
            File[] directoryFiles = pFile.listFiles();
            for (int i = 0; i < directoryFiles.length; ++i) {
                this.list(directoryFiles[i], pFiles);
            }
        } else {
            pFiles.add(KiePath.of((String)pFile.getAbsolutePath().substring(this.rootPath.asString().length() + 1)));
        }
    }
}

