/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.AbstractKieProject;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.xml.MinimalPomParser;
import org.drools.compiler.kproject.xml.PomModel;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.util.StringUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathKieProject
extends AbstractKieProject {
    private static final Logger log = LoggerFactory.getLogger(ClasspathKieProject.class);
    public static final String OSGI_KIE_MODULE_CLASS_NAME = "org.drools.osgi.compiler.OsgiKieModule";
    private Map<ReleaseId, InternalKieModule> kieModules = new HashMap<ReleaseId, InternalKieModule>();
    private Map<String, InternalKieModule> kJarFromKBaseName = new HashMap<String, InternalKieModule>();
    private KieRepository kr;
    private ClassLoader cl;

    public ClasspathKieProject() {
        this(KieServices.Factory.get().getRepository());
    }

    public ClasspathKieProject(KieRepository kr) {
        this.kr = kr;
    }

    @Override
    public void init() {
        this.cl = ProjectClassLoader.createProjectClassLoader();
        this.discoverKieModules();
        this.indexParts(this.kieModules.values(), this.kJarFromKBaseName);
    }

    @Override
    public ReleaseId getGAV() {
        return null;
    }

    public void discoverKieModules() {
        String[] configFiles;
        for (String configFile : configFiles = new String[]{KieModuleModelImpl.KMODULE_JAR_PATH, KieModuleModelImpl.KMODULE_SPRING_JAR_PATH}) {
            Enumeration<URL> e;
            try {
                e = this.cl.getResources(configFile);
            }
            catch (IOException exc) {
                log.error("Unable to find and build index of " + configFile + "." + exc.getMessage());
                return;
            }
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                System.out.println("kmodules: " + url);
                try {
                    InternalKieModule kModule = ClasspathKieProject.fetchKModule(url);
                    if (kModule == null) continue;
                    ReleaseId releaseId = kModule.getReleaseId();
                    this.kieModules.put(releaseId, kModule);
                    log.debug("Discovered classpath module " + releaseId.toExternalForm());
                    this.kr.addKieModule((KieModule)kModule);
                }
                catch (Exception exc) {
                    log.error("Unable to build index of kmodule.xml url=" + url.toExternalForm() + "\n" + exc.getMessage());
                }
            }
        }
    }

    public static InternalKieModule fetchKModule(URL url) {
        if (url.toString().startsWith("bundle:")) {
            return ClasspathKieProject.fetchOsgiKModule(url);
        }
        return ClasspathKieProject.fetchKModule(url, ClasspathKieProject.fixURLFromKProjectPath(url));
    }

    private static InternalKieModule fetchOsgiKModule(URL url) {
        Method m;
        try {
            Class<?> c = Class.forName(OSGI_KIE_MODULE_CLASS_NAME);
            m = c.getMethod("create", URL.class);
        }
        catch (Exception e) {
            throw new RuntimeException("It is necessary to have the drools-osgi-integration module on the path in order to create a KieProject from an ogsi bundle", e);
        }
        try {
            return (InternalKieModule)m.invoke(null, url);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure creating a OsgiKieModule caused by: " + e.getMessage(), e);
        }
    }

    private static void fetchKModuleFromSpring(URL kModuleUrl, String fixedURL) {
        try {
            Class<?> clazz = Class.forName("org.kie.spring.KModuleSpringMarshaller");
            Method method = clazz.getDeclaredMethod("fromXML", URL.class, String.class);
            method.invoke(null, kModuleUrl, fixedURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static InternalKieModule fetchKModule(URL url, String fixedURL) {
        if (url.getPath().endsWith("-spring.xml")) {
            ClasspathKieProject.fetchKModuleFromSpring(url, fixedURL);
            return null;
        }
        KieModuleModel kieProject = KieModuleModelImpl.fromXML(url);
        KieBuilderImpl.setDefaultsforEmptyKieModule(kieProject);
        String pomProperties = ClasspathKieProject.getPomProperties(fixedURL);
        ReleaseId releaseId = ReleaseIdImpl.fromPropertiesString(pomProperties);
        String rootPath = fixedURL;
        if (rootPath.lastIndexOf(58) > 0) {
            rootPath = fixedURL.substring(rootPath.lastIndexOf(58) + 1);
        }
        return ClasspathKieProject.createInternalKieModule(url, fixedURL, kieProject, releaseId, rootPath);
    }

    public static InternalKieModule createInternalKieModule(URL url, String fixedURL, KieModuleModel kieProject, ReleaseId releaseId, String rootPath) {
        AbstractKieModule kJar;
        File file = new File(rootPath);
        if (fixedURL.endsWith(".jar")) {
            kJar = new ZipKieModule(releaseId, kieProject, file);
        } else if (file.isDirectory()) {
            kJar = new FileKieModule(releaseId, kieProject, file);
        } else {
            log.error("Unable to build index of kmodule.xml url=" + url.toExternalForm() + "\n");
            kJar = null;
        }
        return kJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPomProperties(String urlPathToAdd) {
        String rootPath = urlPathToAdd;
        if (rootPath.lastIndexOf(58) > 0) {
            rootPath = urlPathToAdd.substring(rootPath.lastIndexOf(58) + 1);
        }
        if (urlPathToAdd.endsWith(".jar")) {
            File actualZipFile = new File(rootPath);
            if (!actualZipFile.exists()) {
                log.error("Unable to load pom.properties from" + urlPathToAdd + " as jarPath cannot be found\n" + rootPath);
            }
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(actualZipFile);
                String file = KieBuilderImpl.findPomProperties(zipFile);
                if (file == null) {
                    throw new IOException();
                }
                ZipEntry zipEntry = zipFile.getEntry(file);
                String pomProps = StringUtils.readFileAsString((Reader)new InputStreamReader(zipFile.getInputStream(zipEntry)));
                log.debug("Found and used pom.properties " + file);
                String string = pomProps;
                return string;
            }
            catch (Exception e) {
                log.error("Unable to load pom.properties from" + urlPathToAdd + "\n" + e.getMessage());
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    log.error("Error when closing InputStream to " + urlPathToAdd + "\n" + e.getMessage());
                }
            }
        }
        InputStreamReader reader = null;
        try {
            File file = KieBuilderImpl.findPomProperties(new File(rootPath));
            if (file == null) {
                throw new IOException();
            }
            reader = new FileReader(file);
            log.debug("Found and used pom.properties " + file);
            String e = StringUtils.toString((Reader)reader);
            return e;
        }
        catch (Exception e) {
            log.warn("Unable to load pom.properties tried recursing down from" + urlPathToAdd + "\n" + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("Error when closing InputStream to " + urlPathToAdd + "\n" + e.getMessage());
                }
            }
        }
        File file = null;
        File folder = new File(rootPath);
        while (folder != null && !(file = new File(folder, "pom.xml")).exists()) {
            file = null;
            folder = new File(folder.getParent());
        }
        if (file != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                PomModel pomModel = MinimalPomParser.parse(rootPath + "/pom.xml", fis);
                KieBuilderImpl.validatePomModel(pomModel);
                ReleaseIdImpl gav = (ReleaseIdImpl)pomModel.getReleaseId();
                String str = KieBuilderImpl.generatePomProperties(gav);
                log.info("Recursed up folders,  found and used pom.xml " + file);
                String string = str;
                return string;
            }
            catch (Exception e) {
                log.error("As folder project tried to fall back to pom.xml " + file + "\nbut failed with exception:\n" + e.getMessage());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        log.error("Error when closing InputStream to " + file + "\n" + e.getMessage());
                    }
                }
            }
        }
        log.error("As folder project tried to fall back to pom.xml, but could not find one for " + file);
        log.error("Unable to load pom.properties from" + urlPathToAdd);
        return null;
    }

    public static String fixURLFromKProjectPath(URL url) {
        int firstSlash;
        String urlPath = url.toExternalForm();
        String urlType = "file";
        int colonIndex = urlPath.indexOf(":");
        if (colonIndex != -1) {
            urlType = urlPath.substring(0, colonIndex);
        }
        urlPath = url.getPath();
        if ("jar".equals(urlType)) {
            if (urlPath.indexOf(33) > 0) {
                urlPath = urlPath.substring(0, urlPath.indexOf(33));
            }
        } else {
            urlPath = "vfs".equals(urlType) ? ClasspathKieProject.getPathForVFS(url) : (url.toString().contains("-spring.xml") ? urlPath.substring(0, urlPath.length() - ("/" + KieModuleModelImpl.KMODULE_SPRING_JAR_PATH).length()) : urlPath.substring(0, urlPath.length() - ("/" + KieModuleModelImpl.KMODULE_JAR_PATH).length()));
        }
        int n = colonIndex = (firstSlash = urlPath.indexOf(47)) > 0 ? urlPath.lastIndexOf(":", firstSlash) : urlPath.lastIndexOf(":");
        if (colonIndex >= 0) {
            urlPath = urlPath.substring(colonIndex + 1);
        }
        try {
            urlPath = URLDecoder.decode(urlPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error decoding URL (" + url + ") using UTF-8", e);
        }
        log.debug("KieModule URL type=" + urlType + " url=" + urlPath);
        return urlPath;
    }

    private static String getPathForVFS(URL url) {
        String urlString = url.toString();
        int kModulePos = urlString.length() - ("/" + KieModuleModelImpl.KMODULE_JAR_PATH).length();
        boolean isInJar = urlString.substring(kModulePos - 4, kModulePos).equals(".jar");
        try {
            Method m = Class.forName("org.jboss.vfs.VirtualFile").getMethod("getPhysicalFile", new Class[0]);
            Object content = url.openConnection().getContent();
            File f = (File)m.invoke(content, new Object[0]);
            String path = f.getPath();
            if (isInJar) {
                String jarName = urlString.substring(0, kModulePos);
                jarName = jarName.substring(jarName.lastIndexOf(47) + 1);
                path = path.substring(0, path.length() - ("contents/" + KieModuleModelImpl.KMODULE_JAR_PATH).length());
                path = path + jarName;
            } else {
                path = path.substring(0, path.length() - ("/" + KieModuleModelImpl.KMODULE_JAR_PATH).length());
            }
            log.info("Virtual file physical path = " + path);
            return path;
        }
        catch (Exception e) {
            log.error("Error when reading virtual file from " + url.toString(), (Throwable)e);
            return url.getPath();
        }
    }

    @Override
    public InternalKieModule getKieModuleForKBase(String kBaseName) {
        return this.kJarFromKBaseName.get(kBaseName);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cl;
    }

    @Override
    public ClassLoader getClonedClassLoader() {
        return ProjectClassLoader.createProjectClassLoader((ClassLoader)this.cl.getParent());
    }
}

