/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.util.Stack;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.DroolsCompilerComponentFactory;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.core.rule.Dialectable;
import org.drools.core.rule.Package;
import org.drools.core.rule.Query;
import org.drools.core.rule.Rule;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.DeclarationScopeResolver;

public class RuleBuildContext
extends PackageBuildContext {
    private Rule rule;
    private Stack<RuleConditionElement> buildStack = new Stack();
    private RuleDescr ruleDescr;
    private DeclarationScopeResolver declarationResolver;
    private int patternId = -1;
    private DroolsCompilerComponentFactory compilerFactory;

    public RuleBuildContext(PackageBuilder pkgBuilder, RuleDescr ruleDescr, DialectCompiletimeRegistry dialectCompiletimeRegistry, Package pkg, Dialect defaultDialect) {
        Dialect dialect;
        this.declarationResolver = new DeclarationScopeResolver(pkgBuilder.getGlobals(), this.buildStack);
        this.declarationResolver.setPackage(pkg);
        this.ruleDescr = ruleDescr;
        this.rule = ruleDescr instanceof QueryDescr ? new Query(ruleDescr.getName()) : new Rule(ruleDescr.getName());
        this.rule.setPackage(pkg.getName());
        this.rule.setDialect(ruleDescr.getDialect());
        this.init(pkgBuilder, pkg, ruleDescr, dialectCompiletimeRegistry, defaultDialect, (Dialectable)this.rule);
        if (this.rule.getDialect() == null) {
            this.rule.setDialect(this.getDialect().getId());
        }
        if ((dialect = this.getDialect()) != null) {
            dialect.init(ruleDescr);
        }
        this.compilerFactory = pkgBuilder.getPackageBuilderConfiguration().getComponentFactory();
    }

    public Rule getRule() {
        return this.rule;
    }

    public RuleDescr getRuleDescr() {
        return this.ruleDescr;
    }

    public DeclarationScopeResolver getDeclarationResolver() {
        return this.declarationResolver;
    }

    public void setDeclarationResolver(DeclarationScopeResolver variables) {
        this.declarationResolver = variables;
    }

    public int getPatternId() {
        return this.patternId;
    }

    public int getNextPatternId() {
        return ++this.patternId;
    }

    public void setPatternId(int patternId) {
        this.patternId = patternId;
    }

    public Stack<RuleConditionElement> getBuildStack() {
        return this.buildStack;
    }

    public DroolsCompilerComponentFactory getCompilerFactory() {
        return this.compilerFactory;
    }

    public void setCompilerFactory(DroolsCompilerComponentFactory compilerFactory) {
        this.compilerFactory = compilerFactory;
    }
}

