/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.util.Arrays;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;

public abstract class BaseKnowledgeBuilderResultImpl
implements KnowledgeBuilderResult {
    private final Resource resource;

    protected BaseKnowledgeBuilderResultImpl(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public abstract ResultSeverity getSeverity();

    public boolean isError() {
        return this.getSeverity().equals((Object)ResultSeverity.ERROR);
    }

    public abstract String getMessage();

    public abstract int[] getLines();

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getMessage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeBuilderResult that = (KnowledgeBuilderResult)o;
        if (this.resource != null ? !this.resource.equals(that.getResource()) : that.getResource() != null) {
            return false;
        }
        return this.getMessage().equals(that.getMessage()) && Arrays.equals(this.getLines(), that.getLines());
    }

    public int hashCode() {
        int hash = 29 * this.getMessage().hashCode() + 31 * Arrays.hashCode(this.getLines());
        return this.resource != null ? hash + 37 * this.resource.hashCode() : hash;
    }
}

