/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.Arrays;
import org.drools.RuntimeDroolsException;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectConfiguration;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.rule.Package;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDialectConfiguration
implements DialectConfiguration {
    protected static transient Logger logger = LoggerFactory.getLogger(JavaDialectConfiguration.class);
    public static final String JAVA_COMPILER_PROPERTY = "drools.dialect.java.compiler";
    public static final int ECLIPSE = 0;
    public static final int JANINO = 1;
    public static final String[] LANGUAGE_LEVELS = new String[]{"1.5", "1.6", "1.7"};
    private String languageLevel;
    private PackageBuilderConfiguration conf;
    private int compiler;

    @Override
    public void init(PackageBuilderConfiguration conf) {
        this.conf = conf;
        this.setCompiler(this.getDefaultCompiler());
        this.setJavaLanguageLevel(this.getDefaultLanguageLevel());
    }

    @Override
    public PackageBuilderConfiguration getPackageBuilderConfiguration() {
        return this.conf;
    }

    @Override
    public Dialect newDialect(PackageBuilder packageBuilder, PackageRegistry pkgRegistry, Package pkg) {
        return new JavaDialect(packageBuilder, pkgRegistry, pkg);
    }

    public String getJavaLanguageLevel() {
        return this.languageLevel;
    }

    public void setJavaLanguageLevel(String languageLevel) {
        if (Arrays.binarySearch(LANGUAGE_LEVELS, languageLevel) < 0) {
            throw new RuntimeDroolsException("value '" + languageLevel + "' is not a valid language level");
        }
        this.languageLevel = languageLevel;
    }

    public void setCompiler(int compiler) {
        if (compiler == 0) {
            try {
                Class.forName("org.eclipse.jdt.internal.compiler.Compiler", true, (ClassLoader)this.conf.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("The Eclipse JDT Core jar is not in the classpath");
            }
        }
        if (compiler == 1) {
            try {
                Class.forName("org.codehaus.janino.Parser", true, (ClassLoader)this.conf.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("The Janino jar is not in the classpath");
            }
        }
        switch (compiler) {
            case 0: {
                this.compiler = 0;
                break;
            }
            case 1: {
                this.compiler = 1;
                break;
            }
            default: {
                throw new RuntimeDroolsException("value '" + compiler + "' is not a valid compiler");
            }
        }
    }

    public int getCompiler() {
        return this.compiler;
    }

    private int getDefaultCompiler() {
        try {
            String prop = this.conf.getChainedProperties().getProperty(JAVA_COMPILER_PROPERTY, "ECLIPSE");
            if (prop.equals("ECLIPSE".intern())) {
                return 0;
            }
            if (prop.equals("JANINO")) {
                return 1;
            }
            logger.error("Drools config: unable to use the drools.compiler property. Using default. It was set to:" + prop);
            return 0;
        }
        catch (SecurityException e) {
            logger.error("Drools config: unable to read the drools.compiler property. Using default.", (Throwable)e);
            return 0;
        }
    }

    private String getDefaultLanguageLevel() {
        String level = this.conf.getChainedProperties().getProperty("drools.dialect.java.compiler.lnglevel", null);
        if (level == null) {
            String version = System.getProperty("java.version");
            level = version.startsWith("1.5") ? "1.5" : (version.startsWith("1.6") ? "1.6" : (version.startsWith("1.7") ? "1.7" : "1.5"));
        }
        if (Arrays.binarySearch(LANGUAGE_LEVELS, level) < 0) {
            throw new RuntimeDroolsException("value '" + level + "' is not a valid language level");
        }
        return level;
    }
}

