/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command;

import java.util.HashMap;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.common.DefaultFactHandle;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.runtime.impl.ExecutionResultImpl;
import org.kie.command.Command;
import org.kie.command.Context;
import org.kie.runtime.ExecutionResults;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.rule.FactHandle;

public class ExecuteCommand
implements GenericCommand<ExecutionResults> {
    private String outIdentifier;
    private Command<ExecutionResults> command;
    private boolean disconnected = false;

    public ExecuteCommand(Command command) {
        this.command = command;
    }

    public ExecuteCommand(String identifier, Command command) {
        this.command = command;
        this.outIdentifier = identifier;
    }

    public ExecuteCommand(String identifier, Command command, boolean disconnected) {
        this.command = command;
        this.outIdentifier = identifier;
        this.disconnected = disconnected;
    }

    public ExecuteCommand(Command command, boolean disconnected) {
        this.command = command;
        this.disconnected = disconnected;
    }

    @Override
    public ExecutionResults execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        ExecutionResults kresults = null;
        kresults = ksession instanceof StatefulKnowledgeSessionImpl ? ((StatefulKnowledgeSessionImpl)ksession).execute(context, this.command) : ksession.execute(this.command);
        if (this.outIdentifier != null) {
            ((ExecutionResultImpl)((KnowledgeCommandContext)context).getExecutionResults()).getResults().put(this.outIdentifier, kresults);
        }
        if (this.disconnected) {
            ExecutionResultImpl disconnectedResults = new ExecutionResultImpl();
            HashMap<String, Object> disconnectedHandles = new HashMap<String, Object>();
            for (String key : kresults.getIdentifiers()) {
                FactHandle handle = (FactHandle)kresults.getFactHandle(key);
                if (handle == null) continue;
                DefaultFactHandle disconnectedHandle = ((DefaultFactHandle)handle).clone();
                disconnectedHandle.disconnect();
                disconnectedHandles.put(key, disconnectedHandle);
            }
            disconnectedResults.setFactHandles(disconnectedHandles);
            disconnectedResults.setResults((HashMap)((ExecutionResultImpl)kresults).getResults());
            return disconnectedResults;
        }
        return kresults;
    }

    public Command getCommand() {
        return this.command;
    }

    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public String toString() {
        return "session.execute(" + this.command + ");";
    }
}

