/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.drools.RuntimeDroolsException;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DialectConfiguration;
import org.drools.compiler.DrlParser;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageRegistry;
import org.drools.compiler.xml.RulesSemanticModule;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.ConfFileUtils;
import org.drools.core.util.StringUtils;
import org.drools.factmodel.ClassBuilderFactory;
import org.drools.rule.Package;
import org.drools.rule.builder.DroolsCompilerComponentFactory;
import org.drools.xml.ChangeSetSemanticModule;
import org.drools.xml.DefaultSemanticModule;
import org.drools.xml.Handler;
import org.drools.xml.SemanticModule;
import org.drools.xml.SemanticModules;
import org.drools.xml.WrapperSemanticModule;
import org.kie.builder.KnowledgeBuilderConfiguration;
import org.kie.builder.ResultSeverity;
import org.kie.builder.conf.AccumulateFunctionOption;
import org.kie.builder.conf.ClassLoaderCacheOption;
import org.kie.builder.conf.DefaultDialectOption;
import org.kie.builder.conf.DefaultPackageNameOption;
import org.kie.builder.conf.DumpDirOption;
import org.kie.builder.conf.EvaluatorOption;
import org.kie.builder.conf.KBuilderSeverityOption;
import org.kie.builder.conf.KnowledgeBuilderOption;
import org.kie.builder.conf.LanguageLevelOption;
import org.kie.builder.conf.MultiValueKnowledgeBuilderOption;
import org.kie.builder.conf.ProcessStringEscapesOption;
import org.kie.builder.conf.PropertySpecificOption;
import org.kie.builder.conf.SingleValueKnowledgeBuilderOption;
import org.kie.internal.utils.ChainedProperties;
import org.kie.internal.utils.ClassLoaderUtil;
import org.kie.internal.utils.CompositeClassLoader;
import org.kie.runtime.rule.AccumulateFunction;

public class PackageBuilderConfiguration
implements KnowledgeBuilderConfiguration {
    private Map<String, DialectConfiguration> dialectConfigurations;
    private DefaultDialectOption defaultDialect;
    private CompositeClassLoader classLoader;
    private ChainedProperties chainedProperties;
    private Map<String, AccumulateFunction> accumulateFunctions;
    private EvaluatorRegistry evaluatorRegistry;
    private SemanticModules semanticModules;
    private File dumpDirectory;
    private boolean allowMultipleNamespaces = true;
    private boolean processStringEscapes = true;
    private boolean classLoaderCache = true;
    private PropertySpecificOption propertySpecificOption = PropertySpecificOption.ALLOWED;
    private String defaultPackageName;
    private Map<String, ResultSeverity> severityMap;
    private DroolsCompilerComponentFactory componentFactory;
    private ClassBuilderFactory classBuilderFactory;
    private LanguageLevelOption languageLevel = DrlParser.DEFAULT_LANGUAGE_LEVEL;

    public boolean isAllowMultipleNamespaces() {
        return this.allowMultipleNamespaces;
    }

    public void setAllowMultipleNamespaces(boolean allowMultipleNamespaces) {
        this.allowMultipleNamespaces = allowMultipleNamespaces;
    }

    public PackageBuilderConfiguration(ClassLoader ... classLoaders) {
        this.init(null, classLoaders);
    }

    public PackageBuilderConfiguration(Properties properties) {
        this.init(properties, (ClassLoader[])null);
    }

    public PackageBuilderConfiguration(Properties properties, ClassLoader ... classLoaders) {
        this.init(properties, classLoaders);
    }

    public PackageBuilderConfiguration(Properties properties, CompositeClassLoader classLoader) {
        this.init(properties, classLoader);
    }

    public PackageBuilderConfiguration() {
        this.init(null, (ClassLoader[])null);
    }

    private void init(Properties properties, CompositeClassLoader classLoader) {
        this.classLoader = classLoader;
        this.init(properties);
    }

    private void init(Properties properties, ClassLoader ... classLoaders) {
        this.setClassLoader(classLoaders);
        this.init(properties);
    }

    private void init(Properties properties) {
        this.chainedProperties = new ChainedProperties("packagebuilder.conf", (ClassLoader)this.classLoader, true);
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setProperty("drools.classLoaderCacheEnabled", this.chainedProperties.getProperty("drools.classLoaderCacheEnabled", "true"));
        this.dialectConfigurations = new HashMap<String, DialectConfiguration>();
        this.buildDialectConfigurationMap();
        this.buildAccumulateFunctionsMap();
        this.buildEvaluatorRegistry();
        this.buildDumpDirectory();
        this.buildSeverityMap();
        this.setProperty("drools.parser.processStringEscapes", this.chainedProperties.getProperty("drools.parser.processStringEscapes", "true"));
        this.setProperty("drools.defaultPackageName", this.chainedProperties.getProperty("drools.defaultPackageName", "defaultpkg"));
        this.componentFactory = new DroolsCompilerComponentFactory();
        this.classBuilderFactory = new ClassBuilderFactory();
    }

    private void buildSeverityMap() {
        this.severityMap = new HashMap<String, ResultSeverity>();
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, KBuilderSeverityOption.PROPERTY_NAME, true);
        int index = KBuilderSeverityOption.PROPERTY_NAME.length();
        for (Map.Entry entry : temp.entrySet()) {
            String identifier = ((String)entry.getKey()).trim().substring(index);
            this.severityMap.put(identifier, KBuilderSeverityOption.get((String)identifier, (String)((String)entry.getValue())).getSeverity());
        }
    }

    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty((CharSequence)(name = name.trim()))) {
            return;
        }
        if (name.equals("drools.dialect.default")) {
            this.setDefaultDialect(value);
        } else if (name.startsWith("drools.accumulate.function.")) {
            this.addAccumulateFunction(name.substring("drools.accumulate.function.".length()), value);
        } else if (name.startsWith("drools.evaluator.")) {
            this.evaluatorRegistry.addEvaluatorDefinition(value);
        } else if (name.equals("drools.dump.dir")) {
            this.buildDumpDirectory(value);
        } else if (name.equals("drools.defaultPackageName")) {
            this.setDefaultPackageName(value);
        } else if (name.equals("drools.parser.processStringEscapes")) {
            this.setProcessStringEscapes(Boolean.parseBoolean(value));
        } else if (name.equals("drools.classLoaderCacheEnabled")) {
            this.setClassLoaderCacheEnabled(Boolean.parseBoolean(value));
        } else if (name.startsWith(KBuilderSeverityOption.PROPERTY_NAME)) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            this.severityMap.put(key, KBuilderSeverityOption.get((String)key, (String)value).getSeverity());
        } else if (name.equals("drools.lang.level")) {
            this.setLanguageLevel(LanguageLevelOption.valueOf((String)value));
        }
    }

    public String getProperty(String name) {
        if (StringUtils.isEmpty((CharSequence)(name = name.trim()))) {
            return null;
        }
        if (name.equals("drools.dialect.default")) {
            return this.getDefaultDialect();
        }
        if (name.equals("drools.defaultPackageName")) {
            return this.getDefaultPackageName();
        }
        if (name.startsWith("drools.accumulate.function.")) {
            int index = "drools.accumulate.function.".length();
            AccumulateFunction function = this.accumulateFunctions.get(name.substring(index));
            return function != null ? function.getClass().getName() : null;
        }
        if (name.startsWith("drools.evaluator.")) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            EvaluatorDefinition evalDef = this.evaluatorRegistry.getEvaluatorDefinition(key);
            return evalDef != null ? evalDef.getClass().getName() : null;
        }
        if (name.equals("drools.dump.dir")) {
            return this.dumpDirectory != null ? this.dumpDirectory.toString() : null;
        }
        if (name.equals("drools.parser.processStringEscapes")) {
            return String.valueOf(this.isProcessStringEscapes());
        }
        if (name.equals("drools.classLoaderCacheEnabled")) {
            return String.valueOf(this.isClassLoaderCacheEnabled());
        }
        if (name.startsWith(KBuilderSeverityOption.PROPERTY_NAME)) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            ResultSeverity severity = this.severityMap.get(key);
            return severity.toString();
        }
        if (name.equals("drools.lang.level")) {
            return "" + this.getLanguageLevel();
        }
        return null;
    }

    public ChainedProperties getChainedProperties() {
        return this.chainedProperties;
    }

    private void buildDialectConfigurationMap() {
        HashMap dialectProperties = new HashMap();
        this.chainedProperties.mapStartsWith(dialectProperties, "drools.dialect", false);
        this.setDefaultDialect((String)dialectProperties.remove("drools.dialect.default"));
        for (Map.Entry entry : dialectProperties.entrySet()) {
            String str = (String)entry.getKey();
            String dialectName = str.substring(str.lastIndexOf(".") + 1);
            String dialectClass = (String)entry.getValue();
            this.addDialect(dialectName, dialectClass);
        }
    }

    public void addDialect(String dialectName, String dialectClass) {
        Class cls = null;
        try {
            cls = this.classLoader.loadClass(dialectClass);
            DialectConfiguration dialectConf = (DialectConfiguration)cls.newInstance();
            dialectConf.init(this);
            this.addDialect(dialectName, dialectConf);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Unable to load dialect '" + dialectClass + ":" + dialectName + ":" + (cls != null ? cls.getName() : "null") + "'", (Throwable)e);
        }
    }

    public void addDialect(String dialectName, DialectConfiguration dialectConf) {
        this.dialectConfigurations.put(dialectName, dialectConf);
    }

    public DialectCompiletimeRegistry buildDialectRegistry(PackageBuilder packageBuilder, PackageRegistry pkgRegistry, Package pkg) {
        DialectCompiletimeRegistry registry = new DialectCompiletimeRegistry();
        for (DialectConfiguration conf : this.dialectConfigurations.values()) {
            Dialect dialect = conf.newDialect(packageBuilder, pkgRegistry, pkg);
            registry.addDialect(dialect.getId(), dialect);
        }
        return registry;
    }

    public String getDefaultDialect() {
        return this.defaultDialect.getName();
    }

    public void setDefaultDialect(String defaultDialect) {
        this.defaultDialect = DefaultDialectOption.get((String)defaultDialect);
    }

    public DialectConfiguration getDialectConfiguration(String name) {
        return this.dialectConfigurations.get(name);
    }

    public void setDialectConfiguration(String name, DialectConfiguration configuration) {
        this.dialectConfigurations.put(name, configuration);
    }

    public CompositeClassLoader getClassLoader() {
        return this.classLoader.clone();
    }

    private void setClassLoader(ClassLoader ... classLoaders) {
        this.classLoader = ClassLoaderUtil.getClassLoader((ClassLoader[])classLoaders, this.getClass(), (boolean)this.isClassLoaderCacheEnabled());
    }

    public void addSemanticModule(SemanticModule module) {
        if (this.semanticModules == null) {
            this.initSemanticModules();
        }
        this.semanticModules.addSemanticModule(module);
    }

    public SemanticModules getSemanticModules() {
        if (this.semanticModules == null) {
            this.initSemanticModules();
        }
        return this.semanticModules;
    }

    public void initSemanticModules() {
        String[] locations;
        this.semanticModules = new SemanticModules();
        RulesSemanticModule ruleModule = new RulesSemanticModule("http://ddefault");
        this.semanticModules.addSemanticModule((SemanticModule)new WrapperSemanticModule("http://drools.org/drools-5.0", (SemanticModule)ruleModule));
        this.semanticModules.addSemanticModule((SemanticModule)new WrapperSemanticModule("http://drools.org/drools-5.2", (SemanticModule)ruleModule));
        this.semanticModules.addSemanticModule((SemanticModule)new ChangeSetSemanticModule());
        for (String moduleLocation : locations = this.chainedProperties.getProperty("semanticModules", "").split("\\s")) {
            if ((moduleLocation = moduleLocation.trim()).startsWith("\"")) {
                moduleLocation = moduleLocation.substring(1);
            }
            if (moduleLocation.endsWith("\"")) {
                moduleLocation = moduleLocation.substring(0, moduleLocation.length() - 1);
            }
            if (moduleLocation.equals("")) continue;
            this.loadSemanticModule(moduleLocation);
        }
    }

    public void loadSemanticModule(String moduleLocation) {
        URL url = ConfFileUtils.getURL((String)moduleLocation, (ClassLoader)this.classLoader, this.getClass());
        if (url == null) {
            throw new IllegalArgumentException(moduleLocation + " is specified but cannot be found.'");
        }
        Properties properties = ConfFileUtils.getProperties((URL)url);
        if (properties == null) {
            throw new IllegalArgumentException(moduleLocation + " is specified but cannot be found.'");
        }
        this.loadSemanticModule(properties);
    }

    public void loadSemanticModule(Properties properties) {
        String uri = properties.getProperty("uri", null);
        if (uri == null || uri.trim().equals("")) {
            throw new RuntimeException("Semantic Module URI property must not be empty");
        }
        DefaultSemanticModule module = new DefaultSemanticModule(uri);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String elementName = (String)entry.getKey();
            if ("uri".equals(elementName)) continue;
            if (elementName == null || elementName.trim().equals("")) {
                throw new RuntimeException("Element name must be specified for Semantic Module handler");
            }
            String handlerName = (String)entry.getValue();
            if (handlerName == null || handlerName.trim().equals("")) {
                throw new RuntimeException("Handler name must be specified for Semantic Module");
            }
            Handler handler = (Handler)ClassUtils.instantiateObject((String)handlerName, (ClassLoader)this.classLoader);
            if (handler == null) {
                throw new RuntimeException("Unable to load Semantic Module handler '" + elementName + ":" + handlerName + "'");
            }
            module.addHandler(elementName, handler);
        }
        this.semanticModules.addSemanticModule((SemanticModule)module);
    }

    private void buildAccumulateFunctionsMap() {
        this.accumulateFunctions = new HashMap<String, AccumulateFunction>();
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, "drools.accumulate.function.", true);
        int index = "drools.accumulate.function.".length();
        for (Map.Entry entry : temp.entrySet()) {
            String identifier = ((String)entry.getKey()).trim().substring(index);
            this.accumulateFunctions.put(identifier, this.loadAccumulateFunction(identifier, (String)entry.getValue()));
        }
    }

    public Map<String, String> getAccumulateFunctionsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, AccumulateFunction> entry : this.accumulateFunctions.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getClass().getName());
        }
        return result;
    }

    public void addAccumulateFunction(String identifier, String className) {
        this.accumulateFunctions.put(identifier, this.loadAccumulateFunction(identifier, className));
    }

    public void addAccumulateFunction(String identifier, Class<? extends AccumulateFunction> clazz) {
        try {
            this.accumulateFunctions.put(identifier, clazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException("Error loading accumulate function for identifier " + identifier + ". Instantiation failed for class " + clazz.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Error loading accumulate function for identifier " + identifier + ". Illegal access to class " + clazz.getName(), (Throwable)e);
        }
    }

    public AccumulateFunction getAccumulateFunction(String identifier) {
        return this.accumulateFunctions.get(identifier);
    }

    private AccumulateFunction loadAccumulateFunction(String identifier, String className) {
        try {
            Class clazz = this.classLoader.loadClass(className);
            return (AccumulateFunction)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Error loading accumulate function for identifier " + identifier + ". Class " + className + " not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException("Error loading accumulate function for identifier " + identifier + ". Instantiation failed for class " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Error loading accumulate function for identifier " + identifier + ". Illegal access to class " + className, (Throwable)e);
        }
    }

    private void buildEvaluatorRegistry() {
        this.evaluatorRegistry = new EvaluatorRegistry((ClassLoader)this.classLoader);
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, "drools.evaluator.", true);
        for (String className : temp.values()) {
            this.evaluatorRegistry.addEvaluatorDefinition(className);
        }
    }

    public EvaluatorRegistry getEvaluatorRegistry() {
        return this.evaluatorRegistry;
    }

    public void addEvaluatorDefinition(String className) {
        this.evaluatorRegistry.addEvaluatorDefinition(className);
    }

    public void addEvaluatorDefinition(EvaluatorDefinition def) {
        this.evaluatorRegistry.addEvaluatorDefinition(def);
    }

    private void buildDumpDirectory() {
        String dumpStr = this.chainedProperties.getProperty("drools.dump.dir", null);
        this.buildDumpDirectory(dumpStr);
    }

    private void buildDumpDirectory(String dumpStr) {
        if (dumpStr != null) {
            this.setDumpDir(new File(dumpStr));
        }
    }

    public File getDumpDir() {
        return this.dumpDirectory;
    }

    public void setDumpDir(File dumpDir) {
        if (!(dumpDir.isDirectory() && dumpDir.canWrite() && dumpDir.canRead())) {
            throw new RuntimeDroolsException("Drools dump directory is not accessible: " + dumpDir.toString());
        }
        this.dumpDirectory = dumpDir;
    }

    public boolean isProcessStringEscapes() {
        return this.processStringEscapes;
    }

    public void setProcessStringEscapes(boolean processStringEscapes) {
        this.processStringEscapes = processStringEscapes;
    }

    public boolean isClassLoaderCacheEnabled() {
        return this.classLoaderCache;
    }

    public void setClassLoaderCacheEnabled(boolean classLoaderCacheEnabled) {
        this.classLoaderCache = classLoaderCacheEnabled;
        this.classLoader.setCachingEnabled(this.classLoaderCache);
    }

    public String getDefaultPackageName() {
        return this.defaultPackageName;
    }

    public void setDefaultPackageName(String defaultPackageName) {
        this.defaultPackageName = defaultPackageName;
    }

    public DroolsCompilerComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public void setComponentFactory(DroolsCompilerComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public ClassBuilderFactory getClassBuilderFactory() {
        return this.classBuilderFactory;
    }

    public void setClassBuilderFactory(ClassBuilderFactory classBuilderFactory) {
        this.classBuilderFactory = classBuilderFactory;
    }

    public LanguageLevelOption getLanguageLevel() {
        return this.languageLevel;
    }

    public void setLanguageLevel(LanguageLevelOption languageLevel) {
        this.languageLevel = languageLevel;
    }

    public <T extends SingleValueKnowledgeBuilderOption> T getOption(Class<T> option) {
        if (DefaultDialectOption.class.equals(option)) {
            return (T)this.defaultDialect;
        }
        if (DumpDirOption.class.equals(option)) {
            return (T)DumpDirOption.get((File)this.dumpDirectory);
        }
        if (ProcessStringEscapesOption.class.equals(option)) {
            return (T)(this.processStringEscapes ? ProcessStringEscapesOption.YES : ProcessStringEscapesOption.NO);
        }
        if (DefaultPackageNameOption.class.equals(option)) {
            return (T)DefaultPackageNameOption.get((String)this.defaultPackageName);
        }
        if (ClassLoaderCacheOption.class.equals(option)) {
            return (T)(this.classLoaderCache ? ClassLoaderCacheOption.ENABLED : ClassLoaderCacheOption.DISABLED);
        }
        if (PropertySpecificOption.class.equals(option)) {
            return (T)this.propertySpecificOption;
        }
        if (LanguageLevelOption.class.equals(option)) {
            return (T)this.languageLevel;
        }
        return null;
    }

    public <T extends MultiValueKnowledgeBuilderOption> T getOption(Class<T> option, String key) {
        if (AccumulateFunctionOption.class.equals(option)) {
            return (T)AccumulateFunctionOption.get((String)key, (AccumulateFunction)this.accumulateFunctions.get(key));
        }
        if (EvaluatorOption.class.equals(option)) {
            return (T)EvaluatorOption.get((String)key, (org.kie.runtime.rule.EvaluatorDefinition)this.evaluatorRegistry.getEvaluatorDefinition(key));
        }
        if (KBuilderSeverityOption.class.equals(option)) {
            return (T)KBuilderSeverityOption.get((String)key, (ResultSeverity)this.severityMap.get(key));
        }
        return null;
    }

    public <T extends MultiValueKnowledgeBuilderOption> Set<String> getOptionKeys(Class<T> option) {
        if (AccumulateFunctionOption.class.equals(option)) {
            return this.accumulateFunctions.keySet();
        }
        if (EvaluatorOption.class.equals(option)) {
            return this.evaluatorRegistry.keySet();
        }
        if (KBuilderSeverityOption.class.equals(option)) {
            return this.severityMap.keySet();
        }
        return null;
    }

    public <T extends KnowledgeBuilderOption> void setOption(T option) {
        if (option instanceof DefaultDialectOption) {
            this.defaultDialect = (DefaultDialectOption)option;
        } else if (option instanceof AccumulateFunctionOption) {
            this.accumulateFunctions.put(((AccumulateFunctionOption)option).getName(), ((AccumulateFunctionOption)option).getFunction());
        } else if (option instanceof DumpDirOption) {
            this.dumpDirectory = ((DumpDirOption)option).getDirectory();
        } else if (option instanceof EvaluatorOption) {
            this.evaluatorRegistry.addEvaluatorDefinition((EvaluatorDefinition)((EvaluatorOption)option).getEvaluatorDefinition());
        } else if (option instanceof ProcessStringEscapesOption) {
            this.processStringEscapes = ((ProcessStringEscapesOption)option).isProcessStringEscapes();
        } else if (option instanceof DefaultPackageNameOption) {
            this.setDefaultPackageName(((DefaultPackageNameOption)option).getPackageName());
        } else if (option instanceof ClassLoaderCacheOption) {
            this.setClassLoaderCacheEnabled(((ClassLoaderCacheOption)option).isClassLoaderCacheEnabled());
        } else if (option instanceof KBuilderSeverityOption) {
            this.severityMap.put(((KBuilderSeverityOption)option).getName(), ((KBuilderSeverityOption)option).getSeverity());
        } else if (option instanceof PropertySpecificOption) {
            this.propertySpecificOption = (PropertySpecificOption)option;
        } else if (option instanceof LanguageLevelOption) {
            this.languageLevel = (LanguageLevelOption)option;
        }
    }
}

