/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.drools.base.dataproviders.MVELDataProvider;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.MVELExprDescr;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Declaration;
import org.drools.rule.From;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.FromBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.DialectUtil;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.DataProvider;
import org.drools.spi.DeclarationScopeResolver;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.Wireable;

public class MVELFromBuilder
implements FromBuilder {
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
        boolean typeSafe = context.isTypesafe();
        if (!dialect.isStrictMode()) {
            context.setTypesafe(false);
        }
        FromDescr fromDescr = (FromDescr)descr;
        MVELExprDescr expr = (MVELExprDescr)fromDescr.getDataSource();
        From from = null;
        try {
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            String text = expr.getText();
            context.getDeclarationResolver();
            AnalysisResult analysis = dialect.analyzeExpression(context, descr, text, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), context.getPackageBuilder().getGlobals()));
            if (analysis == null) {
                RuleConditionElement ruleConditionElement = null;
                return ruleConditionElement;
            }
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            Declaration[] declarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
            String[] declrStr = new String[declarations.length];
            int j = 0;
            Iterator<String> i$ = usedIdentifiers.getDeclrClasses().keySet().iterator();
            while (i$.hasNext()) {
                String str;
                declrStr[j] = str = i$.next();
                declarations[j++] = (Declaration)decls.get(str);
            }
            Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, analysis, declarations, null, null, context, "drools", KnowledgeHelper.class, false);
            MVELDataProvider dataProvider = new MVELDataProvider(unit, context.getDialect().getId());
            from = new From((DataProvider)dataProvider);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)from, (MVELCompileable)dataProvider);
            dataProvider.compile(data);
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, fromDescr);
            context.addError(new DescrBuildError(context.getParentDescr(), fromDescr, null, "Unable to build expression for 'from' : " + e.getMessage() + " '" + expr.getText() + "'"));
            RuleConditionElement ruleConditionElement = null;
            return ruleConditionElement;
        }
        finally {
            context.setTypesafe(typeSafe);
        }
        return from;
    }
}

