/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.io.File;
import org.drools.audit.KnowledgeRuntimeLoggerProviderImpl;
import org.drools.command.impl.CommandFactoryServiceImpl;
import org.drools.compiler.io.memory.MemoryFileSystem;
import org.drools.concurrent.ExecutorProviderImpl;
import org.drools.io.impl.ResourceFactoryServiceImpl;
import org.drools.marshalling.impl.MarshallerProviderImpl;
import org.kie.builder.GAV;
import org.kie.builder.KieBuilder;
import org.kie.builder.KieContainer;
import org.kie.builder.KieFileSystem;
import org.kie.builder.KieRepository;
import org.kie.builder.KieScanner;
import org.kie.builder.KieServices;
import org.kie.builder.impl.ClasspathKieProject;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.InternalKieScanner;
import org.kie.builder.impl.KieBuilderImpl;
import org.kie.builder.impl.KieContainerImpl;
import org.kie.builder.impl.KieFileSystemImpl;
import org.kie.builder.impl.KieModuleKieProject;
import org.kie.builder.impl.KieRepositoryImpl;
import org.kie.command.KieCommands;
import org.kie.concurrent.KieExecutors;
import org.kie.io.KieResources;
import org.kie.io.ResourceFactoryService;
import org.kie.logger.KieLoggers;
import org.kie.marshalling.KieMarshallers;
import org.kie.persistence.jpa.KieStoreServices;
import org.kie.util.ServiceRegistryImpl;

public class KieServicesImpl
implements KieServices {
    private ResourceFactoryService resourceFactory;

    public ResourceFactoryService getResourceFactory() {
        if (this.resourceFactory == null) {
            this.resourceFactory = new ResourceFactoryServiceImpl();
        }
        return this.resourceFactory;
    }

    public KieRepository getKieRepository() {
        return KieRepositoryImpl.INSTANCE;
    }

    public KieContainer getKieClasspathContainer() {
        ClasspathKieProject kProject = new ClasspathKieProject();
        return new KieContainerImpl(kProject, null);
    }

    public KieContainer getKieContainer(GAV gav) {
        KieModuleKieProject kProject = new KieModuleKieProject((InternalKieModule)this.getKieRepository().getKieModule(gav), this.getKieRepository());
        return new KieContainerImpl(kProject, this.getKieRepository());
    }

    public KieBuilder newKieBuilder(File file) {
        return file.isDirectory() ? new KieBuilderImpl(file) : this.newKieBuilder(new KieFileSystemImpl(MemoryFileSystem.readFromJar(file)));
    }

    public KieBuilder newKieBuilder(KieFileSystem kieFileSystem) {
        return new KieBuilderImpl(kieFileSystem);
    }

    public KieScanner newKieScanner(KieContainer kieContainer) {
        InternalKieScanner scanner = (InternalKieScanner)ServiceRegistryImpl.getInstance().get(KieScanner.class);
        scanner.setKieContainer(kieContainer);
        return scanner;
    }

    public KieResources getResources() {
        return new ResourceFactoryServiceImpl();
    }

    public KieCommands getCommands() {
        return new CommandFactoryServiceImpl();
    }

    public KieMarshallers getMarshallers() {
        return new MarshallerProviderImpl();
    }

    public KieLoggers getLoggers() {
        return new KnowledgeRuntimeLoggerProviderImpl();
    }

    public KieExecutors getExecutors() {
        return new ExecutorProviderImpl();
    }

    public KieStoreServices getStoreServices() {
        return (KieStoreServices)ServiceRegistryImpl.getInstance().get(KieStoreServices.class);
    }
}

