/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.commons.jci.compilers.CompilationResult;
import org.drools.commons.jci.compilers.EclipseJavaCompiler;
import org.drools.commons.jci.compilers.EclipseJavaCompilerSettings;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.commons.jci.readers.DiskResourceReader;
import org.drools.commons.jci.readers.ResourceReader;
import org.drools.compiler.io.memory.MemoryFileSystem;
import org.drools.core.util.StringUtils;
import org.drools.kproject.GAVImpl;
import org.drools.kproject.models.KieBaseModelImpl;
import org.drools.kproject.models.KieModuleModelImpl;
import org.drools.xml.MinimalPomParser;
import org.drools.xml.PomModel;
import org.kie.KnowledgeBaseConfiguration;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.GAV;
import org.kie.builder.KieBaseModel;
import org.kie.builder.KieBuilder;
import org.kie.builder.KieFactory;
import org.kie.builder.KieFileSystem;
import org.kie.builder.KieModule;
import org.kie.builder.KieModuleModel;
import org.kie.builder.KieServices;
import org.kie.builder.Message;
import org.kie.builder.ResourceType;
import org.kie.builder.Results;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.KieFileSystemImpl;
import org.kie.builder.impl.KieModuleKieProject;
import org.kie.builder.impl.KieRepositoryImpl;
import org.kie.builder.impl.MemoryKieModule;
import org.kie.builder.impl.MessageImpl;
import org.kie.builder.impl.Messages;
import org.kie.builder.impl.ResultsImpl;
import org.kie.conf.KnowledgeBaseOption;
import org.kie.io.Resource;

public class KieBuilderImpl
implements KieBuilder {
    private static final String RESOURCES_ROOT = "src/main/resources/";
    private Messages messages;
    private final ResourceReader srcMfs;
    private MemoryFileSystem trgMfs;
    private MemoryKieModule kModule;
    private PomModel pomModel;
    private byte[] pomXml;
    private GAV gav;
    private byte[] kModuleModelXml;
    private KieModuleModel kModuleModel;
    private Collection<KieModule> dependencies;

    public KieBuilderImpl(File file) {
        this.srcMfs = new DiskResourceReader(file);
        this.init();
    }

    public KieBuilderImpl(KieFileSystem kieFileSystem) {
        this.srcMfs = ((KieFileSystemImpl)kieFileSystem).asMemoryFileSystem();
        this.init();
    }

    public KieBuilder setDependencies(KieModule ... dependencies) {
        this.dependencies = Arrays.asList(dependencies);
        return this;
    }

    public KieBuilder setDependencies(Resource ... resources) {
        KieRepositoryImpl kr = (KieRepositoryImpl)KieServices.Factory.get().getKieRepository();
        ArrayList<KieModule> list = new ArrayList<KieModule>();
        for (Resource res : resources) {
            InternalKieModule depKieMod = (InternalKieModule)kr.getKieModule(res);
            list.add(depKieMod);
        }
        this.dependencies = list;
        return this;
    }

    private void init() {
        KieFactory kf = KieFactory.Factory.get();
        this.messages = new Messages();
        this.buildPomModel();
        this.buildKieModuleModel();
        if (this.pomModel != null) {
            this.gav = kf.newGav(this.pomModel.getGroupId(), this.pomModel.getArtifactId(), this.pomModel.getVersion());
        }
    }

    public Results build() {
        if (!this.isBuilt() && this.gav != null && this.kModuleModel != null) {
            this.trgMfs = new MemoryFileSystem();
            this.writePomAndKModule();
            this.compileJavaClasses();
            this.addKBasesFilesToTrg();
            this.kModule = new MemoryKieModule(this.gav, this.kModuleModel, this.trgMfs);
            if (this.dependencies != null && !this.dependencies.isEmpty()) {
                HashMap<GAV, InternalKieModule> modules = new HashMap<GAV, InternalKieModule>();
                for (KieModule kieModule : this.dependencies) {
                    modules.put(kieModule.getGAV(), (InternalKieModule)kieModule);
                }
                this.kModule.setDependencies(modules);
            }
            KieModuleKieProject kProject = new KieModuleKieProject(this.kModule, null);
            kProject.init();
            kProject.verify(this.messages);
            if (!this.hasResults(Message.Level.ERROR)) {
                KieServices.Factory.get().getKieRepository().addKieModule((KieModule)this.kModule);
            }
        }
        return new ResultsImpl(this.messages.getMessages(), null);
    }

    private void addKBasesFilesToTrg() {
        for (KieBaseModel kieBaseModel : this.kModuleModel.getKieBaseModels().values()) {
            this.addKBaseFilesToTrg(kieBaseModel);
        }
    }

    private KnowledgeBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModel kieBase, Properties properties, ClassLoader ... classLoaders) {
        KnowledgeBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration((Properties)properties, (ClassLoader[])classLoaders);
        kbConf.setOption((KnowledgeBaseOption)kieBase.getEqualsBehavior());
        kbConf.setOption((KnowledgeBaseOption)kieBase.getEventProcessingMode());
        return kbConf;
    }

    private void addKBaseFilesToTrg(KieBaseModel kieBase) {
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!this.filterFileInKBase(kieBase, fileName)) continue;
            byte[] bytes = this.srcMfs.getBytes(fileName);
            this.trgMfs.write(fileName.substring(RESOURCES_ROOT.length() - 1), bytes, true);
        }
    }

    private void addMetaInfBuilder() {
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.startsWith(RESOURCES_ROOT) || KieBuilderImpl.isKieExtension(fileName)) continue;
            byte[] bytes = this.srcMfs.getBytes(fileName);
            this.trgMfs.write(fileName.substring(RESOURCES_ROOT.length() - 1), bytes, true);
        }
    }

    private boolean filterFileInKBase(KieBaseModel kieBase, String fileName) {
        if (!KieBuilderImpl.isKieExtension(fileName)) {
            return false;
        }
        if (((KieBaseModelImpl)kieBase).isDefault()) {
            return true;
        }
        if (kieBase.getPackages().isEmpty()) {
            return this.isFileInKiePackage(fileName, kieBase.getName());
        }
        for (String pkg : kieBase.getPackages()) {
            if (!this.isFileInKiePackage(fileName, pkg)) continue;
            return true;
        }
        return false;
    }

    private boolean isFileInKiePackage(String fileName, String pkgName) {
        String pathName = pkgName.replace('.', '/');
        return fileName.startsWith(RESOURCES_ROOT + pathName + "/") || fileName.contains("/" + pathName + "/");
    }

    static boolean isKieExtension(String fileName) {
        return fileName.endsWith(ResourceType.DRL.getDefaultExtension()) || fileName.endsWith(ResourceType.BPMN2.getDefaultExtension());
    }

    public boolean hasResults(Message.Level ... levels) {
        if (!this.isBuilt()) {
            this.build();
        }
        return !MessageImpl.filterMessages(this.messages.getMessages(), levels).isEmpty();
    }

    public Results getResults(Message.Level ... levels) {
        if (!this.isBuilt()) {
            this.build();
        }
        return new ResultsImpl(MessageImpl.filterMessages(this.messages.getMessages(), levels), null);
    }

    public Results getResults() {
        if (!this.isBuilt()) {
            this.build();
        }
        return new ResultsImpl(this.messages.getMessages(), null);
    }

    public KieModule getKieModule() {
        if (!this.isBuilt()) {
            this.build();
        }
        if (this.hasResults(Message.Level.ERROR) || this.kModule == null) {
            throw new RuntimeException("Unable to get KieModule, Errors Existed");
        }
        return this.kModule;
    }

    private boolean isBuilt() {
        return this.kModule != null;
    }

    private void buildKieModuleModel() {
        if (this.srcMfs.isAvailable(KieModuleModelImpl.KMODULE_SRC_PATH)) {
            this.kModuleModelXml = this.srcMfs.getBytes(KieModuleModelImpl.KMODULE_SRC_PATH);
            try {
                this.kModuleModel = KieModuleModelImpl.fromXML(new ByteArrayInputStream(this.kModuleModelXml));
            }
            catch (Exception e) {
                this.messages.addMessage(Message.Level.ERROR, "kmodule.xml", "kmodulet.xml found, but unable to read\n" + e.getMessage());
            }
        } else {
            KieFactory kf = KieFactory.Factory.get();
            this.kModuleModel = kf.newKieModuleModel();
            ((KieModuleModelImpl)this.kModuleModel).newDefaultKieBaseModel();
            this.kModuleModelXml = this.kModuleModel.toXML().getBytes();
        }
    }

    public void buildPomModel() {
        this.pomXml = KieBuilderImpl.getOrGeneratePomXml(this.srcMfs);
        if (this.pomXml == null) {
            return;
        }
        try {
            PomModel tempPomModel = MinimalPomParser.parse((String)"pom.xml", (InputStream)new ByteArrayInputStream(this.pomXml));
            KieBuilderImpl.validatePomModel(tempPomModel);
            this.pomModel = tempPomModel;
        }
        catch (Exception e) {
            this.messages.addMessage(Message.Level.ERROR, "pom.xml", "maven pom.xml found, but unable to read\n" + e.getMessage());
        }
    }

    public static void validatePomModel(PomModel pomModel) {
        if (StringUtils.isEmpty((CharSequence)pomModel.getGroupId()) || StringUtils.isEmpty((CharSequence)pomModel.getArtifactId()) || StringUtils.isEmpty((CharSequence)pomModel.getVersion())) {
            throw new RuntimeException("Maven pom.properties exists but GAV content is malformed");
        }
    }

    public static byte[] getOrGeneratePomXml(ResourceReader mfs) {
        if (mfs.isAvailable("pom.xml")) {
            return mfs.getBytes("pom.xml");
        }
        return KieBuilderImpl.generatePomXml(KieServices.Factory.get().getKieRepository().getDefaultGAV()).getBytes();
    }

    public void writePomAndKModule() {
        this.addMetaInfBuilder();
        if (this.pomXml != null) {
            GAVImpl g = (GAVImpl)this.gav;
            this.trgMfs.write(g.getPomXmlPath(), this.pomXml, true);
            this.trgMfs.write(g.getPomPropertiesPath(), KieBuilderImpl.generatePomProperties(this.gav).getBytes(), true);
        }
        if (this.kModuleModelXml != null) {
            this.trgMfs.write(KieModuleModelImpl.KMODULE_JAR_PATH, this.kModuleModel.toXML().getBytes(), true);
        }
    }

    public static String generatePomXml(GAV gav) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        sBuilder.append("         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"> \n");
        sBuilder.append("    <modelVersion>4.0.0</modelVersion> \n");
        sBuilder.append("    <groupId>");
        sBuilder.append(gav.getGroupId());
        sBuilder.append("</groupId> \n");
        sBuilder.append("    <artifactId>");
        sBuilder.append(gav.getArtifactId());
        sBuilder.append("</artifactId> \n");
        sBuilder.append("    <version>");
        sBuilder.append(gav.getVersion());
        sBuilder.append("</version> \n");
        sBuilder.append("    <packaging>jar</packaging> \n");
        sBuilder.append("    <name>Default</name> \n");
        sBuilder.append("</project>  \n");
        return sBuilder.toString();
    }

    public static String generatePomProperties(GAV gav) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("groupId=");
        sBuilder.append(gav.getGroupId());
        sBuilder.append("\n");
        sBuilder.append("artifactId=");
        sBuilder.append(gav.getArtifactId());
        sBuilder.append("\n");
        sBuilder.append("version=");
        sBuilder.append(gav.getVersion());
        sBuilder.append("\n");
        return sBuilder.toString();
    }

    private void compileJavaClasses() {
        ArrayList<String> classFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.endsWith(".class")) continue;
            this.trgMfs.write(fileName, this.srcMfs.getBytes(fileName), true);
            classFiles.add(fileName.substring(0, fileName.length() - ".class".length()));
        }
        ArrayList<String> javaFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.endsWith(".java") || classFiles.contains(fileName.substring(0, fileName.length() - ".java".length()))) continue;
            javaFiles.add(fileName);
        }
        if (javaFiles.isEmpty()) {
            return;
        }
        String[] sourceFiles = javaFiles.toArray(new String[javaFiles.size()]);
        EclipseJavaCompiler compiler = this.createCompiler("src/main/java/");
        CompilationResult res = compiler.compile(sourceFiles, this.srcMfs, this.trgMfs);
        for (CompilationProblem problem : res.getErrors()) {
            this.messages.addMessage(problem);
        }
        for (CompilationProblem problem : res.getWarnings()) {
            this.messages.addMessage(problem);
        }
    }

    public static String findPomProperties(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String fileName = zipEntry.getName();
            if (!fileName.endsWith("pom.properties") || !fileName.startsWith("META-INF/maven/")) continue;
            return fileName;
        }
        return null;
    }

    public static File findPomProperties(File root) {
        File mavenRoot = new File(root, "META-INF/maven");
        return KieBuilderImpl.recurseToPomProperties(mavenRoot);
    }

    public static File recurseToPomProperties(File file) {
        for (File child : file.listFiles()) {
            if (child.isDirectory()) {
                File returnedFile = KieBuilderImpl.recurseToPomProperties(child);
                if (returnedFile == null) continue;
                return returnedFile;
            }
            if (!child.getName().endsWith("pom.properties")) continue;
            return child;
        }
        return null;
    }

    private EclipseJavaCompiler createCompiler(String prefix) {
        EclipseJavaCompilerSettings settings = new EclipseJavaCompilerSettings();
        settings.setSourceVersion("1.5");
        settings.setTargetVersion("1.5");
        return new EclipseJavaCompiler(settings, prefix);
    }
}

