/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import org.drools.kproject.models.KieSessionModelImpl;
import org.kie.KieBase;
import org.kie.builder.KieBaseModel;
import org.kie.builder.KieContainer;
import org.kie.builder.KieSessionModel;
import org.kie.builder.impl.ClasspathKieProject;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.KieContainerImpl;
import org.kie.cdi.KBase;
import org.kie.cdi.KSession;
import org.kie.runtime.KieSession;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.StatelessKieSession;
import org.kie.runtime.StatelessKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KProjectExtension
implements Extension {
    private static final Logger log = LoggerFactory.getLogger(KProjectExtension.class);
    private Set<String> kBaseNames;
    private Set<String> kSessionNames;
    ClasspathKieProject kProject;

    public void init() {
        this.kProject = new ClasspathKieProject();
    }

    <Object> void processInjectionTarget(@Observes ProcessInjectionTarget<Object> pit) {
        if (this.kProject == null) {
            this.init();
        }
        if (!pit.getInjectionTarget().getInjectionPoints().isEmpty()) {
            for (InjectionPoint ip : pit.getInjectionTarget().getInjectionPoints()) {
                KSession kSession;
                KBase kBase = (KBase)ip.getAnnotated().getAnnotation(KBase.class);
                if (kBase != null) {
                    if (this.kBaseNames == null) {
                        this.kBaseNames = new HashSet<String>();
                    }
                    this.kBaseNames.add(kBase.value());
                }
                if ((kSession = (KSession)ip.getAnnotated().getAnnotation(KSession.class)) == null) continue;
                if (this.kSessionNames == null) {
                    this.kSessionNames = new HashSet<String>();
                }
                this.kSessionNames.add(kSession.value());
            }
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (this.kProject != null) {
            KieContainerImpl kContainer = new KieContainerImpl(this.kProject, null);
            if (this.kBaseNames != null) {
                for (String kBaseQName : this.kBaseNames) {
                    KieBaseModel kBaseModel = this.kProject.getKieBaseModel(kBaseQName);
                    if (kBaseModel == null) {
                        log.error("Annotation @KBase({}) found, but no KieBaseModel exist.\nEither the required kproject.xml does not exist, was corrupted, or mising the KieBase entry", (Object)kBaseQName);
                        continue;
                    }
                    KBaseBean bean = new KBaseBean(kBaseModel, kContainer);
                    if (log.isDebugEnabled()) {
                        InternalKieModule kModule = this.kProject.getKieModuleForKBase(kBaseQName);
                        log.debug("Added Bean for @KBase({})", (Object)kBaseQName, (Object)kModule.getFile());
                    }
                    abd.addBean((Bean)bean);
                }
            }
            this.kBaseNames = null;
            if (this.kSessionNames != null) {
                for (String kSessionName : this.kSessionNames) {
                    InternalKieModule kModule;
                    KieSessionModel kSessionModel = this.kProject.getKieSessionModel(kSessionName);
                    if (kSessionModel == null) {
                        log.error("Annotation @KSession({}) found, but no KieSessioneModel exist.\nEither the required kproject.xml does not exist, was corrupted, or mising the KieBase entry", (Object)kSessionName);
                        continue;
                    }
                    if ("stateless".equals(kSessionModel.getType())) {
                        if (log.isDebugEnabled()) {
                            kModule = this.kProject.getKieModuleForKBase(((KieSessionModelImpl)kSessionModel).getKieBaseModel().getName());
                            log.debug("Added Bean for Stateless @Session({}) from: {}", (Object)kSessionName, (Object)kModule.getFile());
                        }
                        abd.addBean((Bean)new StatelessKSessionBean(kSessionModel, kContainer));
                        continue;
                    }
                    kModule = this.kProject.getKieModuleForKBase(((KieSessionModelImpl)kSessionModel).getKieBaseModel().getName());
                    log.debug("Added Bean for Stateful @Session({})  from: {}", (Object)kSessionName, (Object)kModule.getFile());
                    abd.addBean((Bean)new StatefulKSessionBean(kSessionModel, kContainer));
                }
            }
            this.kSessionNames = null;
        }
    }

    public static class StatefulKSessionBean
    implements Bean<KieSession> {
        static final Set<Type> types = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(KieSession.class, Object.class)));
        private Set<Annotation> qualifiers;
        private KieSessionModel kSessionModel;
        private KieContainer kContainer;

        public StatefulKSessionBean(final KieSessionModel kieSessionModelModel, KieContainer kContainer) {
            this.kSessionModel = kieSessionModelModel;
            this.kContainer = kContainer;
            this.qualifiers = Collections.unmodifiableSet(new HashSet<Annotation>(Arrays.asList(new AnnotationLiteral<Default>(){}, new AnnotationLiteral<Any>(){}, new KSession(){

                public Class<? extends Annotation> annotationType() {
                    return KSession.class;
                }

                public String value() {
                    return kieSessionModelModel.getName();
                }
            })));
        }

        public KieSession create(CreationalContext ctx) {
            return this.kContainer.getKieSession(this.kSessionModel.getName());
        }

        public void destroy(KieSession kBase, CreationalContext ctx) {
            ctx.release();
        }

        public Class getBeanClass() {
            return StatefulKnowledgeSession.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public String getName() {
            return null;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }
    }

    public static class StatelessKSessionBean
    implements Bean<StatelessKieSession> {
        static final Set<Type> types = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(StatelessKieSession.class, Object.class)));
        private Set<Annotation> qualifiers;
        private KieSessionModel kSessionModel;
        private KieContainer kieContainer;

        public StatelessKSessionBean(final KieSessionModel kieSessionModelModel, KieContainer kieContainer) {
            this.kSessionModel = kieSessionModelModel;
            this.kieContainer = kieContainer;
            this.qualifiers = Collections.unmodifiableSet(new HashSet<Annotation>(Arrays.asList(new AnnotationLiteral<Default>(){}, new AnnotationLiteral<Any>(){}, new KSession(){

                public Class<? extends Annotation> annotationType() {
                    return KSession.class;
                }

                public String value() {
                    return kieSessionModelModel.getName();
                }
            })));
        }

        public StatelessKieSession create(CreationalContext ctx) {
            return this.kieContainer.getKieStatelessSession(this.kSessionModel.getName());
        }

        public void destroy(StatelessKieSession kSession, CreationalContext ctx) {
            ctx.release();
        }

        public Class getBeanClass() {
            return StatelessKnowledgeSession.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public String getName() {
            return null;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }
    }

    public static class KBaseBean
    implements Bean<KieBase> {
        static final Set<Type> types = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(KieBase.class, Object.class)));
        private Set<Annotation> qualifiers;
        private KieContainer kieContainer;
        private KieBaseModel kBaseModel;

        public KBaseBean(final KieBaseModel kBaseModel, KieContainer kieContainer) {
            this.kBaseModel = kBaseModel;
            this.kieContainer = kieContainer;
            this.qualifiers = Collections.unmodifiableSet(new HashSet<Annotation>(Arrays.asList(new AnnotationLiteral<Default>(){}, new AnnotationLiteral<Any>(){}, new KBase(){

                public Class<? extends Annotation> annotationType() {
                    return KBase.class;
                }

                public String value() {
                    return kBaseModel.getName();
                }
            })));
        }

        public KieBase create(CreationalContext ctx) {
            KieBase kieBase = this.kieContainer.getKieBase(this.kBaseModel.getName());
            return kieBase;
        }

        public void destroy(KieBase kBase, CreationalContext ctx) {
            this.kieContainer = null;
            ctx.release();
        }

        public Class getBeanClass() {
            return KieBase.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public String getName() {
            return null;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }
    }
}

