/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.drools.ChangeSet;
import org.drools.PackageIntegrationException;
import org.drools.RuleBase;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldAccessor;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.builder.conf.impl.JaxbConfigurationImpl;
import org.drools.common.InternalRuleBase;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.compiler.BPMN2ProcessFactory;
import org.drools.compiler.BusinessRuleProvider;
import org.drools.compiler.BusinessRuleProviderFactory;
import org.drools.compiler.DecisionTableFactory;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.FieldTemplateError;
import org.drools.compiler.FunctionError;
import org.drools.compiler.GlobalError;
import org.drools.compiler.PMMLCompiler;
import org.drools.compiler.PMMLCompilerFactory;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageBuilderErrors;
import org.drools.compiler.PackageRegistry;
import org.drools.compiler.ParserError;
import org.drools.compiler.ProcessBuilder;
import org.drools.compiler.ProcessBuilderFactory;
import org.drools.compiler.ProcessLoadError;
import org.drools.compiler.ResourceTypeBuilder;
import org.drools.compiler.ResourceTypeBuilderRegistry;
import org.drools.compiler.RuleBuildError;
import org.drools.compiler.TypeDeclarationError;
import org.drools.compiler.xml.XmlPackageReader;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.core.util.StringUtils;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.definition.process.Process;
import org.drools.definition.type.FactField;
import org.drools.factmodel.ClassBuilder;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FactTemplateImpl;
import org.drools.facttemplates.FieldTemplate;
import org.drools.facttemplates.FieldTemplateImpl;
import org.drools.io.Resource;
import org.drools.io.impl.ByteArrayResource;
import org.drools.io.impl.ClassPathResource;
import org.drools.io.impl.ReaderResource;
import org.drools.io.internal.InternalResource;
import org.drools.lang.descr.AnnotationDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.lang.dsl.DefaultExpander;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Function;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.TypeDeclaration;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleBuilder;
import org.drools.rule.builder.dialect.DialectError;
import org.drools.runtime.pipeline.impl.DroolsJaxbHelperProviderImpl;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.type.DateFormats;
import org.drools.type.DateFormatsImpl;
import org.drools.util.CompositeClassLoader;
import org.drools.xml.XmlChangeSetReader;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBuilder {
    private Map<String, PackageRegistry> pkgRegistryMap;
    private List<DroolsError> results;
    private final PackageBuilderConfiguration configuration;
    public static final RuleBuilder ruleBuilder = new RuleBuilder();
    private ReteooRuleBase ruleBase;
    private final String defaultDialect;
    private CompositeClassLoader rootClassLoader;
    private Map<String, Class<?>> globals;
    private Resource resource;
    private List<DSLTokenizedMappingFile> dslFiles;
    private TimeIntervalParser timeParser;
    protected DateFormats dateFormats;
    private ProcessBuilder processBuilder;
    private PMMLCompiler pmmlCompiler;
    private Map<String, TypeDeclaration> builtinTypes;
    private Map<String, TypeDeclaration> cacheTypes;
    private Map<String, Map<String, AttributeDescr>> packageAttributes = new HashMap<String, Map<String, AttributeDescr>>();
    private Set<Resource> resourceDirectories = new HashSet<Resource>();

    public PackageBuilder() {
        this((RuleBase)null, null);
    }

    public PackageBuilder(Package pkg) {
        this(pkg, null);
    }

    public PackageBuilder(RuleBase ruleBase) {
        this(ruleBase, null);
    }

    public PackageBuilder(PackageBuilderConfiguration configuration) {
        this((RuleBase)null, configuration);
    }

    public PackageBuilder(Package pkg, PackageBuilderConfiguration configuration) {
        this.configuration = configuration == null ? new PackageBuilderConfiguration() : configuration;
        this.dateFormats = null;
        if (this.dateFormats == null) {
            this.dateFormats = new DateFormatsImpl();
        }
        this.rootClassLoader = this.configuration.getClassLoader();
        this.rootClassLoader.addClassLoader(this.getClass().getClassLoader());
        this.defaultDialect = this.configuration.getDefaultDialect();
        this.pkgRegistryMap = new HashMap<String, PackageRegistry>();
        this.results = new ArrayList<DroolsError>();
        PackageRegistry pkgRegistry = new PackageRegistry(this, pkg);
        pkgRegistry.setDialect(this.defaultDialect);
        this.pkgRegistryMap.put(pkg.getName(), pkgRegistry);
        this.globals = new HashMap();
        this.processBuilder = this.createProcessBuilder();
        this.builtinTypes = new HashMap<String, TypeDeclaration>();
        this.initBuiltinTypeDeclarations();
    }

    public PackageBuilder(RuleBase ruleBase, PackageBuilderConfiguration configuration) {
        this.configuration = configuration == null ? new PackageBuilderConfiguration() : configuration;
        this.rootClassLoader = ruleBase != null ? ((InternalRuleBase)ruleBase).getRootClassLoader() : this.configuration.getClassLoader();
        this.rootClassLoader.addClassLoader(this.getClass().getClassLoader());
        this.dateFormats = null;
        if (this.dateFormats == null) {
            this.dateFormats = new DateFormatsImpl();
        }
        this.defaultDialect = this.configuration.getDefaultDialect();
        this.pkgRegistryMap = new HashMap<String, PackageRegistry>();
        this.results = new ArrayList<DroolsError>();
        this.ruleBase = (ReteooRuleBase)ruleBase;
        this.globals = new HashMap();
        this.processBuilder = this.createProcessBuilder();
        this.builtinTypes = new HashMap<String, TypeDeclaration>();
        this.initBuiltinTypeDeclarations();
    }

    private void initBuiltinTypeDeclarations() {
        TypeDeclaration colType = new TypeDeclaration("Collection");
        colType.setTypesafe(false);
        colType.setTypeClass(Collection.class);
        this.builtinTypes.put("java.util.Collection", colType);
        TypeDeclaration mapType = new TypeDeclaration("Map");
        mapType.setTypesafe(false);
        mapType.setTypeClass(Map.class);
        this.builtinTypes.put("java.util.Map", mapType);
    }

    private ProcessBuilder createProcessBuilder() {
        try {
            return ProcessBuilderFactory.newProcessBuilder(this);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private PMMLCompiler getPMMLCompiler() {
        if (this.pmmlCompiler == null) {
            this.pmmlCompiler = PMMLCompilerFactory.getPMMLCompiler();
        }
        return this.pmmlCompiler;
    }

    public void addPackageFromDrl(Reader reader) throws DroolsParserException, IOException {
        this.resource = new ReaderResource(reader);
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(reader);
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.results.add(new ParserError("Parser returned a null Package", 0, 0));
        }
        if (!parser.hasErrors()) {
            this.addPackage(pkg);
        }
        this.resource = null;
    }

    public void addPackageFromDrl(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(resource.getInputStream());
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.results.add(new ParserError("Parser returned a null Package", 0, 0));
        }
        if (!parser.hasErrors()) {
            this.addPackage(pkg);
        }
        this.resource = null;
    }

    public void addPackageFromXml(Reader reader) throws DroolsParserException, IOException {
        this.resource = new ReaderResource(reader);
        XmlPackageReader xmlReader = new XmlPackageReader(this.configuration.getSemanticModules());
        xmlReader.getParser().setClassLoader((ClassLoader)this.rootClassLoader);
        try {
            xmlReader.read(reader);
        }
        catch (SAXException e) {
            throw new DroolsParserException(e.toString(), e.getCause());
        }
        this.addPackage(xmlReader.getPackageDescr());
        this.resource = null;
    }

    public void addPackageFromXml(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        XmlPackageReader xmlReader = new XmlPackageReader(this.configuration.getSemanticModules());
        xmlReader.getParser().setClassLoader((ClassLoader)this.rootClassLoader);
        try {
            xmlReader.read(resource.getReader());
        }
        catch (SAXException e) {
            throw new DroolsParserException(e.toString(), e.getCause());
        }
        this.addPackage(xmlReader.getPackageDescr());
        this.resource = null;
    }

    public void addPackageFromDrl(Reader source, Reader dsl) throws DroolsParserException, IOException {
        this.resource = new ReaderResource(source);
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(source, dsl);
        this.results.addAll(parser.getErrors());
        if (!parser.hasErrors()) {
            this.addPackage(pkg);
        }
        this.resource = null;
    }

    public void addPackageFromDslr(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        DrlParser parser = new DrlParser();
        DefaultExpander expander = this.getDslExpander();
        try {
            if (expander == null) {
                expander = new DefaultExpander();
            }
            String str = expander.expand(resource.getReader());
            if (expander.hasErrors()) {
                this.results.addAll(expander.getErrors());
            }
            PackageDescr pkg = parser.parse(str);
            this.results.addAll(parser.getErrors());
            if (!parser.hasErrors()) {
                this.addPackage(pkg);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.resource = null;
    }

    public void addPackageFromBrl(Resource resource) throws DroolsParserException {
        this.resource = resource;
        try {
            DefaultExpander expander;
            BusinessRuleProvider provider = BusinessRuleProviderFactory.getInstance().getProvider();
            Reader knowledge = provider.getKnowledgeReader(resource);
            DrlParser parser = new DrlParser();
            if (provider.hasDSLSentences() && null != (expander = this.getDslExpander())) {
                knowledge = new StringReader(expander.expand(knowledge));
                if (expander.hasErrors()) {
                    this.results.addAll(expander.getErrors());
                }
            }
            PackageDescr pkg = parser.parse(knowledge);
            if (parser.hasErrors()) {
                this.results.addAll(parser.getErrors());
            } else {
                this.addPackage(pkg);
            }
        }
        catch (Exception e) {
            throw new DroolsParserException(e);
        }
        finally {
            this.resource = null;
        }
    }

    public void addDsl(Resource resource) throws IOException {
        this.resource = resource;
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        if (!file.parseAndLoad(resource.getReader())) {
            this.results.addAll(file.getErrors());
        }
        if (this.dslFiles == null) {
            this.dslFiles = new ArrayList<DSLTokenizedMappingFile>();
        }
        this.dslFiles.add(file);
        this.resource = null;
    }

    public void addRuleFlow(Reader processSource) {
        this.addProcessFromXml(processSource);
    }

    public void addProcessFromXml(Resource resource) {
        this.resource = resource;
        try {
            this.results.addAll(this.processBuilder.addProcessFromXml(resource));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            this.results.add(new ProcessLoadError("Unable to load process.", e));
        }
        this.results = this.getResults(this.results);
        this.resource = null;
    }

    public void addProcessFromXml(Reader processSource) {
        this.addProcessFromXml((Resource)new ReaderResource(processSource));
    }

    public void addKnowledgeResource(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        block23: {
            try {
                if (ResourceType.DRL.equals((Object)type)) {
                    ((InternalResource)resource).setResourceType(type);
                    this.addPackageFromDrl(resource);
                    break block23;
                }
                if (ResourceType.DSLR.equals((Object)type)) {
                    ((InternalResource)resource).setResourceType(type);
                    this.addPackageFromDslr(resource);
                    break block23;
                }
                if (ResourceType.DSL.equals((Object)type)) {
                    ((InternalResource)resource).setResourceType(type);
                    this.addDsl(resource);
                    break block23;
                }
                if (ResourceType.XDRL.equals((Object)type)) {
                    ((InternalResource)resource).setResourceType(type);
                    this.addPackageFromXml(resource);
                    break block23;
                }
                if (ResourceType.BRL.equals((Object)type)) {
                    ((InternalResource)resource).setResourceType(type);
                    this.addPackageFromBrl(resource);
                    break block23;
                }
                if (ResourceType.DRF.equals((Object)type)) {
                    ((InternalResource)resource).setResourceType(type);
                    this.addProcessFromXml(resource);
                    break block23;
                }
                if (ResourceType.BPMN2.equals((Object)type)) {
                    ((InternalResource)resource).setResourceType(type);
                    BPMN2ProcessFactory.configurePackageBuilder(this);
                    this.addProcessFromXml(resource);
                    break block23;
                }
                if (ResourceType.DTABLE.equals((Object)type)) {
                    ((InternalResource)resource).setResourceType(type);
                    DecisionTableConfiguration dtableConfiguration = (DecisionTableConfiguration)configuration;
                    String string = DecisionTableFactory.loadFromInputStream(resource.getInputStream(), dtableConfiguration);
                    this.addPackageFromDrl(new StringReader(string));
                    break block23;
                }
                if (ResourceType.PKG.equals((Object)type)) {
                    InputStream is = resource.getInputStream();
                    Package pkg = (Package)DroolsStreamUtils.streamIn((InputStream)is, (ClassLoader)this.configuration.getClassLoader());
                    is.close();
                    this.addPackage(pkg);
                    break block23;
                }
                if (ResourceType.CHANGE_SET.equals((Object)type)) {
                    ((InternalResource)resource).setResourceType(type);
                    XmlChangeSetReader reader = new XmlChangeSetReader(this.configuration.getSemanticModules());
                    if (resource instanceof ClassPathResource) {
                        reader.setClassLoader(((ClassPathResource)resource).getClassLoader(), ((ClassPathResource)resource).getClazz());
                    } else {
                        reader.setClassLoader((ClassLoader)this.configuration.getClassLoader(), null);
                    }
                    ChangeSet changeSet = reader.read(resource.getReader());
                    if (changeSet == null) {
                        // empty if block
                    }
                    for (Resource nestedResource : changeSet.getResourcesAdded()) {
                        InternalResource iNestedResourceResource = (InternalResource)nestedResource;
                        if (iNestedResourceResource.isDirectory()) {
                            this.resourceDirectories.add((Resource)iNestedResourceResource);
                            for (Resource childResource : iNestedResourceResource.listResources()) {
                                if (((InternalResource)childResource).isDirectory()) continue;
                                ((InternalResource)childResource).setResourceType(iNestedResourceResource.getResourceType());
                                this.addKnowledgeResource(childResource, iNestedResourceResource.getResourceType(), iNestedResourceResource.getConfiguration());
                            }
                            continue;
                        }
                        this.addKnowledgeResource((Resource)iNestedResourceResource, iNestedResourceResource.getResourceType(), iNestedResourceResource.getConfiguration());
                    }
                    break block23;
                }
                if (ResourceType.XSD.equals((Object)type)) {
                    String[] classes;
                    JaxbConfigurationImpl confImpl = (JaxbConfigurationImpl)configuration;
                    for (String cls : classes = DroolsJaxbHelperProviderImpl.addXsdModel(resource, this, confImpl.getXjcOpts(), confImpl.getSystemId())) {
                        confImpl.getClasses().add(cls);
                    }
                    break block23;
                }
                if (ResourceType.PMML.equals((Object)type)) {
                    PMMLCompiler compiler = this.getPMMLCompiler();
                    String theory = compiler.compile(resource.getInputStream());
                    this.addKnowledgeResource((Resource)new ByteArrayResource(theory.getBytes()), ResourceType.DRL, configuration);
                    break block23;
                }
                ResourceTypeBuilder builder = ResourceTypeBuilderRegistry.getInstance().getResourceTypeBuilder(type);
                if (builder != null) {
                    builder.setPackageBuilder(this);
                    builder.addKnowledgeResource(resource, type, configuration);
                    break block23;
                }
                throw new RuntimeException("Unknown resource type: " + type);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void addPackage(PackageDescr packageDescr) {
        PackageRegistry pkgRegistry;
        this.validateUniqueRuleNames(packageDescr);
        if (this.isEmpty(packageDescr.getNamespace())) {
            packageDescr.setNamespace(this.configuration.getDefaultPackageName());
        }
        if (!this.checkNamespace(packageDescr.getNamespace())) {
            return;
        }
        if (packageDescr.getAttributes().size() > 0) {
            Map<String, AttributeDescr> pkgAttributes = this.packageAttributes.get(packageDescr.getNamespace());
            if (pkgAttributes == null) {
                pkgAttributes = new HashMap<String, AttributeDescr>();
                this.packageAttributes.put(packageDescr.getNamespace(), pkgAttributes);
            }
            for (AttributeDescr attr : packageDescr.getAttributes()) {
                pkgAttributes.put(attr.getName(), attr);
            }
        }
        String dialectName = this.defaultDialect;
        for (AttributeDescr value : packageDescr.getAttributes()) {
            if (!"dialect".equals(value.getName())) continue;
            dialectName = value.getValue();
            break;
        }
        if ((pkgRegistry = this.pkgRegistryMap.get(packageDescr.getNamespace())) == null) {
            pkgRegistry = this.newPackage(packageDescr);
        } else {
            this.mergePackage(packageDescr);
        }
        pkgRegistry.setDialect(dialectName);
        if (!this.hasErrors()) {
            if (!packageDescr.getFunctions().isEmpty()) {
                for (FunctionDescr functionDescr : packageDescr.getFunctions()) {
                    if (this.isEmpty(functionDescr.getNamespace())) {
                        functionDescr.setNamespace(packageDescr.getNamespace());
                    }
                    if (this.isEmpty(functionDescr.getDialect())) {
                        functionDescr.setDialect(pkgRegistry.getDialect());
                    }
                    this.preCompileAddFunction(functionDescr);
                }
                for (FunctionDescr functionDescr : packageDescr.getFunctions()) {
                    this.addFunction(functionDescr);
                }
                this.compileAll();
                for (FunctionDescr functionDescr : packageDescr.getFunctions()) {
                    this.postCompileAddFunction(functionDescr);
                }
            }
            for (RuleDescr ruleDescr : packageDescr.getRules()) {
                if (this.isEmpty(ruleDescr.getNamespace())) {
                    ruleDescr.setNamespace(packageDescr.getNamespace());
                }
                Map<String, AttributeDescr> pkgAttributes = this.packageAttributes.get(packageDescr.getNamespace());
                this.inheritPackageAttributes(pkgAttributes, ruleDescr);
                if (this.isEmpty(ruleDescr.getDialect())) {
                    ruleDescr.addAttribute(new AttributeDescr("dialect", pkgRegistry.getDialect()));
                }
                this.addRule(ruleDescr);
            }
        }
        this.compileAll();
        try {
            this.reloadAll();
        }
        catch (Exception e) {
            this.results.add(new DialectError("Unable to wire compiled classes, probably related to compilation failures:" + e.getMessage()));
        }
        this.updateResults();
        if (this.ruleBase != null) {
            for (RuleDescr ruleDescr : packageDescr.getRules()) {
                pkgRegistry = this.pkgRegistryMap.get(ruleDescr.getNamespace());
                this.ruleBase.addRule(pkgRegistry.getPackage(), pkgRegistry.getPackage().getRule(ruleDescr.getName()));
            }
        }
    }

    private boolean checkNamespace(String newName) {
        if (this.configuration == null) {
            return true;
        }
        if (!this.pkgRegistryMap.isEmpty() && !this.pkgRegistryMap.containsKey(newName)) {
            return this.configuration.isAllowMultipleNamespaces();
        }
        return true;
    }

    public boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public void updateResults() {
        this.results = this.getResults(this.results);
    }

    public void compileAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.compileAll();
        }
    }

    public void reloadAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.getDialectRuntimeRegistry().onBeforeExecute();
        }
    }

    private List getResults(List results) {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            results = pkgRegistry.getDialectCompiletimeRegistry().addResults(results);
        }
        return results;
    }

    public synchronized void addPackage(Package newPkg) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(newPkg.getName());
        Package pkg = null;
        if (pkgRegistry != null) {
            pkg = pkgRegistry.getPackage();
        }
        if (pkg == null) {
            pkg = this.newPackage(new PackageDescr(newPkg.getName())).getPackage();
        }
        pkg.getDialectRuntimeRegistry().merge(newPkg.getDialectRuntimeRegistry(), this.rootClassLoader);
        if (newPkg.getFunctions() != null) {
            for (Map.Entry entry : newPkg.getFunctions().entrySet()) {
                pkg.addFunction((Function)entry.getValue());
            }
        }
        pkg.getClassFieldAccessorStore().merge(newPkg.getClassFieldAccessorStore());
        pkg.getDialectRuntimeRegistry().onBeforeExecute();
        TypeDeclaration lastType = null;
        try {
            if (newPkg.getTypeDeclarations() != null) {
                Iterator i$ = newPkg.getTypeDeclarations().values().iterator();
                while (i$.hasNext()) {
                    TypeDeclaration type;
                    lastType = type = (TypeDeclaration)i$.next();
                    type.setTypeClass(this.rootClassLoader.loadClass(type.getTypeClassName()));
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("unable to resolve Type Declaration class '" + lastType.getTypeName() + "'");
        }
        this.mergePackage(pkg, newPkg);
    }

    private void mergePackage(Package pkg, Package newPkg) {
        Map imports = pkg.getImports();
        imports.putAll(newPkg.getImports());
        String lastType = null;
        try {
            if (newPkg.getGlobals() != null && newPkg.getGlobals() != Collections.EMPTY_MAP) {
                Map globals = pkg.getGlobals();
                for (Map.Entry entry : newPkg.getGlobals().entrySet()) {
                    String type;
                    String identifier = (String)entry.getKey();
                    lastType = type = (String)entry.getValue();
                    if (globals.containsKey(identifier) && !((String)globals.get(identifier)).equals(type)) {
                        throw new PackageIntegrationException(pkg);
                    }
                    pkg.addGlobal(identifier, this.rootClassLoader.loadClass(type));
                    this.globals.put(identifier, this.rootClassLoader.loadClass(type));
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Unable to resolve class '" + lastType + "'");
        }
        if (newPkg.getTypeDeclarations() != null) {
            for (TypeDeclaration type : newPkg.getTypeDeclarations().values()) {
                if (pkg.getTypeDeclarations().containsKey(type.getTypeName())) continue;
                pkg.addTypeDeclaration(type);
            }
        }
        Rule[] newRules = newPkg.getRules();
        for (int i = 0; i < newRules.length; ++i) {
            Rule newRule = newRules[i];
            pkg.addRule(newRule);
        }
        if (newPkg.getRuleFlows() != null) {
            Map flows = newPkg.getRuleFlows();
            for (Process flow : flows.values()) {
                pkg.addProcess(flow);
            }
        }
    }

    private void validateUniqueRuleNames(PackageDescr packageDescr) {
        HashSet<String> names = new HashSet<String>();
        for (RuleDescr rule : packageDescr.getRules()) {
            String name = rule.getName();
            if (names.contains(name)) {
                this.results.add(new ParserError("Duplicate rule name: " + name, rule.getLine(), rule.getColumn()));
            }
            names.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageRegistry newPackage(PackageDescr packageDescr) {
        Package pkg;
        if (this.ruleBase == null || (pkg = this.ruleBase.getPackage(packageDescr.getName())) == null) {
            pkg = new Package(packageDescr.getName());
            pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache((ClassLoader)this.rootClassLoader));
            if (this.ruleBase != null) {
                this.ruleBase.lock();
                try {
                    this.ruleBase.addPackage(pkg);
                    pkg = this.ruleBase.getPackage(packageDescr.getName());
                }
                finally {
                    this.ruleBase.unlock();
                }
            } else {
                pkg.getDialectRuntimeRegistry().onAdd(this.rootClassLoader);
            }
        }
        PackageRegistry pkgRegistry = new PackageRegistry(this, pkg);
        pkgRegistry.addImport(packageDescr.getNamespace() + ".*");
        this.pkgRegistryMap.put(packageDescr.getName(), pkgRegistry);
        this.mergePackage(packageDescr);
        return pkgRegistry;
    }

    private void mergePackage(PackageDescr packageDescr) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(packageDescr.getNamespace());
        for (ImportDescr importEntry : packageDescr.getImports()) {
            pkgRegistry.addImport(importEntry.getTarget());
        }
        this.processTypeDeclarations(packageDescr);
        for (FunctionImportDescr functionImport : packageDescr.getFunctionImports()) {
            String importEntry = functionImport.getTarget();
            pkgRegistry.addStaticImport(importEntry);
            pkgRegistry.getPackage().addStaticImport(importEntry);
        }
        for (GlobalDescr global : packageDescr.getGlobals()) {
            String identifier = global.getIdentifier();
            String className = global.getType();
            while (className.indexOf(60) >= 0) {
                className = className.replaceAll("<[^<>]+?>", "");
            }
            try {
                Class clazz = pkgRegistry.getTypeResolver().resolveType(className);
                pkgRegistry.getPackage().addGlobal(identifier, clazz);
                this.globals.put(identifier, clazz);
            }
            catch (ClassNotFoundException e) {
                this.results.add(new GlobalError(identifier, global.getLine()));
                e.printStackTrace();
            }
        }
    }

    public TypeDeclaration getTypeDeclaration(Class<?> cls) {
        if (cls.isPrimitive() || cls.isArray()) {
            return null;
        }
        TypeDeclaration tdecl = null;
        PackageRegistry pkgReg = null;
        if (this.cacheTypes == null) {
            this.cacheTypes = new HashMap<String, TypeDeclaration>();
        } else {
            tdecl = this.cacheTypes.get(cls.getName());
            if (tdecl != null) {
                return tdecl;
            }
        }
        tdecl = this.builtinTypes.get(cls.getName());
        if (tdecl == null && (pkgReg = this.pkgRegistryMap.get(ClassUtils.getPackage(cls))) != null) {
            tdecl = pkgReg.getPackage().getTypeDeclaration(cls.getSimpleName());
        }
        if (tdecl == null) {
            tdecl = new TypeDeclaration(cls.getSimpleName());
        }
        LinkedHashSet<TypeDeclaration> tdecls = new LinkedHashSet<TypeDeclaration>();
        this.buildTypeDeclarations(cls, tdecls);
        TypeDeclaration[] tarray = tdecls.toArray(new TypeDeclaration[tdecls.size()]);
        for (int i = tarray.length - 1; i >= 0; --i) {
            TypeDeclaration currentTDecl = tarray[i];
            if ((tdecl.getSetMask() & 1) != 1) {
                tdecl.setRole(currentTDecl.getRole());
            }
            if ((tdecl.getSetMask() & 4) != 4) {
                tdecl.setFormat(currentTDecl.getFormat());
            }
            if ((tdecl.getSetMask() & 2) == 2) continue;
            tdecl.setTypesafe(currentTDecl.isTypesafe());
        }
        this.cacheTypes.put(cls.getName(), tdecl);
        return tdecl;
    }

    public void buildTypeDeclarations(Class<?> cls, Set<TypeDeclaration> tdecls) {
        Class<?>[] intfs;
        Object tdecl = null;
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            this.buildTypeDeclarationInterfaces(intf, tdecls);
        }
        for (cls = cls.getSuperclass(); tdecl == null && cls != null && cls != Object.class && this.buildTypeDeclarationInterfaces(cls, tdecls); cls = cls.getSuperclass()) {
        }
    }

    public boolean buildTypeDeclarationInterfaces(Class cls, Set<TypeDeclaration> tdecls) {
        Class<?>[] intfs;
        PackageRegistry pkgReg = null;
        TypeDeclaration tdecl = null;
        tdecl = this.builtinTypes.get(cls.getName());
        if (tdecl == null && (pkgReg = this.pkgRegistryMap.get(ClassUtils.getPackage((Class)cls))) != null) {
            tdecl = pkgReg.getPackage().getTypeDeclaration(cls.getSimpleName());
        }
        if (tdecl != null && !tdecls.add(tdecl)) {
            return false;
        }
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            pkgReg = this.pkgRegistryMap.get(ClassUtils.getPackage(intf));
            if (pkgReg != null) {
                tdecl = pkgReg.getPackage().getTypeDeclaration(intf.getSimpleName());
            }
            if (tdecl == null) continue;
            tdecls.add(tdecl);
        }
        for (Class<?> intf : intfs) {
            if (this.buildTypeDeclarationInterfaces(intf, tdecls)) continue;
            return false;
        }
        return true;
    }

    private String resolveSuperType(String sup, PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        for (ImportDescr id : packageDescr.getImports()) {
            if (!id.getTarget().endsWith("." + sup)) continue;
            return id.getTarget();
        }
        if (pkgRegistry != null) {
            for (String declaredName : pkgRegistry.getPackage().getTypeDeclarations().keySet()) {
                if (!declaredName.endsWith(sup)) continue;
                sup = pkgRegistry.getPackage().getTypeDeclaration(declaredName).getTypeClass().getName();
            }
        }
        if (sup != null && !sup.contains(".") && packageDescr.getNamespace() != null && packageDescr.getNamespace().length() > 0) {
            for (TypeDeclarationDescr td : packageDescr.getTypeDeclarations()) {
                if (!sup.equals(td.getTypeName())) continue;
                sup = packageDescr.getNamespace() + "." + sup;
            }
        }
        return sup;
    }

    private void fillSuperType(TypeDeclarationDescr typeDescr, PackageDescr packageDescr) {
        String declaredSuperType = typeDescr.getSuperTypeName();
        if (declaredSuperType != null) {
            boolean qualified;
            int separator = declaredSuperType.lastIndexOf(".");
            boolean bl = qualified = separator > 0;
            if (!qualified) {
                declaredSuperType = this.resolveSuperType(declaredSuperType, packageDescr, this.pkgRegistryMap.get(typeDescr.getNamespace()));
            }
            if ((separator = declaredSuperType.lastIndexOf(".")) < 0) {
                this.results.add(new TypeDeclarationError("Cannot resolve supertype '" + typeDescr.getSuperTypeName() + "'", typeDescr.getLine()));
                typeDescr.setSuperTypeName(null);
                typeDescr.setSuperTypeNamespace(null);
            } else {
                typeDescr.setSuperTypeName(declaredSuperType.substring(separator + 1));
                typeDescr.setSuperTypeNamespace(declaredSuperType.substring(0, separator));
            }
        }
    }

    private boolean mergeInheritedFields(TypeDeclarationDescr typeDescr) {
        if (typeDescr.getSuperTypeName() == null) {
            return false;
        }
        String simpleSuperTypeName = typeDescr.getSuperTypeName();
        String superTypePackageName = typeDescr.getSuperTypeNamespace();
        String fullSuper = superTypePackageName + "." + simpleSuperTypeName;
        LinkedHashMap<String, TypeFieldDescr> fieldMap = new LinkedHashMap<String, TypeFieldDescr>();
        boolean isSuperClassDeclared = true;
        boolean isSuperClassTagged = false;
        PackageRegistry registry = this.pkgRegistryMap.get(superTypePackageName);
        Package pack = null;
        if (registry == null) {
            this.results.add(new TypeDeclarationError("Cannot extend supertype '" + fullSuper + "' (not a declared type)", typeDescr.getLine()));
            typeDescr.setSuperTypeName(null);
            typeDescr.setSuperTypeNamespace(null);
            return false;
        }
        pack = registry.getPackage();
        if (pack != null) {
            TypeDeclaration superTypeDeclaration = pack.getTypeDeclaration(simpleSuperTypeName);
            if (superTypeDeclaration != null) {
                ClassDefinition classDef = superTypeDeclaration.getTypeClassDef();
                for (FactField fld : classDef.getFields()) {
                    TypeFieldDescr inheritedFlDescr = TypeFieldDescr.buildInheritedFromDefinition(fld);
                    fieldMap.put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
                }
                isSuperClassTagged = !superTypeDeclaration.isNovel();
            } else {
                isSuperClassDeclared = false;
            }
        } else {
            isSuperClassDeclared = false;
        }
        if (!isSuperClassDeclared || isSuperClassTagged) {
            try {
                ClassFieldInspector inspector = new ClassFieldInspector(registry.getTypeResolver().resolveType(fullSuper));
                for (String name : inspector.getGetterMethods().keySet()) {
                    if (inspector.isNonGetter(name) || "class".equals(name)) continue;
                    TypeFieldDescr inheritedFlDescr = new TypeFieldDescr(name, new PatternDescr(((Class)inspector.getFieldTypes().get(name)).getSimpleName()));
                    inheritedFlDescr.setInherited(true);
                    inheritedFlDescr.setIndex(inspector.getFieldNames().size() + (Integer)inspector.getFieldNames().get(name));
                    if (fieldMap.containsKey(inheritedFlDescr.getFieldName())) continue;
                    fieldMap.put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeDroolsException("Unable to resolve Type Declaration superclass '" + fullSuper + "'");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        fieldMap.putAll(typeDescr.getFields());
        typeDescr.setFields(fieldMap);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTypeDeclarations(PackageDescr packageDescr) {
        PackageRegistry defaultRegistry = this.pkgRegistryMap.get(packageDescr.getNamespace());
        PackageRegistry pkgRegistry = null;
        Iterator<TypeDeclarationDescr> i$ = packageDescr.getTypeDeclarations().iterator();
        while (true) {
            Class<?> cls;
            if (!i$.hasNext()) break;
            TypeDeclarationDescr typeDescr = i$.next();
            int dotPos = typeDescr.getTypeName().lastIndexOf(46);
            if (dotPos >= 0) {
                int lastIndex;
                cls = null;
                try {
                    cls = Class.forName(typeDescr.getTypeName(), true, (ClassLoader)this.rootClassLoader);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                String qualifiedClass = typeDescr.getTypeName();
                while (cls == null && (lastIndex = qualifiedClass.lastIndexOf(46)) != -1) {
                    try {
                        qualifiedClass = qualifiedClass.substring(0, lastIndex) + "$" + qualifiedClass.substring(lastIndex + 1);
                        cls = Class.forName(qualifiedClass, true, (ClassLoader)this.rootClassLoader);
                    }
                    catch (ClassNotFoundException e) {
                        cls = null;
                    }
                }
                if (cls != null) {
                    String str = ClassUtils.getPackage((Class)cls);
                    typeDescr.setNamespace(str);
                    typeDescr.setTypeName(cls.getSimpleName());
                } else {
                    typeDescr.setNamespace(typeDescr.getTypeName().substring(0, dotPos));
                    typeDescr.setTypeName(typeDescr.getTypeName().substring(dotPos + 1));
                }
            }
            if (this.isEmpty(typeDescr.getNamespace())) {
                try {
                    cls = defaultRegistry.getTypeResolver().resolveType(typeDescr.getTypeName());
                    typeDescr.setNamespace(ClassUtils.getPackage((Class)cls));
                    typeDescr.setTypeName(cls.getSimpleName());
                }
                catch (ClassNotFoundException e) {
                    typeDescr.setNamespace(packageDescr.getNamespace());
                }
            }
            if (this.isEmpty(typeDescr.getNamespace())) {
                for (ImportDescr id : packageDescr.getImports()) {
                    String imp = id.getTarget();
                    if (!imp.endsWith(typeDescr.getTypeName())) continue;
                    typeDescr.setNamespace(imp.substring(0, imp.lastIndexOf(46)));
                }
            }
            this.fillSuperType(typeDescr, packageDescr);
            if (typeDescr.getNamespace().equals(packageDescr.getNamespace())) continue;
            PackageDescr altDescr = new PackageDescr(typeDescr.getNamespace());
            altDescr.addTypeDeclaration(typeDescr);
            for (ImportDescr imp : packageDescr.getImports()) {
                altDescr.addImport(imp);
            }
            if (this.getPackageRegistry().containsKey(altDescr.getNamespace())) {
                this.mergePackage(altDescr);
                continue;
            }
            this.newPackage(altDescr);
        }
        Collection<TypeDeclarationDescr> sortedTypeDescriptors = PackageBuilder.sortByHierarchy(packageDescr.getTypeDeclarations());
        Iterator<TypeDeclarationDescr> i$2 = sortedTypeDescriptors.iterator();
        while (true) {
            String expiration;
            String duration;
            String timestamp;
            AnnotationDescr annotationDescr;
            TypeDeclaration type;
            TypeDeclarationDescr typeDescr;
            block36: {
                String className;
                String templateName;
                String typesafe;
                String role;
                if (!i$2.hasNext()) {
                    return;
                }
                typeDescr = i$2.next();
                if (!typeDescr.getNamespace().equals(packageDescr.getNamespace())) continue;
                pkgRegistry = this.pkgRegistryMap.get(packageDescr.getNamespace());
                if (typeDescr.getSuperTypeName() != null && this.mergeInheritedFields(typeDescr)) {
                    for (TypeDeclarationDescr descr : sortedTypeDescriptors) {
                        if (typeDescr.getSuperTypeName().equals(descr.getTypeName()) && typeDescr.getSuperTypeNamespace().equals(descr.getNamespace())) {
                            typeDescr.getAnnotations().putAll(descr.getAnnotations());
                            break;
                        }
                        if (!typeDescr.getTypeName().equals(descr.getTypeName()) || !typeDescr.getNamespace().equals(descr.getNamespace())) continue;
                    }
                }
                type = new TypeDeclaration(typeDescr.getTypeName());
                if (this.resource != null && ((InternalResource)this.resource).hasURL()) {
                    type.setResource(this.resource);
                }
                String string = role = (annotationDescr = typeDescr.getAnnotation("role")) != null ? annotationDescr.getSingleValue() : null;
                if (role != null) {
                    type.setRole(TypeDeclaration.Role.parseRole((String)role));
                }
                String string2 = typesafe = (annotationDescr = typeDescr.getAnnotation("typesafe")) != null ? annotationDescr.getSingleValue() : null;
                if (typesafe != null) {
                    type.setTypesafe(Boolean.parseBoolean(typesafe));
                }
                String string3 = templateName = (annotationDescr = typeDescr.getAnnotation("template")) != null ? annotationDescr.getSingleValue() : null;
                if (templateName != null) {
                    type.setFormat(TypeDeclaration.Format.TEMPLATE);
                    FactTemplate template = pkgRegistry.getPackage().getFactTemplate(templateName);
                    if (template != null) {
                        type.setTypeTemplate(template);
                        break block36;
                    } else {
                        this.results.add(new TypeDeclarationError("Template not found for TypeDeclaration '" + template + "' for type '" + type.getTypeName() + "'", typeDescr.getLine()));
                        continue;
                    }
                }
                annotationDescr = typeDescr.getAnnotation("class");
                String string4 = className = annotationDescr != null ? annotationDescr.getSingleValue() : null;
                if (StringUtils.isEmpty((CharSequence)className)) {
                    className = type.getTypeName();
                }
                type.setFormat(TypeDeclaration.Format.POJO);
                try {
                    this.generateDeclaredBean(typeDescr, type, pkgRegistry);
                    Class clazz = pkgRegistry.getTypeResolver().resolveType(className);
                    type.setTypeClass(clazz);
                    if (type.getTypeClassDef() == null) break block36;
                    try {
                        this.buildFieldAccessors(type, pkgRegistry);
                        break block36;
                    }
                    catch (Exception e) {
                        this.results.add(new TypeDeclarationError("Error creating field accessors for TypeDeclaration '" + className + "' for type '" + type.getTypeName() + "'", typeDescr.getLine()));
                    }
                }
                catch (ClassNotFoundException e) {
                    this.results.add(new TypeDeclarationError("Class '" + className + "' not found for type declaration of '" + type.getTypeName() + "'", typeDescr.getLine()));
                }
                continue;
            }
            annotationDescr = typeDescr.getAnnotation("timestamp");
            String string = timestamp = annotationDescr != null ? annotationDescr.getSingleValue() : null;
            if (timestamp != null) {
                type.setTimestampAttribute(timestamp);
                ClassDefinition cd = type.getTypeClassDef();
                ClassFieldAccessorStore store = pkgRegistry.getPackage().getClassFieldAccessorStore();
                ClassFieldReader extractor = store.getReader(type.getTypeClass().getName(), timestamp, (AcceptsReadAccessor)new TypeDeclaration.TimestampAccessorSetter(type));
            }
            String string5 = duration = (annotationDescr = typeDescr.getAnnotation("duration")) != null ? annotationDescr.getSingleValue() : null;
            if (duration != null) {
                type.setDurationAttribute(duration);
                ClassDefinition cd = type.getTypeClassDef();
                ClassFieldAccessorStore store = pkgRegistry.getPackage().getClassFieldAccessorStore();
                ClassFieldReader extractor = store.getReader(type.getTypeClass().getName(), duration, (AcceptsReadAccessor)new TypeDeclaration.DurationAccessorSetter(type));
            }
            String string6 = expiration = (annotationDescr = typeDescr.getAnnotation("expires")) != null ? annotationDescr.getSingleValue() : null;
            if (expiration != null) {
                if (this.timeParser == null) {
                    this.timeParser = new TimeIntervalParser();
                }
                type.setExpirationOffset(this.timeParser.parse(expiration)[0].longValue());
            }
            boolean dynamic = typeDescr.getAnnotationNames().contains("propertyChangeSupport");
            type.setDynamic(dynamic);
            pkgRegistry.getPackage().addTypeDeclaration(type);
        }
    }

    private boolean isNovelClass(TypeDeclarationDescr typeDescr) {
        try {
            PackageRegistry reg = this.pkgRegistryMap.get(typeDescr.getNamespace());
            if (reg != null) {
                reg.getTypeResolver().resolveType(typeDescr.getTypeName());
                return false;
            }
            return false;
        }
        catch (ClassNotFoundException cnfe) {
            return true;
        }
    }

    private final void buildFieldAccessors(TypeDeclaration type, PackageRegistry pkgRegistry) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, IOException, IntrospectionException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        ClassDefinition cd = type.getTypeClassDef();
        ClassFieldAccessorStore store = pkgRegistry.getPackage().getClassFieldAccessorStore();
        for (FieldDefinition attrDef : cd.getFieldsDefinitions()) {
            ClassFieldAccessor accessor = store.getAccessor(cd.getDefinedClass().getName(), attrDef.getName());
            attrDef.setReadWriteAccessor(accessor);
        }
    }

    private void generateDeclaredBean(TypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry) {
        String fullName = typeDescr.getNamespace() + "." + typeDescr.getTypeName();
        String fullSuperType = typeDescr.getSuperTypeName() != null ? typeDescr.getSuperTypeNamespace() + "." + typeDescr.getSuperTypeName() : Object.class.getName();
        String[] interfaces = new String[]{Serializable.class.getName()};
        ClassDefinition def = new ClassDefinition(fullName, fullSuperType, interfaces);
        if (typeDescr.getFields().size() > 0) {
            PriorityQueue<FieldDefinition> fieldDefs = this.sortFields(typeDescr.getFields(), pkgRegistry);
            while (fieldDefs.size() > 0) {
                FieldDefinition fld = fieldDefs.poll();
                def.addField(fld);
            }
        }
        type.setNovel(this.isNovelClass(typeDescr));
        if (type.isNovel()) {
            try {
                ClassBuilder cb = new ClassBuilder();
                byte[] d = cb.buildClass(def);
                JavaDialectRuntimeData dialect = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
                dialect.write(JavaDialectRuntimeData.convertClassToResourcePath((String)fullName), d);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.results.add(new TypeDeclarationError("Unable to create a class for declared type " + fullName + ": " + e.getMessage() + ";", typeDescr.getLine()));
            }
        }
        type.setTypeClassDef(def);
    }

    private PriorityQueue<FieldDefinition> sortFields(Map<String, TypeFieldDescr> flds, PackageRegistry pkgRegistry) {
        PriorityQueue<FieldDefinition> queue = new PriorityQueue<FieldDefinition>();
        int last = 0;
        for (TypeFieldDescr field : flds.values()) {
            last = Math.max(last, field.getIndex());
        }
        for (TypeFieldDescr field : flds.values()) {
            if (field.getIndex() < 0) {
                field.setIndex(++last);
            }
            try {
                String fullFieldType = pkgRegistry.getTypeResolver().resolveType(field.getPattern().getObjectType()).getName();
                FieldDefinition fieldDef = new FieldDefinition(field.getFieldName(), fullFieldType);
                boolean isKey = field.getAnnotation("key") != null;
                fieldDef.setKey(isKey);
                fieldDef.setIndex(field.getIndex());
                fieldDef.setInherited(field.isInherited());
                fieldDef.setInitExpr(field.getInitExpr());
                queue.add(fieldDef);
            }
            catch (ClassNotFoundException cnfe) {
                this.results.add(new TypeDeclarationError(cnfe.getMessage(), field.getLine()));
            }
        }
        return queue;
    }

    private void addFunction(FunctionDescr functionDescr) {
        functionDescr.setResource(this.resource);
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(functionDescr.getNamespace());
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.addFunction(functionDescr, pkgRegistry.getTypeResolver(), this.resource);
    }

    private void preCompileAddFunction(FunctionDescr functionDescr) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(functionDescr.getNamespace());
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.preCompileAddFunction(functionDescr, pkgRegistry.getTypeResolver());
    }

    private void postCompileAddFunction(FunctionDescr functionDescr) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(functionDescr.getNamespace());
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.postCompileAddFunction(functionDescr, pkgRegistry.getTypeResolver());
    }

    private void addFactTemplate(PackageDescr pkgDescr, FactTemplateDescr factTemplateDescr) {
        ArrayList<FieldTemplateImpl> fields = new ArrayList<FieldTemplateImpl>();
        int index = 0;
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(pkgDescr.getNamespace());
        for (FieldTemplateDescr fieldTemplateDescr : factTemplateDescr.getFields()) {
            FieldTemplateImpl fieldTemplate = null;
            try {
                fieldTemplate = new FieldTemplateImpl(fieldTemplateDescr.getName(), index++, pkgRegistry.getTypeResolver().resolveType(fieldTemplateDescr.getClassType()));
            }
            catch (ClassNotFoundException e) {
                this.results.add(new FieldTemplateError(pkgRegistry.getPackage(), fieldTemplateDescr, null, "Unable to resolve Class '" + fieldTemplateDescr.getClassType() + "'"));
            }
            fields.add(fieldTemplate);
        }
        FactTemplateImpl factTemplate = new FactTemplateImpl(pkgRegistry.getPackage(), factTemplateDescr.getName(), fields.toArray(new FieldTemplate[fields.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRule(RuleDescr ruleDescr) {
        ruleDescr.setResource(this.resource);
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(ruleDescr.getNamespace());
        Package pkg = pkgRegistry.getPackage();
        DialectCompiletimeRegistry ctr = pkgRegistry.getDialectCompiletimeRegistry();
        RuleBuildContext context = new RuleBuildContext(this, ruleDescr, ctr, pkg, ctr.getDialect(pkgRegistry.getDialect()));
        ruleBuilder.build(context);
        this.results.addAll(context.getErrors());
        if (this.resource != null && ((InternalResource)this.resource).hasURL()) {
            context.getRule().setResource(this.resource);
        }
        context.getDialect().addRule(context);
        if (this.ruleBase != null && pkg.getRule(ruleDescr.getName()) != null) {
            this.ruleBase.lock();
            try {
                this.ruleBase.removeRule(pkg, pkg.getRule(ruleDescr.getName()));
            }
            finally {
                this.ruleBase.unlock();
            }
        }
        pkg.addRule(context.getRule());
    }

    public Package getPackage() {
        PackageRegistry pkgRegistry = null;
        if (!this.pkgRegistryMap.isEmpty()) {
            pkgRegistry = (PackageRegistry)this.pkgRegistryMap.values().toArray()[0];
        }
        Package pkg = null;
        if (pkgRegistry != null) {
            pkg = pkgRegistry.getPackage();
        }
        if (this.hasErrors() && pkg != null) {
            pkg.setError(this.getErrors().toString());
        }
        return pkg;
    }

    public Package[] getPackages() {
        Package[] pkgs = new Package[this.pkgRegistryMap.size()];
        int i = 0;
        String errors = null;
        if (!this.getErrors().isEmpty()) {
            errors = this.getErrors().toString();
        }
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            Package pkg = pkgRegistry.getPackage();
            pkg.getDialectRuntimeRegistry().onBeforeExecute();
            if (errors != null) {
                pkg.setError(errors);
            }
            pkgs[i++] = pkg;
        }
        return pkgs;
    }

    public PackageBuilderConfiguration getPackageBuilderConfiguration() {
        return this.configuration;
    }

    public PackageRegistry getPackageRegistry(String name) {
        return this.pkgRegistryMap.get(name);
    }

    public Map<String, PackageRegistry> getPackageRegistry() {
        return this.pkgRegistryMap;
    }

    public DateFormats getDateFormats() {
        return this.dateFormats;
    }

    public DefaultExpander getDslExpander() {
        DefaultExpander expander = new DefaultExpander();
        if (this.dslFiles == null || this.dslFiles.isEmpty()) {
            return null;
        }
        for (DSLTokenizedMappingFile file : this.dslFiles) {
            expander.addDSLMapping(file.getMapping());
        }
        return expander;
    }

    public Map<String, Class<?>> getGlobals() {
        return this.globals;
    }

    public boolean hasErrors() {
        return !this.results.isEmpty();
    }

    public PackageBuilderErrors getErrors() {
        return new PackageBuilderErrors(this.results.toArray(new DroolsError[this.results.size()]));
    }

    protected void resetErrors() {
        this.results.clear();
    }

    public String getDefaultDialect() {
        return this.defaultDialect;
    }

    private String ucFirst(String name) {
        return name.toUpperCase().charAt(0) + name.substring(1);
    }

    public CompositeClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    public static Collection<TypeDeclarationDescr> sortByHierarchy(List<TypeDeclarationDescr> typeDeclarations) {
        Node<TypeDeclarationDescr> root = new Node<TypeDeclarationDescr>(null);
        HashMap<String, Node<TypeDeclarationDescr>> map = new HashMap<String, Node<TypeDeclarationDescr>>();
        for (TypeDeclarationDescr tdescr : typeDeclarations) {
            String typeName = tdescr.getNamespace() + "." + tdescr.getTypeName();
            String superTypeName = tdescr.getSuperTypeNamespace() + "." + tdescr.getSuperTypeName();
            Node<TypeDeclarationDescr> node = (Node<TypeDeclarationDescr>)map.get(typeName);
            if (node == null) {
                node = new Node<TypeDeclarationDescr>(typeName, tdescr);
                map.put(typeName, node);
            } else if (node.getData() == null) {
                node.setData(tdescr);
            }
            if (superTypeName == null) {
                root.addChild(node);
                continue;
            }
            Node<TypeDeclarationDescr> superNode = (Node<TypeDeclarationDescr>)map.get(superTypeName);
            if (superNode == null) {
                superNode = new Node<TypeDeclarationDescr>(superTypeName);
                map.put(superTypeName, superNode);
            }
            superNode.addChild(node);
        }
        for (Node n : map.values()) {
            if (n.getData() != null) continue;
            root.addChild(n);
        }
        LinkedList<TypeDeclarationDescr> sortedList = new LinkedList<TypeDeclarationDescr>();
        root.accept(sortedList);
        return sortedList;
    }

    private void inheritPackageAttributes(Map<String, AttributeDescr> pkgAttributes, RuleDescr ruleDescr) {
        if (pkgAttributes == null) {
            return;
        }
        for (AttributeDescr attrDescr : pkgAttributes.values()) {
            String name = attrDescr.getName();
            AttributeDescr ruleAttrDescr = ruleDescr.getAttributes().get(name);
            if (ruleAttrDescr != null) continue;
            ruleDescr.getAttributes().put(name, attrDescr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T> {
        private String key;
        private T data;
        private List<Node<T>> children;

        public Node(String key) {
            this.key = key;
            this.children = new LinkedList<Node<T>>();
        }

        public Node(String key, T content) {
            this(key);
            this.data = content;
        }

        public void addChild(Node<T> child) {
            this.children.add(child);
        }

        public List<Node<T>> getChildren() {
            return this.children;
        }

        public String getKey() {
            return this.key;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T content) {
            this.data = content;
        }

        public void accept(List<T> list) {
            if (this.data != null) {
                list.add(this.data);
            }
            for (int j = 0; j < this.children.size(); ++j) {
                this.children.get(j).accept(list);
            }
        }
    }

    public static class SrcError
    extends DroolsError {
        private Object object;
        private String message;
        private int[] errorLines = new int[0];

        public SrcError(Object object, String message) {
            this.object = object;
            this.message = message;
        }

        public Object getObject() {
            return this.object;
        }

        public int[] getErrorLines() {
            return this.errorLines;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.message);
            buf.append(" : ");
            buf.append("\n");
            if (this.object instanceof CompilationProblem[]) {
                CompilationProblem[] problem = (CompilationProblem[])this.object;
                for (int i = 0; i < problem.length; ++i) {
                    buf.append("\t");
                    buf.append(problem[i]);
                    buf.append("\n");
                }
            } else if (this.object != null) {
                buf.append(this.object);
            }
            return buf.toString();
        }
    }

    public static class SrcErrorHandler
    extends ErrorHandler {
        public SrcErrorHandler(String message) {
            this.message = message;
        }

        public DroolsError getError() {
            return new SrcError(this.collectCompilerProblems(), this.message);
        }
    }

    public static class FunctionErrorHandler
    extends ErrorHandler {
        private FunctionDescr descr;

        public FunctionErrorHandler(FunctionDescr functionDescr, String message) {
            this.descr = functionDescr;
            this.message = message;
        }

        public DroolsError getError() {
            return new FunctionError(this.descr, this.collectCompilerProblems(), this.message);
        }
    }

    public static class RuleInvokerErrorHandler
    extends RuleErrorHandler {
        public RuleInvokerErrorHandler(BaseDescr ruleDescr, Rule rule, String message) {
            super(ruleDescr, rule, message);
        }
    }

    public static class RuleErrorHandler
    extends ErrorHandler {
        private BaseDescr descr;
        private Rule rule;

        public RuleErrorHandler(BaseDescr ruleDescr, Rule rule, String message) {
            this.descr = ruleDescr;
            this.rule = rule;
            this.message = message;
        }

        public DroolsError getError() {
            return new RuleBuildError(this.rule, this.descr, (Object)this.collectCompilerProblems(), this.message);
        }
    }

    public static abstract class ErrorHandler {
        private final List errors = new ArrayList();
        protected String message;
        private boolean inError = false;

        public boolean isInError() {
            return this.inError;
        }

        public void addError(CompilationProblem err) {
            this.errors.add(err);
            this.inError = true;
        }

        public abstract DroolsError getError();

        protected CompilationProblem[] collectCompilerProblems() {
            if (this.errors.size() == 0) {
                return null;
            }
            CompilationProblem[] list = new CompilationProblem[this.errors.size()];
            this.errors.toArray(list);
            return list;
        }
    }

    public static class PackageMergeException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 400L;

        public PackageMergeException(String message) {
            super(message);
        }
    }

    public static class MissingPackageNameException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 510L;

        public MissingPackageNameException(String message) {
            super(message);
        }
    }
}

