/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.HashMap;
import java.util.Map;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.base.mvel.MVELConsequence;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Declaration;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.Consequence;
import org.drools.spi.Wireable;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;

public class MVELConsequenceBuilder
implements ConsequenceBuilder {
    private static final Map<String, Macro> macros = new HashMap<String, Macro>(10);

    static {
        macros.put("insert", new Macro(){

            public String doMacro() {
                return "drools.insert";
            }
        });
        macros.put("insertLogical", new Macro(){

            public String doMacro() {
                return "drools.insertLogical";
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "drools.update";
            }
        });
        macros.put("retract", new Macro(){

            public String doMacro() {
                return "drools.retract";
            }
        });
        macros.put("entryPoints", new Macro(){

            public String doMacro() {
                return "drools.entryPoints";
            }
        });
        macros.put("exitPoints", new Macro(){

            public String doMacro() {
                return "drools.exitPoints";
            }
        });
    }

    public void build(RuleBuildContext context, String consequenceName) {
        context.getBuildStack().push((RuleConditionElement)context.getRule().getLhs());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect(context.getDialect().getId());
            RuleDescr ruleDescr = context.getRuleDescr();
            String text = "default".equals(consequenceName) ? (String)ruleDescr.getConsequence() : (String)ruleDescr.getNamedConsequences().get(consequenceName);
            text = MVELConsequenceBuilder.processMacros(text);
            Dialect.AnalysisResult analysis = dialect.analyzeBlock(context, context.getRuleDescr(), dialect.getInterceptors(), text, new Map[]{context.getDeclarationResolver().getDeclarationClasses(context.getRule()), context.getPackageBuilder().getGlobals()}, null);
            Declaration[] previousDeclarations = context.getDeclarationResolver().getDeclarations(context.getRule()).values().toArray(new Declaration[context.getDeclarationResolver().getDeclarations(context.getRule()).size()]);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, analysis, previousDeclarations, null, null, context);
            MVELConsequence expr = new MVELConsequence(unit, dialect.getId());
            if ("default".equals(consequenceName)) {
                context.getRule().setConsequence((Consequence)expr);
            } else {
                context.getRule().getNamedConsequences().put(consequenceName, expr);
            }
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData(context.getDialect().getId());
            data.addCompileable((Wireable)context.getRule(), (MVELCompileable)expr);
            expr.compile((ClassLoader)context.getPackageBuilder().getRootClassLoader());
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), null, "Unable to build expression for 'consequence': " + e.getMessage() + " '" + context.getRuleDescr().getConsequence() + "'"));
        }
    }

    public static String processMacros(String consequence) {
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(macros);
        return macroProcessor.parse(MVELConsequenceBuilder.delimitExpressions(consequence));
    }

    /*
     * Unable to fully structure code
     */
    public static String delimitExpressions(String s) {
        result = new StringBuilder();
        cs = s.toCharArray();
        brace = 0;
        sqre = 0;
        crly = 0;
        lastNonWhite = ';';
        i = 0;
        while (i < cs.length) {
            c = cs[i];
            switch (c) {
                case '/': {
                    if (i >= cs.length - 1 || cs[i + 1] != '*') ** GOTO lbl26
                    start = i;
                    i += 2;
                    while (i < cs.length) {
                        if (cs[i] == '*' && i < cs.length - 1 && cs[i + 1] == '/') {
                            ++i;
                            break;
                        }
                        if (cs[i] == '\n' || cs[i] == '\r') {
                            lastNonWhite = MVELConsequenceBuilder.checkAndAddSemiColon(result, brace, sqre, crly, lastNonWhite);
                        }
                        ++i;
                    }
                    result.append(cs, start, i - start);
                    ** GOTO lbl49
lbl26:
                    // 1 sources

                    if (i < cs.length - 1 && cs[i + 1] != '/') ** GOTO lbl49
                }
                case '#': {
                    lastNonWhite = MVELConsequenceBuilder.checkAndAddSemiColon(result, brace, sqre, crly, lastNonWhite);
                    i = MVELConsequenceBuilder.processLineComment(cs, i, result);
                    break;
                }
                {
                }
                case '(': {
                    ++brace;
                    ** GOTO lbl49
                }
                case '{': {
                    ++crly;
                    ** GOTO lbl49
                }
                case '[': {
                    ++sqre;
                    ** GOTO lbl49
                }
                case ')': {
                    --brace;
                    ** GOTO lbl49
                }
                case '}': {
                    --crly;
                    ** GOTO lbl49
                }
                case ']': {
                    --sqre;
                }
lbl49:
                // 9 sources

                default: {
                    if (brace == 0 && sqre == 0 && crly == 0 && (c == '\n' || c == '\r')) {
                        if (lastNonWhite != ';') {
                            result.append(';');
                            lastNonWhite = ';';
                        }
                    } else if (!Character.isWhitespace(c)) {
                        lastNonWhite = c;
                    }
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    private static int processLineComment(char[] cs, int i, StringBuilder result) {
        while (i < cs.length) {
            result.append(cs[i]);
            if (cs[i] == '\n' || cs[i] == '\r') break;
            ++i;
        }
        return i;
    }

    private static char checkAndAddSemiColon(StringBuilder result, int brace, int sqre, int crly, char lastNonWhite) {
        if (brace == 0 && sqre == 0 && crly == 0 && lastNonWhite != ';') {
            result.append(';');
            lastNonWhite = (char)59;
        }
        return lastNonWhite;
    }
}

