/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.parser.JavaLexer;
import org.drools.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.rule.builder.dialect.java.parser.JavaParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExprAnalyzer {
    public JavaAnalysisResult analyzeExpression(String expr, Map<String, Class<?>>[] availableIdentifiers) throws RecognitionException {
        ANTLRStringStream charStream = new ANTLRStringStream(expr);
        JavaLexer lexer = new JavaLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JavaParser parser = new JavaParser((TokenStream)tokenStream);
        parser.conditionalOrExpression();
        JavaAnalysisResult result = new JavaAnalysisResult();
        result.setIdentifiers(parser.getIdentifiers());
        return this.analyze(result, availableIdentifiers);
    }

    public JavaAnalysisResult analyzeBlock(String expr, Map<String, Class<?>>[] availableIdentifiers) throws RecognitionException {
        ANTLRStringStream charStream = new ANTLRStringStream("{" + expr + "}");
        JavaLexer lexer = new JavaLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JavaParser parser = new JavaParser((TokenStream)tokenStream);
        parser.block();
        JavaAnalysisResult result = new JavaAnalysisResult();
        result.setIdentifiers(parser.getIdentifiers());
        result.setLocalVariables(new HashMap<String, JavaLocalDeclarationDescr>());
        for (JavaLocalDeclarationDescr descr : parser.getLocalDeclarations()) {
            for (JavaLocalDeclarationDescr.IdentifierDescr ident : descr.getIdentifiers()) {
                result.addLocalVariable(ident.getIdentifier(), descr);
            }
        }
        result.setBlockDescrs(parser.getBlockDescr());
        return this.analyze(result, availableIdentifiers);
    }

    private JavaAnalysisResult analyze(JavaAnalysisResult result, Map<String, Class<?>>[] availableIdentifiers) throws RecognitionException {
        List<String> identifiers = result.getIdentifiers();
        HashSet<String> notBound = new HashSet<String>(identifiers);
        List[] used = new List[availableIdentifiers.length];
        int i = 0;
        int length = used.length;
        while (i < length) {
            used[i] = new ArrayList();
            ++i;
        }
        i = 0;
        length = availableIdentifiers.length;
        while (i < length) {
            for (String eachDecl : availableIdentifiers[i].keySet()) {
                if (!identifiers.contains(eachDecl)) continue;
                used[i].add(eachDecl);
                notBound.remove(eachDecl);
            }
            ++i;
        }
        result.setBoundIdentifiers(used);
        result.setNotBoundedIdentifiers(new ArrayList<String>(notBound));
        return result;
    }
}

