/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.lang.DroolsTree;
import org.drools.lang.descr.AccessorDescr;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BehaviorDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.DeclarativeInvokerDescr;
import org.drools.lang.descr.EntryPointDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.EvaluatorBasedRestrictionDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldAccessDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionCallDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.MethodAccessDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PatternSourceDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.SlidingWindowDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.lang.descr.VariableRestrictionDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescrFactory {
    public PackageDescr createPackage(List<DroolsTree> idList) {
        PackageDescr packageDescr = new PackageDescr(this.createDotedIdFromList(idList));
        if (idList != null && idList.size() > 0) {
            packageDescr.setLocation(this.getLineLocation(idList.get(0)), this.getColumnLocation(idList.get(0)));
            packageDescr.setStartCharacter(this.getStartOffsetLocation(idList.get(0)));
            packageDescr.setEndLocation(this.getLineLocation(idList.get(0)), this.getEndOffsetLocation(idList.get(0)));
            packageDescr.setEndCharacter(this.getEndOffsetLocation(idList.get(0)));
        }
        return packageDescr;
    }

    public AttributeDescr createAttribute(DroolsTree attributeName, DroolsTree value) {
        AttributeDescr attributeDescr = new AttributeDescr(attributeName.getText());
        attributeDescr.setLocation(this.getLineLocation(attributeName), this.getColumnLocation(attributeName));
        attributeDescr.setStartCharacter(this.getStartOffsetLocation(attributeName));
        if (value != null) {
            attributeDescr.setValue(this.getCleanId(value));
            attributeDescr.setEndLocation(this.getLineLocation(value), this.getEndOffsetLocation(value));
            attributeDescr.setEndCharacter(this.getEndOffsetLocation(value));
        } else {
            attributeDescr.setEndLocation(this.getLineLocation(attributeName), this.getEndOffsetLocation(attributeName));
            attributeDescr.setEndCharacter(this.getEndOffsetLocation(attributeName));
            attributeDescr.setValue("true");
        }
        return attributeDescr;
    }

    public FunctionImportDescr createFunctionImport(DroolsTree importStart, List<DroolsTree> idList, DroolsTree dotStar) {
        return (FunctionImportDescr)this.createGenericImport(new FunctionImportDescr(), importStart, idList, dotStar);
    }

    public ImportDescr createImport(DroolsTree importStart, List<DroolsTree> idList, DroolsTree dotStar) {
        return this.createGenericImport(new ImportDescr(), importStart, idList, dotStar);
    }

    private ImportDescr createGenericImport(ImportDescr importDescr, DroolsTree importStart, List<DroolsTree> idList, DroolsTree dotStar) {
        ImportDescr genericImport = importDescr;
        genericImport.setLocation(this.getLineLocation(importStart), this.getColumnLocation(importStart));
        genericImport.setStartCharacter(this.getStartOffsetLocation(importStart));
        genericImport.setEndLocation(this.getLineLocation(idList.get(idList.size() - 1)), this.getEndOffsetLocation(idList.get(idList.size() - 1)));
        genericImport.setEndCharacter(this.getEndOffsetLocation(idList.get(idList.size() - 1)));
        StringBuilder sb = new StringBuilder();
        sb.append(this.createDotedIdFromList(idList));
        if (dotStar != null) {
            sb.append(".*");
            genericImport.setEndLocation(this.getLineLocation(dotStar), this.getEndOffsetLocation(dotStar));
            genericImport.setEndCharacter(this.getEndOffsetLocation(dotStar));
        }
        genericImport.setTarget(sb.toString());
        return genericImport;
    }

    public GlobalDescr createGlobal(DroolsTree start, BaseDescr dataType, DroolsTree globalId) {
        GlobalDescr globalDescr = new GlobalDescr();
        globalDescr.setIdentifier(globalId.getText());
        globalDescr.setType(dataType.getText());
        globalDescr.setLocation(this.getLineLocation(start), this.getColumnLocation(start));
        globalDescr.setEndLocation(this.getLineLocation(globalId), this.getEndOffsetLocation(globalId));
        globalDescr.setEndCharacter(this.getEndOffsetLocation(globalId));
        return globalDescr;
    }

    public FunctionDescr createFunction(DroolsTree start, BaseDescr dataType, DroolsTree functionId, List<Map<BaseDescr, BaseDescr>> params, DroolsTree content) {
        String type = null;
        if (dataType != null) {
            type = dataType.getText();
        }
        FunctionDescr functionDescr = new FunctionDescr(functionId.getText(), type);
        for (Map<BaseDescr, BaseDescr> map : params) {
            for (Map.Entry<BaseDescr, BaseDescr> entry : map.entrySet()) {
                functionDescr.addParameter(entry.getValue().getText(), entry.getKey().getText());
            }
        }
        functionDescr.setText(content.getText().substring(1, content.getText().length() - 1));
        functionDescr.setLocation(this.getLineLocation(start), this.getColumnLocation(start));
        functionDescr.setEndCharacter(this.getEndOffsetLocation(content));
        return functionDescr;
    }

    public FactTemplateDescr createFactTemplate(DroolsTree start, DroolsTree id, List<FieldTemplateDescr> slotList, DroolsTree end) {
        FactTemplateDescr factTemplateDescr = new FactTemplateDescr(this.getCleanId(id));
        for (FieldTemplateDescr fieldTemplateDescr : slotList) {
            factTemplateDescr.addFieldTemplate(fieldTemplateDescr);
        }
        factTemplateDescr.setLocation(this.getLineLocation(start), this.getColumnLocation(start));
        factTemplateDescr.setEndLocation(this.getLineLocation(end), this.getEndOffsetLocation(end));
        factTemplateDescr.setEndCharacter(this.getEndOffsetLocation(end));
        return factTemplateDescr;
    }

    public FieldTemplateDescr createFieldTemplate(BaseDescr dataType, DroolsTree id) {
        FieldTemplateDescr fieldTemplateDescr = new FieldTemplateDescr();
        fieldTemplateDescr.setClassType(dataType.getText());
        fieldTemplateDescr.setName(id.getText());
        fieldTemplateDescr.setLocation(dataType.getLine(), dataType.getColumn());
        fieldTemplateDescr.setEndLocation(this.getLineLocation(id), this.getEndOffsetLocation(id));
        fieldTemplateDescr.setEndCharacter(this.getEndOffsetLocation(id));
        return fieldTemplateDescr;
    }

    public QueryDescr createQuery(DroolsTree start, DroolsTree id, List<Map<BaseDescr, BaseDescr>> params, AndDescr andDescr, DroolsTree end) {
        QueryDescr queryDescr = new QueryDescr(this.getCleanId(id), "");
        if (params != null && params.size() > 0) {
            ArrayList<String> paramList = new ArrayList<String>(params.size());
            ArrayList<String> dataTypeList = new ArrayList<String>(params.size());
            for (Map<BaseDescr, BaseDescr> map : params) {
                for (Map.Entry<BaseDescr, BaseDescr> entry : map.entrySet()) {
                    paramList.add(entry.getKey().getText());
                    if (entry.getValue() == null) {
                        dataTypeList.add("Object");
                        continue;
                    }
                    dataTypeList.add(entry.getValue().getText());
                }
            }
            queryDescr.setParameters(paramList.toArray(new String[paramList.size()]));
            queryDescr.setParameterTypes(dataTypeList.toArray(new String[dataTypeList.size()]));
        }
        queryDescr.setLhs(andDescr);
        queryDescr.setLocation(this.getLineLocation(start), this.getColumnLocation(start));
        queryDescr.setEndLocation(this.getLineLocation(end), this.getEndOffsetLocation(end));
        queryDescr.setEndCharacter(this.getEndOffsetLocation(end));
        return queryDescr;
    }

    public TypeDeclarationDescr createTypeDeclr(DroolsTree id, List<Map> declMetadaList, List<TypeFieldDescr> declFieldList) {
        TypeDeclarationDescr typeDeclr = new TypeDeclarationDescr();
        typeDeclr.setTypeName(id.getText());
        for (Map activeMetadata : declMetadaList) {
            Map.Entry activeEntry = activeMetadata.entrySet().iterator().next();
            String chunkData = (DroolsTree)((Object)activeEntry.getValue()) != null ? ((DroolsTree)((Object)activeEntry.getValue())).getText() : "()";
            typeDeclr.addMetaAttribute(((DroolsTree)((Object)activeEntry.getKey())).getText(), chunkData.substring(1, chunkData.length() - 1).trim());
        }
        for (TypeFieldDescr typeFieldDescr : declFieldList) {
            typeDeclr.addField(typeFieldDescr);
        }
        return typeDeclr;
    }

    public TypeFieldDescr createTypeField(DroolsTree id, String initExpr, BaseDescr dt, List<Map> declMetadaList) {
        TypeFieldDescr field = new TypeFieldDescr(id.getText());
        if (initExpr != null) {
            field.setInitExpr(initExpr);
        }
        field.setPattern(new PatternDescr(dt.getText()));
        for (Map activeMetadata : declMetadaList) {
            Map.Entry activeEntry = activeMetadata.entrySet().iterator().next();
            String chunkData = (DroolsTree)((Object)activeEntry.getValue()) != null ? ((DroolsTree)((Object)activeEntry.getValue())).getText() : "()";
            field.addMetaAttribute(((DroolsTree)((Object)activeEntry.getKey())).getText(), chunkData.substring(1, chunkData.length() - 1));
        }
        return field;
    }

    public RuleDescr createRule(DroolsTree start, DroolsTree id, DroolsTree parentId, List<AttributeDescr> attributeList, AndDescr andDescr, DroolsTree content, List<Map> metadata) {
        RuleDescr ruleDescr = new RuleDescr(this.getCleanId(id), null);
        if (parentId != null) {
            ruleDescr.setParentName(this.getCleanId(parentId));
        }
        if (attributeList != null && attributeList.size() > 0) {
            for (AttributeDescr attributeDescr : attributeList) {
                ruleDescr.addAttribute(attributeDescr);
            }
        }
        if (metadata != null && metadata.size() > 0) {
            for (Map map : metadata) {
                for (Map.Entry entry : map.entrySet()) {
                    String chunkData = ((DroolsTree)((Object)entry.getValue())).getText();
                    ruleDescr.addMetaAttribute(((DroolsTree)((Object)entry.getKey())).getText(), chunkData.substring(1, chunkData.length() - 1).trim());
                }
            }
        }
        if (andDescr == null) {
            ruleDescr.setLhs(new AndDescr());
        } else {
            ruleDescr.setLhs(andDescr);
        }
        String buf = content.getText();
        int idx = 4;
        while (idx < buf.length() - 3 && (buf.charAt(idx) == ' ' || buf.charAt(idx) == '\t')) {
            ++idx;
        }
        if (idx < buf.length() - 3 && buf.charAt(idx) == '\r') {
            ++idx;
        }
        if (idx < buf.length() - 3 && buf.charAt(idx) == '\n') {
            ++idx;
        }
        buf = buf.substring(idx, buf.length() - 3);
        ruleDescr.setConsequence(buf);
        ruleDescr.setConsequenceLocation(this.getLineLocation(content), this.getColumnLocation(content));
        ruleDescr.setLocation(this.getLineLocation(start), this.getColumnLocation(start));
        ruleDescr.setEndCharacter(this.getEndOffsetLocation(content));
        return ruleDescr;
    }

    public BaseDescr createArgument(DroolsTree id, List<DroolsTree> rightList) {
        ArrayList<DroolsTree> idList = new ArrayList<DroolsTree>(1);
        idList.add(id);
        return this.createGenericBaseDescr(idList, rightList);
    }

    public OrDescr createOr(DroolsTree start, List<BaseDescr> lhsList) {
        OrDescr or = new OrDescr();
        or.setLocation(this.getColumnLocation(start), this.getColumnLocation(start));
        or.setStartCharacter(this.getStartOffsetLocation(start));
        or.setEndLocation(lhsList.get(lhsList.size() - 1).getEndLine(), lhsList.get(lhsList.size() - 1).getEndColumn());
        or.setEndCharacter(lhsList.get(lhsList.size() - 1).getEndCharacter());
        for (BaseDescr baseDescr : lhsList) {
            or.addDescr(baseDescr);
        }
        return or;
    }

    public AndDescr createAnd(DroolsTree start, List<BaseDescr> lhsList) {
        AndDescr and = new AndDescr();
        and.setLocation(this.getColumnLocation(start), this.getColumnLocation(start));
        and.setStartCharacter(this.getStartOffsetLocation(start));
        and.setEndLocation(lhsList.get(lhsList.size() - 1).getEndLine(), lhsList.get(lhsList.size() - 1).getEndColumn());
        and.setEndCharacter(lhsList.get(lhsList.size() - 1).getEndCharacter());
        for (BaseDescr baseDescr : lhsList) {
            and.addDescr(baseDescr);
        }
        return and;
    }

    public ExistsDescr createExists(DroolsTree start, BaseDescr baseDescr) {
        ExistsDescr exists = new ExistsDescr();
        exists.setLocation(this.getColumnLocation(start), this.getColumnLocation(start));
        exists.setStartCharacter(this.getStartOffsetLocation(start));
        exists.setEndLocation(baseDescr.getEndLine(), baseDescr.getEndColumn());
        exists.setEndCharacter(baseDescr.getEndCharacter());
        exists.addDescr(baseDescr);
        return exists;
    }

    public NotDescr createNot(DroolsTree start, BaseDescr baseDescr) {
        NotDescr not = new NotDescr();
        not.setLocation(this.getColumnLocation(start), this.getColumnLocation(start));
        not.setStartCharacter(this.getStartOffsetLocation(start));
        not.setEndLocation(baseDescr.getEndLine(), baseDescr.getEndColumn());
        not.setEndCharacter(baseDescr.getEndCharacter());
        not.addDescr(baseDescr);
        return not;
    }

    public EvalDescr createEval(DroolsTree start, DroolsTree content) {
        EvalDescr eval = new EvalDescr();
        eval.setLocation(this.getColumnLocation(start), this.getColumnLocation(start));
        eval.setStartCharacter(this.getStartOffsetLocation(start));
        eval.setEndCharacter(this.getEndOffsetLocation(content));
        eval.setContent(content.getText().substring(1, content.getText().length() - 1));
        return eval;
    }

    public ForallDescr createForAll(DroolsTree start, List<BaseDescr> lhsList) {
        ForallDescr forAll = new ForallDescr();
        forAll.setLocation(this.getColumnLocation(start), this.getColumnLocation(start));
        forAll.setStartCharacter(this.getStartOffsetLocation(start));
        forAll.setEndLocation(lhsList.get(lhsList.size() - 1).getEndLine(), lhsList.get(lhsList.size() - 1).getEndColumn());
        forAll.setEndCharacter(lhsList.get(lhsList.size() - 1).getEndCharacter());
        for (BaseDescr baseDescr : lhsList) {
            forAll.addDescr(baseDescr);
        }
        return forAll;
    }

    public PatternDescr setupFrom(BaseDescr from, PatternSourceDescr fromSource) {
        PatternDescr tempFrom = (PatternDescr)from;
        tempFrom.setSource(fromSource);
        return tempFrom;
    }

    public AccumulateDescr createAccumulate() {
        return new AccumulateDescr();
    }

    public AccumulateDescr createAccumulate(DroolsTree start, BaseDescr baseDescr) {
        AccumulateDescr accumulate = new AccumulateDescr();
        accumulate.setLocation(this.getColumnLocation(start), this.getColumnLocation(start));
        accumulate.setStartCharacter(this.getStartOffsetLocation(start));
        accumulate.setInput(baseDescr);
        return accumulate;
    }

    public CollectDescr createCollect(DroolsTree start, BaseDescr baseDescr) {
        CollectDescr collect = new CollectDescr();
        collect.setLocation(this.getColumnLocation(start), this.getColumnLocation(start));
        collect.setStartCharacter(this.getStartOffsetLocation(start));
        collect.setEndLocation(baseDescr.getEndLine(), baseDescr.getEndColumn());
        collect.setEndCharacter(baseDescr.getEndCharacter());
        collect.setInputPattern((PatternDescr)baseDescr);
        return collect;
    }

    public EntryPointDescr createEntryPoint(DroolsTree start, DroolsTree entryId) {
        EntryPointDescr entryPoint = new EntryPointDescr();
        entryPoint.setLocation(this.getColumnLocation(start), this.getColumnLocation(start));
        entryPoint.setStartCharacter(this.getStartOffsetLocation(start));
        entryPoint.setEndLocation(this.getLineLocation(entryId), this.getColumnLocation(entryId));
        entryPoint.setEndCharacter(this.getEndOffsetLocation(entryId));
        entryPoint.setEntryId(this.getCleanId(entryId));
        return entryPoint;
    }

    public AccumulateDescr setupAccumulateInit(PatternSourceDescr accumulateParam, DroolsTree start, DroolsTree initChunk, DroolsTree actionChunk, DroolsTree resultChunk, DroolsTree reverseChunk) {
        AccumulateDescr accumulate = (AccumulateDescr)accumulateParam;
        accumulate.setEndCharacter(this.getEndOffsetLocation(resultChunk));
        accumulate.setInitCode(initChunk.getText().substring(1, initChunk.getText().length() - 1));
        accumulate.setActionCode(actionChunk.getText().substring(1, actionChunk.getText().length() - 1));
        accumulate.setResultCode(resultChunk.getText().substring(1, resultChunk.getText().length() - 1));
        if (reverseChunk != null) {
            accumulate.setReverseCode(reverseChunk.getText().substring(1, reverseChunk.getText().length() - 1));
        }
        return accumulate;
    }

    public AccumulateDescr setupAccumulateId(PatternSourceDescr accumulateParam, DroolsTree id, DroolsTree expressionChunk) {
        AccumulateDescr accumulate = (AccumulateDescr)accumulateParam;
        accumulate.setEndCharacter(this.getEndOffsetLocation(expressionChunk));
        accumulate.setExternalFunction(true);
        accumulate.setFunctionIdentifier(id.getText());
        accumulate.setExpression(expressionChunk.getText().substring(1, expressionChunk.getText().length() - 1));
        return accumulate;
    }

    public AccessorDescr createAccessor(DroolsTree id, DroolsTree chunk) {
        AccessorDescr accessor = new AccessorDescr(id.getText());
        accessor.setLocation(this.getLineLocation(id), this.getColumnLocation(id));
        accessor.setStartCharacter(this.getStartOffsetLocation(id));
        accessor.setEndCharacter(this.getEndOffsetLocation(id));
        if (chunk != null) {
            accessor.setVariableName(null);
            FunctionCallDescr functionCall = new FunctionCallDescr(id.getText());
            functionCall.setLocation(this.getLineLocation(id), this.getColumnLocation(id));
            functionCall.setStartCharacter(this.getStartOffsetLocation(id));
            functionCall.setEndCharacter(this.getEndOffsetLocation(chunk));
            functionCall.setArguments(chunk.getText());
            accessor.addInvoker(functionCall);
        }
        return accessor;
    }

    public AccessorDescr setupAccessorOffset(AccessorDescr accessorDescr) {
        if (accessorDescr.getInvokers() != null && accessorDescr.getInvokers().size() > 0) {
            BaseDescr desc = (BaseDescr)accessorDescr.getInvokers().get(accessorDescr.getInvokers().size() - 1);
            accessorDescr.setEndCharacter(desc.getEndCharacter());
        }
        return accessorDescr;
    }

    public DeclarativeInvokerDescr createExpressionChain(DroolsTree start, DroolsTree id, DroolsTree squareChunk, DroolsTree parenChunk) {
        DeclarativeInvokerDescr declarativeInvoker = null;
        if (parenChunk == null) {
            FieldAccessDescr field = new FieldAccessDescr(id.getText());
            field.setLocation(this.getLineLocation(id), this.getColumnLocation(id));
            field.setStartCharacter(this.getStartOffsetLocation(id));
            field.setEndCharacter(this.getEndOffsetLocation(id));
            if (squareChunk != null) {
                field.setArgument(squareChunk.getText());
                field.setEndCharacter(this.getEndOffsetLocation(squareChunk));
            }
            declarativeInvoker = field;
        } else {
            MethodAccessDescr method = new MethodAccessDescr(id.getText(), parenChunk.getText());
            method.setLocation(this.getLineLocation(id), this.getColumnLocation(id));
            method.setStartCharacter(this.getStartOffsetLocation(id));
            method.setEndCharacter(this.getEndOffsetLocation(parenChunk));
            declarativeInvoker = method;
        }
        return declarativeInvoker;
    }

    public BaseDescr setupBehavior(BaseDescr descr, List<BehaviorDescr> behaviorList) {
        if (behaviorList != null && descr instanceof PatternDescr) {
            for (BehaviorDescr activeBehavior : behaviorList) {
                ((PatternDescr)descr).addBehavior(activeBehavior);
            }
        }
        return descr;
    }

    public BehaviorDescr createBehavior(DroolsTree type, DroolsTree param) {
        return new SlidingWindowDescr(type.getText(), param.getText().substring(1, param.getText().length() - 1));
    }

    public FromDescr createFromSource(AccessorDescr accessor) {
        FromDescr from = new FromDescr();
        from.setDataSource(accessor);
        from.setEndCharacter(accessor.getEndCharacter());
        return from;
    }

    public PatternDescr createPattern(BaseDescr dataType, List<BaseDescr> exprList) {
        PatternDescr pattern = new PatternDescr();
        pattern.setLocation(dataType.getEndLine(), dataType.getEndColumn());
        pattern.setEndLocation(dataType.getEndLine(), dataType.getEndColumn());
        pattern.setEndCharacter(dataType.getEndCharacter());
        pattern.setObjectType(dataType.getText());
        if (exprList != null && exprList.size() > 0) {
            if (exprList.size() == 1) {
                pattern.getConstraint().addOrMerge(exprList.get(0));
            } else {
                for (BaseDescr constraint : exprList) {
                    pattern.getConstraint().addDescr(constraint);
                }
            }
            pattern.setEndCharacter(exprList.get(exprList.size() - 1).getEndCharacter());
        }
        return pattern;
    }

    public BaseDescr setupPatternBiding(DroolsTree label, BaseDescr fact) {
        fact.setStartCharacter(this.getStartOffsetLocation(label));
        if (fact instanceof OrDescr) {
            OrDescr or = (OrDescr)fact;
            for (Object descr : or.getDescrs()) {
                this.setupPatternBiding(label, (BaseDescr)descr);
            }
        } else if (fact instanceof PatternDescr) {
            ((PatternDescr)fact).setIdentifier(label.getText());
        } else {
            throw new RuntimeDroolsException("This is a bug. Please contact the Development Team. Only Patterns or OrDescr may have attached bindings. Found: " + fact.getClass().getName());
        }
        return fact;
    }

    public OrDescr createFactOr(DroolsTree start, BaseDescr left, BaseDescr right) {
        OrDescr or = new OrDescr();
        or.addDescr(left);
        or.addDescr(right);
        return or;
    }

    public FieldConstraintDescr setupFieldConstraint(FieldConstraintDescr field, BaseDescr descr) {
        if (descr != null && descr instanceof RestrictionDescr) {
            field.getRestriction().addOrMerge((RestrictionDescr)descr);
        }
        return field;
    }

    public FieldBindingDescr createFieldBinding(DroolsTree label, BaseDescr descr) {
        FieldBindingDescr fieldBiding = new FieldBindingDescr();
        fieldBiding.setLocation(this.getLineLocation(label), this.getColumnLocation(label));
        fieldBiding.setStartCharacter(this.getStartOffsetLocation(label));
        FieldConstraintDescr fieldConstraint = (FieldConstraintDescr)descr;
        fieldBiding.setIdentifier(label.getText());
        fieldBiding.setFieldName(fieldConstraint.getFieldName());
        if (!fieldConstraint.getRestrictions().isEmpty()) {
            fieldBiding.setFieldConstraint(fieldConstraint);
        }
        return fieldBiding;
    }

    public PredicateDescr createPredicate(DroolsTree pc) {
        PredicateDescr predicate = new PredicateDescr();
        predicate.setContent(pc.getText().subSequence(1, pc.getText().length() - 1));
        predicate.setEndCharacter(this.getEndOffsetLocation(pc));
        return predicate;
    }

    public BaseDescr setupRestriction(DroolsTree operator, DroolsTree not, BaseDescr descr) {
        if (descr instanceof EvaluatorBasedRestrictionDescr) {
            EvaluatorBasedRestrictionDescr evaluator = (EvaluatorBasedRestrictionDescr)descr;
            evaluator.setEvaluator(operator.getText());
            if (not == null) {
                evaluator.setNegated(false);
            } else {
                evaluator.setNegated(true);
            }
        }
        return descr;
    }

    public BaseDescr setupRestriction(DroolsTree operator, DroolsTree not, BaseDescr descr, DroolsTree param) {
        BaseDescr retDescr = this.setupRestriction(operator, not, descr);
        if (param != null && descr instanceof EvaluatorBasedRestrictionDescr) {
            EvaluatorBasedRestrictionDescr evaluator = (EvaluatorBasedRestrictionDescr)descr;
            evaluator.setParameterText(param.getText().substring(1, param.getText().length() - 1));
        }
        return retDescr;
    }

    public RestrictionConnectiveDescr createRestrictionConnective(DroolsTree not, List<BaseDescr> exprList) {
        RestrictionConnectiveDescr group;
        String op = null;
        if (not == null) {
            op = "==";
            group = new RestrictionConnectiveDescr(RestrictionConnectiveDescr.OR);
        } else {
            op = "!=";
            group = new RestrictionConnectiveDescr(RestrictionConnectiveDescr.AND);
        }
        for (BaseDescr baseDescr : exprList) {
            if (!(baseDescr instanceof EvaluatorBasedRestrictionDescr)) continue;
            EvaluatorBasedRestrictionDescr evaluator = (EvaluatorBasedRestrictionDescr)baseDescr;
            evaluator.setEvaluator(op);
            evaluator.setNegated(false);
            group.addRestriction(evaluator);
        }
        return group;
    }

    public BaseDescr createOrRestrictionConnective(BaseDescr left, BaseDescr right) {
        BaseDescr or = null;
        if (left instanceof RestrictionDescr && !(left instanceof PredicateDescr)) {
            RestrictionConnectiveDescr restOr = new RestrictionConnectiveDescr(RestrictionConnectiveDescr.OR);
            restOr.addOrMerge((RestrictionDescr)left);
            restOr.addOrMerge((RestrictionDescr)right);
            or = restOr;
        } else {
            OrDescr consOr = new OrDescr();
            consOr.addOrMerge(left);
            consOr.addOrMerge(right);
            or = consOr;
        }
        return or;
    }

    public BaseDescr createAndRestrictionConnective(BaseDescr left, BaseDescr right) {
        BaseDescr and = null;
        if (left instanceof RestrictionDescr && !(left instanceof PredicateDescr)) {
            RestrictionConnectiveDescr restAnd = new RestrictionConnectiveDescr(RestrictionConnectiveDescr.AND);
            restAnd.addOrMerge((RestrictionDescr)left);
            restAnd.addOrMerge((RestrictionDescr)right);
            and = restAnd;
        } else {
            AndDescr consAnd = new AndDescr();
            consAnd.addOrMerge(left);
            consAnd.addOrMerge(right);
            and = consAnd;
        }
        return and;
    }

    public BaseDescr createAccessorPath(List<BaseDescr> aeList) {
        String name;
        StringBuilder sb = new StringBuilder();
        sb.append(aeList.get(0).getText());
        if (aeList.size() > 1) {
            int i = 1;
            while (i < aeList.size()) {
                sb.append(".");
                sb.append(aeList.get(i).getText());
                ++i;
            }
        }
        EvaluatorBasedRestrictionDescr evaluator = (name = sb.toString()).indexOf(46) > -1 || name.indexOf(91) > -1 ? new QualifiedIdentifierRestrictionDescr() : new VariableRestrictionDescr();
        evaluator.setText(name);
        return evaluator;
    }

    public LiteralRestrictionDescr createStringLiteralRestriction(DroolsTree s) {
        LiteralRestrictionDescr stringLit = new LiteralRestrictionDescr();
        stringLit.setType(3);
        stringLit.setText(s.getText().substring(1, s.getText().length() - 1));
        return stringLit;
    }

    public LiteralRestrictionDescr createIntLiteralRestriction(DroolsTree i) {
        LiteralRestrictionDescr intLit = new LiteralRestrictionDescr();
        intLit.setType(2);
        intLit.setText(i.getText());
        return intLit;
    }

    public LiteralRestrictionDescr createFloatLiteralRestriction(DroolsTree f) {
        LiteralRestrictionDescr floatLit = new LiteralRestrictionDescr();
        floatLit.setType(2);
        floatLit.setText(f.getText());
        return floatLit;
    }

    public LiteralRestrictionDescr createBoolLiteralRestriction(DroolsTree b) {
        LiteralRestrictionDescr boolLit = new LiteralRestrictionDescr();
        boolLit.setType(4);
        boolLit.setText(b.getText());
        return boolLit;
    }

    public LiteralRestrictionDescr createNullLiteralRestriction(DroolsTree n) {
        LiteralRestrictionDescr nullLit = new LiteralRestrictionDescr();
        nullLit.setType(1);
        nullLit.setText(null);
        return nullLit;
    }

    public ReturnValueRestrictionDescr createReturnValue(DroolsTree pc) {
        ReturnValueRestrictionDescr returnValue = new ReturnValueRestrictionDescr();
        returnValue.setContent(pc.getText().substring(1, pc.getText().length() - 1));
        returnValue.setLocation(this.getLineLocation(pc), this.getColumnLocation(pc));
        returnValue.setStartCharacter(this.getStartOffsetLocation(pc));
        returnValue.setEndCharacter(this.getEndOffsetLocation(pc));
        return returnValue;
    }

    public FieldConstraintDescr createFieldConstraint(List<BaseDescr> aeList) {
        StringBuilder sb = new StringBuilder();
        sb.append(aeList.get(0).getText());
        if (aeList.size() > 1) {
            int i = 1;
            while (i < aeList.size()) {
                sb.append(".");
                sb.append(aeList.get(i).getText());
                ++i;
            }
        }
        FieldConstraintDescr fieldConstraint = new FieldConstraintDescr(sb.toString());
        fieldConstraint.setLocation(aeList.get(0).getLine(), aeList.get(0).getColumn());
        fieldConstraint.setStartCharacter(aeList.get(0).getStartCharacter());
        fieldConstraint.setEndCharacter(aeList.get(aeList.size() - 1).getEndCharacter());
        return fieldConstraint;
    }

    public BaseDescr createAccessorElement(DroolsTree id, List<DroolsTree> squareChunk) {
        BaseDescr element = new BaseDescr();
        element.setLocation(this.getLineLocation(id), this.getColumnLocation(id));
        element.setStartCharacter(this.getStartOffsetLocation(id));
        element.setEndCharacter(this.getEndOffsetLocation(id));
        StringBuilder sb = new StringBuilder();
        sb.append(id.getText());
        if (squareChunk != null && squareChunk.size() > 0) {
            for (DroolsTree chunk : squareChunk) {
                sb.append(chunk.getText());
            }
            element.setEndCharacter(this.getEndOffsetLocation(squareChunk.get(squareChunk.size() - 1)));
        }
        element.setText(sb.toString());
        return element;
    }

    public BaseDescr createDataType(List<DroolsTree> idList, List<DroolsTree> rightList) {
        return this.createGenericBaseDescr(idList, rightList);
    }

    private BaseDescr createGenericBaseDescr(List<DroolsTree> idList, List<DroolsTree> rightList) {
        int endLine = this.getLineLocation(idList.get(idList.size() - 1));
        int endColumn = this.getEndOffsetLocation(idList.get(idList.size() - 1));
        int endChar = this.getEndOffsetLocation(idList.get(idList.size() - 1));
        StringBuilder text = new StringBuilder();
        text.append(this.createDotedIdFromList(idList));
        if (rightList != null && rightList.size() > 0) {
            int i = 0;
            while (i < rightList.size()) {
                text.append("[]");
                ++i;
            }
            endLine = this.getLineLocation(rightList.get(idList.size() - 1));
            endColumn = this.getEndOffsetLocation(rightList.get(idList.size() - 1));
            endChar = this.getEndOffsetLocation(rightList.get(idList.size() - 1));
        }
        BaseDescr baseDescr = new BaseDescr();
        baseDescr.setText(text.toString());
        baseDescr.setLocation(this.getLineLocation(idList.get(0)), this.getColumnLocation(idList.get(0)));
        baseDescr.setEndLocation(endLine, endColumn);
        baseDescr.setEndCharacter(endChar);
        return baseDescr;
    }

    private String createDotedIdFromList(List<DroolsTree> idList) {
        StringBuilder sb = new StringBuilder();
        if (idList != null && idList.size() > 0) {
            for (DroolsTree commonTree : idList) {
                sb.append(commonTree.getText());
                sb.append(".");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String getCleanId(DroolsTree id) {
        String cleanedId = id.getText();
        if (cleanedId.startsWith("\"") || cleanedId.startsWith("'")) {
            cleanedId = cleanedId.substring(1, cleanedId.length() - 1).trim();
        }
        return cleanedId;
    }

    private int getLineLocation(DroolsTree tree) {
        return tree.getLine();
    }

    private int getColumnLocation(DroolsTree tree) {
        return tree.getCharPositionInLine();
    }

    private int getStartOffsetLocation(DroolsTree tree) {
        return tree.getStartCharOffset();
    }

    private int getEndOffsetLocation(DroolsTree tree) {
        return tree.getEndCharOffset();
    }
}

