/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.rules;

import java.util.HashSet;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FunctionHandler
extends BaseAbstractHandler
implements Handler {
    public FunctionHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(PackageDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(FunctionDescr.class);
            this.validPeers.add(RuleDescr.class);
            this.validPeers.add(QueryDescr.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String name = attrs.getValue("name");
        String returnType = attrs.getValue("return-type");
        this.emptyAttributeCheck(localName, "name", name, parser);
        this.emptyAttributeCheck(localName, "return-type", returnType, parser);
        FunctionDescr functionDescr = new FunctionDescr(name, returnType);
        return functionDescr;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        FunctionDescr functionDescr = (FunctionDescr)parser.getCurrent();
        NodeList parameters = element.getElementsByTagName("parameter");
        int i = 0;
        int length = parameters.getLength();
        while (i < length) {
            String identifier = ((Element)parameters.item(i)).getAttribute("identifier");
            String type = ((Element)parameters.item(i)).getAttribute("type");
            this.emptyAttributeCheck("parameter", "identifier", identifier, parser);
            this.emptyAttributeCheck("parameter", "type", type, parser);
            functionDescr.addParameter(type, identifier);
            ++i;
        }
        NodeList list = element.getElementsByTagName("body");
        if (list.getLength() == 0) {
            throw new SAXParseException("function must have a <body>", parser.getLocator());
        }
        functionDescr.setText(((Text)list.item(0).getChildNodes().item(0)).getWholeText());
        PackageDescr packageDescr = (PackageDescr)parser.getData();
        packageDescr.addFunction(functionDescr);
        return functionDescr;
    }

    public Class generateNodeFor() {
        return FunctionDescr.class;
    }
}

