/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.processes;

import java.util.Map;
import org.drools.compiler.xml.processes.AbstractNodeHandler;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.impl.ExtendedNodeImpl;
import org.drools.workflow.core.node.SubProcessNode;
import org.drools.xml.ExtensibleXmlParser;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SubProcessNodeHandler
extends AbstractNodeHandler {
    protected Node createNode() {
        return new SubProcessNode();
    }

    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String waitForCompletion;
        super.handleNode(node, element, uri, localName, parser);
        SubProcessNode subProcessNode = (SubProcessNode)node;
        String processId = element.getAttribute("processId");
        if (processId != null && processId.length() > 0) {
            subProcessNode.setProcessId(processId);
        }
        subProcessNode.setWaitForCompletion(!"false".equals(waitForCompletion = element.getAttribute("waitForCompletion")));
        String independent = element.getAttribute("independent");
        subProcessNode.setIndependent(!"false".equals(independent));
        String[] stringArray = subProcessNode.getActionTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String eventType = stringArray[n2];
            this.handleAction((ExtendedNodeImpl)subProcessNode, element, eventType);
            ++n2;
        }
    }

    public Class generateNodeFor() {
        return SubProcessNode.class;
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        SubProcessNode subProcessNode = (SubProcessNode)node;
        this.writeNode("subProcess", (Node)subProcessNode, xmlDump, includeMeta);
        String processId = subProcessNode.getProcessId();
        if (processId != null) {
            xmlDump.append("processId=\"" + processId + "\" ");
        }
        if (!subProcessNode.isWaitForCompletion()) {
            xmlDump.append("waitForCompletion=\"false\" ");
        }
        if (!subProcessNode.isIndependent()) {
            xmlDump.append("independent=\"false\" ");
        }
        xmlDump.append(">" + EOL);
        Map inMappings = subProcessNode.getInMappings();
        for (Map.Entry inMapping : inMappings.entrySet()) {
            xmlDump.append("      <mapping type=\"in\" from=\"" + (String)inMapping.getValue() + "\" " + "to=\"" + (String)inMapping.getKey() + "\" />" + EOL);
        }
        Map outMappings = subProcessNode.getOutMappings();
        for (Map.Entry outMapping : outMappings.entrySet()) {
            xmlDump.append("      <mapping type=\"out\" from=\"" + (String)outMapping.getKey() + "\" " + "to=\"" + (String)outMapping.getValue() + "\" />" + EOL);
        }
        String[] stringArray = subProcessNode.getActionTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String eventType = stringArray[n2];
            this.writeActions(eventType, subProcessNode.getActions(eventType), xmlDump);
            ++n2;
        }
        this.writeTimers(subProcessNode.getTimers(), xmlDump);
        this.endNode("subProcess", xmlDump);
    }
}

