/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.processes;

import org.drools.compiler.xml.XmlDumper;
import org.drools.compiler.xml.processes.AbstractNodeHandler;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.impl.ExtendedNodeImpl;
import org.drools.workflow.core.node.MilestoneNode;
import org.drools.xml.ExtensibleXmlParser;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MilestoneNodeHandler
extends AbstractNodeHandler {
    protected Node createNode() {
        return new MilestoneNode();
    }

    public Class generateNodeFor() {
        return MilestoneNode.class;
    }

    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        MilestoneNode milestoneNode = (MilestoneNode)node;
        String[] stringArray = milestoneNode.getActionTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String eventType = stringArray[n2];
            this.handleAction((ExtendedNodeImpl)milestoneNode, element, eventType);
            ++n2;
        }
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        MilestoneNode milestoneNode = (MilestoneNode)node;
        this.writeNode("milestone", (Node)milestoneNode, xmlDump, includeMeta);
        String constraint = milestoneNode.getConstraint();
        if (constraint != null || milestoneNode.getTimers() != null || milestoneNode.containsActions()) {
            xmlDump.append(">\n");
            if (constraint != null) {
                xmlDump.append("      <constraint type=\"rule\" dialect=\"mvel\" >" + XmlDumper.replaceIllegalChars(constraint.trim()) + "</constraint>" + EOL);
            }
            String[] stringArray = milestoneNode.getActionTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String eventType = stringArray[n2];
                this.writeActions(eventType, milestoneNode.getActions(eventType), xmlDump);
                ++n2;
            }
            this.writeTimers(milestoneNode.getTimers(), xmlDump);
            this.endNode("milestone", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

