/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.field.ObjectFieldImpl;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.core.util.StringUtils;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FactTemplateFieldExtractor;
import org.drools.facttemplates.FactTemplateObjectType;
import org.drools.lang.MVELDumper;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BehaviorDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.SlidingWindowDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.rule.AbstractCompositeConstraint;
import org.drools.rule.AbstractCompositeRestriction;
import org.drools.rule.AndCompositeRestriction;
import org.drools.rule.AndConstraint;
import org.drools.rule.Behavior;
import org.drools.rule.Declaration;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.LiteralRestriction;
import org.drools.rule.MultiRestrictionFieldConstraint;
import org.drools.rule.MutableTypeConstraint;
import org.drools.rule.OrCompositeRestriction;
import org.drools.rule.OrConstraint;
import org.drools.rule.Pattern;
import org.drools.rule.PatternSource;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.Query;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.SlidingLengthWindow;
import org.drools.rule.SlidingTimeWindow;
import org.drools.rule.UnificationRestriction;
import org.drools.rule.VariableConstraint;
import org.drools.rule.VariableRestriction;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.QueryElementBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.AcceptsClassObjectType;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.spi.PatternExtractor;
import org.drools.spi.Restriction;
import org.drools.type.DateFormats;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBuilder
implements RuleConditionBuilder {
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        Pattern pattern;
        PatternDescr patternDescr = (PatternDescr)descr;
        if (patternDescr.getObjectType() == null || patternDescr.getObjectType().equals("")) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "ObjectType not correctly defined"));
            return null;
        }
        FactTemplateObjectType objectType = null;
        FactTemplate factTemplate = context.getPkg().getFactTemplate(patternDescr.getObjectType());
        if (factTemplate != null) {
            objectType = new FactTemplateObjectType(factTemplate);
        } else {
            try {
                Class userProvidedClass = context.getDialect().getTypeResolver().resolveType(patternDescr.getObjectType());
                boolean isEvent = context.getPkg().isEvent(userProvidedClass);
                objectType = new ClassObjectType(userProvidedClass, isEvent);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (objectType == null) {
            Rule rule = context.getPkg().getRule(patternDescr.getObjectType());
            if (rule != null && rule instanceof Query) {
                QueryElementBuilder qeBuilder = new QueryElementBuilder();
                return qeBuilder.build(context, descr, prefixPattern);
            }
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unable to resolve ObjectType '" + patternDescr.getObjectType() + "'"));
            return null;
        }
        if (patternDescr.getIdentifier() != null && !patternDescr.getIdentifier().equals("")) {
            if (context.getDeclarationResolver().isDuplicated(context.getRule(), patternDescr.getIdentifier())) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Duplicate declaration for variable '" + patternDescr.getIdentifier() + "' in the rule '" + context.getRule().getName() + "'"));
            }
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, patternDescr.getIdentifier(), patternDescr.isInternalFact());
            if (objectType instanceof ClassObjectType) {
                context.getPkg().getClassFieldAccessorStore().getClassObjectType((ClassObjectType)objectType, (AcceptsClassObjectType)((PatternExtractor)pattern.getDeclaration().getExtractor()));
            }
        } else {
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, null);
        }
        if (objectType instanceof ClassObjectType) {
            context.getPkg().getClassFieldAccessorStore().getClassObjectType((ClassObjectType)objectType, (AcceptsClassObjectType)pattern);
        }
        context.getBuildStack().push((RuleConditionElement)pattern);
        for (BaseDescr baseDescr : patternDescr.getDescrs()) {
            this.buildConstraint(context, pattern, baseDescr, null);
        }
        if (patternDescr.getSource() != null) {
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(patternDescr.getSource().getClass());
            PatternSource patternSource = (PatternSource)builder.build(context, patternDescr.getSource());
            pattern.setSource(patternSource);
        }
        for (BehaviorDescr behaviorDescr : patternDescr.getBehaviors()) {
            if (pattern.getObjectType().isEvent()) {
                SlidingTimeWindow window;
                SlidingWindowDescr swd;
                if (Behavior.BehaviorType.TIME_WINDOW.matches(behaviorDescr.getType())) {
                    swd = (SlidingWindowDescr)behaviorDescr;
                    window = new SlidingTimeWindow(swd.getLength());
                    pattern.addBehavior((Behavior)window);
                    continue;
                }
                if (!Behavior.BehaviorType.LENGTH_WINDOW.matches(behaviorDescr.getType())) continue;
                swd = (SlidingWindowDescr)behaviorDescr;
                window = new SlidingLengthWindow((int)swd.getLength());
                pattern.addBehavior((Behavior)window);
                continue;
            }
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "A Sliding Window behavior can only be assigned to patterns declared with @role( event ). The pattern '" + pattern.getObjectType() + "' in the rule '" + context.getRule().getName() + "' is not declared as an Event."));
        }
        context.getBuildStack().pop();
        return pattern;
    }

    private void buildConstraint(RuleBuildContext context, Pattern pattern, Object constraint, AbstractCompositeConstraint container) {
        if (constraint instanceof FieldBindingDescr) {
            this.build(context, pattern, (FieldBindingDescr)constraint);
        } else if (constraint instanceof FieldConstraintDescr) {
            this.build(context, pattern, (FieldConstraintDescr)constraint, container);
        } else if (constraint instanceof PredicateDescr) {
            this.build(context, pattern, (PredicateDescr)constraint, container);
        } else if (constraint instanceof AndDescr) {
            AndConstraint and = new AndConstraint();
            Iterator it = ((AndDescr)constraint).getDescrs().iterator();
            while (it.hasNext()) {
                this.buildConstraint(context, pattern, it.next(), (AbstractCompositeConstraint)and);
            }
            if (container == null) {
                pattern.addConstraint((Constraint)and);
            } else {
                if (and.getType().equals((Object)Constraint.ConstraintType.UNKNOWN)) {
                    this.setConstraintType(pattern, (MutableTypeConstraint)and);
                }
                container.addConstraint((Constraint)and);
            }
        } else if (constraint instanceof OrDescr) {
            OrConstraint or = new OrConstraint();
            Iterator it = ((OrDescr)constraint).getDescrs().iterator();
            while (it.hasNext()) {
                this.buildConstraint(context, pattern, it.next(), (AbstractCompositeConstraint)or);
            }
            if (container == null) {
                pattern.addConstraint((Constraint)or);
            } else {
                if (or.getType().equals((Object)Constraint.ConstraintType.UNKNOWN)) {
                    this.setConstraintType(pattern, (MutableTypeConstraint)or);
                }
                container.addConstraint((Constraint)or);
            }
        } else {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), (BaseDescr)constraint, null, "This is a bug: unable to build constraint descriptor: '" + constraint + "' in rule '" + context.getRule().getName() + "'"));
        }
    }

    private void build(RuleBuildContext context, Pattern pattern, FieldConstraintDescr fieldConstraintDescr, AbstractCompositeConstraint container) {
        InternalReadAccessor extractor;
        String fieldName = fieldConstraintDescr.getFieldName();
        if (fieldName.indexOf(91) > -1) {
            this.rewriteToEval(context, pattern, fieldConstraintDescr, container);
            return;
        }
        if (fieldName.indexOf(46) > -1) {
            String[] identifiers = fieldName.split("\\.");
            if (identifiers.length == 2 && (pattern.getDeclaration() != null && identifiers[0].equals(pattern.getDeclaration().getIdentifier()) || "this".equals(identifiers[0]))) {
                fieldName = identifiers[1];
            } else {
                this.rewriteToEval(context, pattern, fieldConstraintDescr, container);
                return;
            }
        }
        if ((extractor = PatternBuilder.getFieldReadAccessor(context, fieldConstraintDescr, pattern.getObjectType(), fieldName, null, false)) == null) {
            if (fieldConstraintDescr.getFieldName().startsWith("this.")) {
                this.rewriteToEval(context, pattern, fieldConstraintDescr, container);
                return;
            }
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), fieldConstraintDescr, null, "Unable to create Field Extractor for '" + fieldName + "' of '" + pattern.getObjectType().toString() + "' in rule '" + context.getRule().getName() + "'"));
            return;
        }
        Restriction restriction = this.createRestriction(context, pattern, fieldConstraintDescr, fieldConstraintDescr.getRestriction(), extractor);
        if (restriction == null) {
            return;
        }
        MultiRestrictionFieldConstraint constraint = null;
        if (restriction instanceof AbstractCompositeRestriction) {
            constraint = new MultiRestrictionFieldConstraint(extractor, restriction);
        } else if (restriction instanceof LiteralRestriction) {
            constraint = new LiteralConstraint(extractor, (LiteralRestriction)restriction);
            PatternBuilder.registerReadAccessor(context, pattern.getObjectType(), fieldName, (AcceptsReadAccessor)((LiteralConstraint)constraint));
            PatternBuilder.registerReadAccessor(context, pattern.getObjectType(), fieldName, (AcceptsReadAccessor)((LiteralRestriction)restriction));
        } else if (restriction instanceof VariableRestriction || restriction instanceof UnificationRestriction) {
            constraint = new VariableConstraint(extractor, restriction);
            PatternBuilder.registerReadAccessor(context, pattern.getObjectType(), fieldName, (AcceptsReadAccessor)restriction);
            PatternBuilder.registerReadAccessor(context, pattern.getObjectType(), fieldName, (AcceptsReadAccessor)restriction);
        } else if (restriction instanceof ReturnValueRestriction) {
            constraint = new ReturnValueConstraint(extractor, (ReturnValueRestriction)restriction);
            PatternBuilder.registerReadAccessor(context, pattern.getObjectType(), fieldName, (AcceptsReadAccessor)((ReturnValueConstraint)constraint));
            PatternBuilder.registerReadAccessor(context, pattern.getObjectType(), fieldName, (AcceptsReadAccessor)((ReturnValueRestriction)restriction));
        } else {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), fieldConstraintDescr, null, "This is a bug: Unkown restriction type '" + restriction.getClass() + "' for pattern '" + pattern.getObjectType().toString() + "' in rule '" + context.getRule().getName() + "'"));
        }
        if (container == null) {
            pattern.addConstraint((Constraint)constraint);
        } else {
            if (constraint.getType().equals((Object)Constraint.ConstraintType.UNKNOWN)) {
                this.setConstraintType(pattern, (MutableTypeConstraint)constraint);
            }
            container.addConstraint((Constraint)constraint);
        }
    }

    private void setConstraintType(Pattern container, MutableTypeConstraint constraint) {
        Declaration[] declarations = constraint.getRequiredDeclarations();
        boolean isAlphaConstraint = true;
        for (int i = 0; isAlphaConstraint && i < declarations.length; ++i) {
            if (declarations[i].isGlobal() || declarations[i].getPattern() == container) continue;
            isAlphaConstraint = false;
        }
        Constraint.ConstraintType type = isAlphaConstraint ? Constraint.ConstraintType.ALPHA : Constraint.ConstraintType.BETA;
        constraint.setType(type);
    }

    private void rewriteToEval(RuleBuildContext context, Pattern pattern, FieldConstraintDescr fieldConstraintDescr, AbstractCompositeConstraint container) {
        Dialect dialect = context.getDialect();
        MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
        boolean strictMode = mvelDialect.isStrictMode();
        mvelDialect.setStrictMode(false);
        context.setDialect(mvelDialect);
        Class resultType = this.getFieldReturnType(pattern, fieldConstraintDescr);
        PredicateDescr predicateDescr = new PredicateDescr();
        MVELDumper dumper = new MVELDumper();
        predicateDescr.setContent(dumper.dump(fieldConstraintDescr, Date.class.isAssignableFrom(resultType)));
        this.build(context, pattern, predicateDescr, container);
        mvelDialect.setStrictMode(strictMode);
        context.setDialect(dialect);
    }

    private Class getFieldReturnType(Pattern pattern, FieldConstraintDescr fieldConstraintDescr) {
        String dummyField = "__DUMMY__";
        String dummyExpr = dummyField + "." + fieldConstraintDescr.getFieldName();
        ExpressionCompiler compiler = new ExpressionCompiler(dummyExpr);
        ParserContext mvelcontext = new ParserContext();
        mvelcontext.addInput(dummyField, ((ClassObjectType)pattern.getObjectType()).getClassType());
        compiler.compile(mvelcontext);
        Class resultType = compiler.getReturnType();
        return resultType;
    }

    private Restriction createRestriction(RuleBuildContext context, Pattern pattern, FieldConstraintDescr fieldConstraintDescr, RestrictionConnectiveDescr top, InternalReadAccessor extractor) {
        Restriction[] restrictions = new Restriction[top.getRestrictions().size()];
        int index = 0;
        for (RestrictionDescr restrictionDescr : top.getRestrictions()) {
            if (restrictionDescr instanceof RestrictionConnectiveDescr) {
                restrictions[index++] = this.createRestriction(context, pattern, fieldConstraintDescr, (RestrictionConnectiveDescr)restrictionDescr, extractor);
                continue;
            }
            restrictions[index] = this.buildRestriction(context, pattern, extractor, fieldConstraintDescr, restrictionDescr);
            if (restrictions[index] == null) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), fieldConstraintDescr, null, "Unable to create restriction '" + restrictionDescr.toString() + "' for field '" + fieldConstraintDescr.getFieldName() + "' in the rule '" + context.getRule().getName() + "'"));
            }
            ++index;
        }
        if (restrictions.length > 1) {
            AndCompositeRestriction composite = null;
            if (top.getConnective() == RestrictionConnectiveDescr.AND) {
                composite = new AndCompositeRestriction(restrictions);
            } else if (top.getConnective() == RestrictionConnectiveDescr.OR) {
                composite = new OrCompositeRestriction(restrictions);
            } else {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), fieldConstraintDescr, null, "This is a bug: Impossible to create a composite restriction for connective: " + (Object)((Object)top.getConnective()) + "' for field '" + fieldConstraintDescr.getFieldName() + "' in the rule '" + context.getRule().getName() + "'"));
            }
            return composite;
        }
        if (restrictions.length == 1) {
            return restrictions[0];
        }
        context.getErrors().add(new DescrBuildError(context.getParentDescr(), fieldConstraintDescr, null, "This is a bug: trying to create a restriction for an empty restriction list for field '" + fieldConstraintDescr.getFieldName() + "' in the rule '" + context.getRule().getName() + "'"));
        return null;
    }

    private void build(RuleBuildContext context, Pattern pattern, FieldBindingDescr fieldBindingDescr) {
        if (context.getDeclarationResolver().isDuplicated(context.getRule(), fieldBindingDescr.getIdentifier())) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), fieldBindingDescr, null, "Duplicate declaration for variable '" + fieldBindingDescr.getIdentifier() + "' in the rule '" + context.getRule().getName() + "'"));
            return;
        }
        Declaration declr = pattern.addDeclaration(fieldBindingDescr.getIdentifier());
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, fieldBindingDescr, pattern.getObjectType(), fieldBindingDescr.getFieldName(), (AcceptsReadAccessor)declr, true);
    }

    private void build(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, AbstractCompositeConstraint container) {
        Map<String, Class<?>> declarations = this.getDeclarationsMap(predicateDescr, context);
        Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
        Dialect.AnalysisResult analysis = context.getDialect().analyzeExpression(context, predicateDescr, predicateDescr.getContent(), new Map[]{declarations, globals});
        if (analysis == null) {
            return;
        }
        List[] usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        int size = usedIdentifiers[0].size();
        for (int i = 0; i < size; ++i) {
            Declaration decl = context.getDeclarationResolver().getDeclaration(context.getRule(), usedIdentifiers[0].get(i));
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        this.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), factDeclarations);
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        String[] requiredGlobals = usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]);
        PredicateConstraint predicateConstraint = new PredicateConstraint(null, previousDeclarations, localDeclarations, requiredGlobals);
        if (container == null) {
            pattern.addConstraint((Constraint)predicateConstraint);
        } else {
            if (predicateConstraint.getType().equals((Object)Constraint.ConstraintType.UNKNOWN)) {
                this.setConstraintType(pattern, (MutableTypeConstraint)predicateConstraint);
            }
            container.addConstraint((Constraint)predicateConstraint);
        }
        PredicateBuilder builder = context.getDialect().getPredicateBuilder();
        builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, predicateConstraint, predicateDescr);
    }

    private Map<String, Class<?>> getDeclarationsMap(BaseDescr baseDescr, RuleBuildContext context) {
        HashMap declarations = new HashMap();
        for (Map.Entry entry : context.getDeclarationResolver().getDeclarations(context.getRule()).entrySet()) {
            if (((Declaration)entry.getValue()).getExtractor() == null) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), baseDescr, null, "Field Reader does not exist for declaration '" + (String)entry.getKey() + "' in'" + baseDescr + "' in the rule '" + context.getRule().getName() + "'"));
                continue;
            }
            declarations.put((String)entry.getKey(), ((Declaration)entry.getValue()).getExtractor().getExtractToClass());
        }
        return declarations;
    }

    private void createImplicitBindings(RuleBuildContext context, Pattern pattern, List unboundIdentifiers, List factDeclarations) {
        int size = unboundIdentifiers.size();
        for (int i = 0; i < size; ++i) {
            String identifier = (String)unboundIdentifiers.get(i);
            Declaration declaration = this.createDeclarationObject(context, identifier, pattern);
            if (declaration == null) continue;
            factDeclarations.add(declaration);
        }
    }

    private Declaration createDeclarationObject(RuleBuildContext context, String identifier, Pattern pattern) {
        FieldBindingDescr implicitBinding = new FieldBindingDescr(identifier, identifier);
        Declaration declaration = new Declaration(identifier, pattern);
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, implicitBinding, pattern.getObjectType(), implicitBinding.getFieldName(), (AcceptsReadAccessor)declaration, false);
        if (extractor == null) {
            return null;
        }
        return declaration;
    }

    private Restriction buildRestriction(RuleBuildContext context, Pattern pattern, InternalReadAccessor extractor, FieldConstraintDescr fieldConstraintDescr, RestrictionDescr restrictionDescr) {
        LiteralRestriction restriction = null;
        if (restrictionDescr instanceof LiteralRestrictionDescr) {
            restriction = this.buildRestriction(context, extractor, fieldConstraintDescr, (LiteralRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof QualifiedIdentifierRestrictionDescr) {
            restriction = this.buildRestriction(context, extractor, fieldConstraintDescr, (QualifiedIdentifierRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof VariableRestrictionDescr) {
            restriction = this.buildRestriction(context, extractor, fieldConstraintDescr, (VariableRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof ReturnValueRestrictionDescr) {
            restriction = this.buildRestriction(context, pattern, extractor, fieldConstraintDescr, (ReturnValueRestrictionDescr)restrictionDescr);
        }
        return restriction;
    }

    private Restriction buildRestriction(RuleBuildContext context, InternalReadAccessor extractor, FieldConstraintDescr fieldConstraintDescr, VariableRestrictionDescr variableRestrictionDescr) {
        if (variableRestrictionDescr.getIdentifier() == null || variableRestrictionDescr.getIdentifier().equals("")) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), variableRestrictionDescr, null, "Identifier not defined for binding field '" + fieldConstraintDescr.getFieldName() + "'"));
            return null;
        }
        Declaration declaration = context.getDeclarationResolver().getDeclaration(context.getRule(), variableRestrictionDescr.getIdentifier());
        if (declaration == null) {
            Pattern thisPattern = (Pattern)context.getBuildStack().peek();
            Declaration implicit = this.createDeclarationObject(context, variableRestrictionDescr.getIdentifier(), thisPattern);
            if (implicit != null) {
                declaration = implicit;
            } else {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), variableRestrictionDescr, null, "Unable to return Declaration for identifier '" + variableRestrictionDescr.getIdentifier() + "'"));
                return null;
            }
        }
        EvaluatorDefinition.Target right = this.getRightTarget(extractor);
        EvaluatorDefinition.Target left = declaration.isPatternDeclaration() && !Date.class.isAssignableFrom(declaration.getExtractor().getExtractToClass()) && !Number.class.isAssignableFrom(declaration.getExtractor().getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
        Evaluator evaluator = this.getEvaluator(context, variableRestrictionDescr, extractor.getValueType(), variableRestrictionDescr.getEvaluator(), variableRestrictionDescr.isNegated(), variableRestrictionDescr.getParameterText(), left, right);
        if (evaluator == null) {
            return null;
        }
        VariableRestriction restriction = new VariableRestriction(extractor, declaration, evaluator);
        if (declaration.getPattern().getObjectType().equals(new ClassObjectType(DroolsQuery.class))) {
            restriction = new UnificationRestriction(restriction);
        }
        return restriction;
    }

    private LiteralRestriction buildRestriction(RuleBuildContext context, InternalReadAccessor extractor, FieldConstraintDescr fieldConstraintDescr, LiteralRestrictionDescr literalRestrictionDescr) {
        FieldValue field = null;
        try {
            Object value = literalRestrictionDescr.getValue();
            if (literalRestrictionDescr.getType() == 3 && context.getConfiguration().isProcessStringEscapes()) {
                value = StringUtils.unescapeJava((String)((String)value));
            }
            field = FieldFactory.getFieldValue((Object)value, (ValueType)extractor.getValueType(), (DateFormats)context.getPackageBuilder().getDateFormats());
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), literalRestrictionDescr, e, "Unable to create a Field value of type  '" + extractor.getValueType() + "' and value '" + literalRestrictionDescr.getText() + "'"));
        }
        if (field == null) {
            return null;
        }
        EvaluatorDefinition.Target right = this.getRightTarget(extractor);
        EvaluatorDefinition.Target left = EvaluatorDefinition.Target.FACT;
        Evaluator evaluator = this.getEvaluator(context, literalRestrictionDescr, extractor.getValueType(), literalRestrictionDescr.getEvaluator(), literalRestrictionDescr.isNegated(), literalRestrictionDescr.getParameterText(), left, right);
        if (evaluator == null) {
            return null;
        }
        return new LiteralRestriction(field, evaluator, extractor);
    }

    private Restriction buildRestriction(RuleBuildContext context, InternalReadAccessor extractor, FieldConstraintDescr fieldConstraintDescr, QualifiedIdentifierRestrictionDescr qiRestrictionDescr) {
        FieldValue field = null;
        String[] parts = qiRestrictionDescr.getText().split("\\.");
        if (parts.length == 2) {
            Declaration implicit = null;
            if ("this".equals(parts[0])) {
                implicit = this.createDeclarationObject(context, parts[1], (Pattern)context.getBuildStack().peek());
            } else {
                Declaration decl = context.getDeclarationResolver().getDeclaration(context.getRule(), parts[0]);
                if (decl != null) {
                    if (decl.isPatternDeclaration()) {
                        implicit = this.createDeclarationObject(context, parts[1], decl.getPattern());
                    } else {
                        context.getErrors().add(new DescrBuildError(context.getParentDescr(), qiRestrictionDescr, "", "Not possible to directly access the property '" + parts[1] + "' of declaration '" + parts[0] + "' since it is not a pattern"));
                        return null;
                    }
                }
            }
            if (implicit != null) {
                EvaluatorDefinition.Target right = this.getRightTarget(extractor);
                EvaluatorDefinition.Target left = implicit.isPatternDeclaration() && !Date.class.isAssignableFrom(implicit.getExtractor().getExtractToClass()) && !Number.class.isAssignableFrom(implicit.getExtractor().getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
                Evaluator evaluator = this.getEvaluator(context, qiRestrictionDescr, extractor.getValueType(), qiRestrictionDescr.getEvaluator(), qiRestrictionDescr.isNegated(), qiRestrictionDescr.getParameterText(), left, right);
                if (evaluator == null) {
                    return null;
                }
                return new VariableRestriction(extractor, implicit, evaluator);
            }
        }
        int lastDot = qiRestrictionDescr.getText().lastIndexOf(46);
        String className = qiRestrictionDescr.getText().substring(0, lastDot);
        String fieldName = qiRestrictionDescr.getText().substring(lastDot + 1);
        try {
            Class staticClass = context.getDialect().getTypeResolver().resolveType(className);
            field = FieldFactory.getFieldValue((Object)staticClass.getField(fieldName).get(null), (ValueType)extractor.getValueType(), (DateFormats)context.getPackageBuilder().getDateFormats());
            if (field.isObjectField()) {
                ((ObjectFieldImpl)field).setEnum(true);
                ((ObjectFieldImpl)field).setEnumName(staticClass.getName());
                ((ObjectFieldImpl)field).setFieldName(fieldName);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), qiRestrictionDescr, e, "Unable to create a Field value of type  '" + extractor.getValueType() + "' and value '" + qiRestrictionDescr.getText() + "'"));
        }
        if (field == null) {
            return null;
        }
        EvaluatorDefinition.Target right = this.getRightTarget(extractor);
        EvaluatorDefinition.Target left = EvaluatorDefinition.Target.FACT;
        Evaluator evaluator = this.getEvaluator(context, qiRestrictionDescr, extractor.getValueType(), qiRestrictionDescr.getEvaluator(), qiRestrictionDescr.isNegated(), qiRestrictionDescr.getParameterText(), left, right);
        if (evaluator == null) {
            return null;
        }
        return new LiteralRestriction(field, evaluator, extractor);
    }

    private EvaluatorDefinition.Target getRightTarget(InternalReadAccessor extractor) {
        EvaluatorDefinition.Target right = extractor.isSelfReference() && !Date.class.isAssignableFrom(extractor.getExtractToClass()) && !Number.class.isAssignableFrom(extractor.getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
        return right;
    }

    private ReturnValueRestriction buildRestriction(RuleBuildContext context, Pattern pattern, InternalReadAccessor extractor, FieldConstraintDescr fieldConstraintDescr, ReturnValueRestrictionDescr returnValueRestrictionDescr) {
        Map<String, Class<?>> declarations = this.getDeclarationsMap(returnValueRestrictionDescr, context);
        Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
        Dialect.AnalysisResult analysis = context.getDialect().analyzeExpression(context, returnValueRestrictionDescr, returnValueRestrictionDescr.getContent(), new Map[]{declarations, globals});
        List[] usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        int size = usedIdentifiers[0].size();
        for (int i = 0; i < size; ++i) {
            Declaration declaration = context.getDeclarationResolver().getDeclaration(context.getRule(), usedIdentifiers[0].get(i));
            if (declaration.getPattern() == pattern) {
                factDeclarations.add(declaration);
                continue;
            }
            tupleDeclarations.add(declaration);
        }
        this.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), factDeclarations);
        EvaluatorDefinition.Target right = this.getRightTarget(extractor);
        EvaluatorDefinition.Target left = EvaluatorDefinition.Target.FACT;
        Evaluator evaluator = this.getEvaluator(context, returnValueRestrictionDescr, extractor.getValueType(), returnValueRestrictionDescr.getEvaluator(), returnValueRestrictionDescr.isNegated(), returnValueRestrictionDescr.getParameterText(), left, right);
        if (evaluator == null) {
            return null;
        }
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        String[] requiredGlobals = usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]);
        ReturnValueRestriction returnValueRestriction = new ReturnValueRestriction(extractor, previousDeclarations, localDeclarations, requiredGlobals, evaluator);
        ReturnValueBuilder builder = context.getDialect().getReturnValueBuilder();
        builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, returnValueRestriction, returnValueRestrictionDescr);
        return returnValueRestriction;
    }

    public static void registerReadAccessor(RuleBuildContext context, ObjectType objectType, String fieldName, AcceptsReadAccessor target) {
        if (!ValueType.FACTTEMPLATE_TYPE.equals((Object)objectType.getValueType())) {
            ClassFieldReader reader = context.getPkg().getClassFieldAccessorStore().getReader(((ClassObjectType)objectType).getClassName(), fieldName, target);
        }
    }

    public static InternalReadAccessor getFieldReadAccessor(RuleBuildContext context, BaseDescr descr, ObjectType objectType, String fieldName, AcceptsReadAccessor target, boolean reportError) {
        ClassFieldReader reader;
        block5: {
            reader = null;
            if (ValueType.FACTTEMPLATE_TYPE.equals((Object)objectType.getValueType())) {
                FactTemplate factTemplate = ((FactTemplateObjectType)objectType).getFactTemplate();
                reader = new FactTemplateFieldExtractor(factTemplate, factTemplate.getFieldTemplateIndex(fieldName));
                if (target != null) {
                    target.setReadAccessor((InternalReadAccessor)reader);
                }
            } else {
                try {
                    reader = context.getPkg().getClassFieldAccessorStore().getReader(((ClassObjectType)objectType).getClassName(), fieldName, target);
                }
                catch (Exception e) {
                    if (!reportError) break block5;
                    context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to create Field Extractor for '" + fieldName + "'"));
                }
            }
        }
        return reader;
    }

    private Evaluator getEvaluator(RuleBuildContext context, BaseDescr descr, ValueType valueType, String evaluatorString, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        Evaluator evaluator;
        EvaluatorDefinition def = context.getConfiguration().getEvaluatorRegistry().getEvaluatorDefinition(evaluatorString);
        if (def == null) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to determine the Evaluator for  ID '" + evaluatorString + "'"));
        }
        if ((evaluator = def.getEvaluator(valueType, evaluatorString, isNegated, parameterText, left, right)) == null) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Evaluator '" + (isNegated ? "not " : "") + evaluatorString + "' does not support type '" + valueType));
        }
        return evaluator;
    }
}

