/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;

public class MVELExprAnalyzer {
    public MVELAnalysisResult analyzeExpression(PackageBuildContext context, String expr, Set[] availableIdentifiers, Map localTypes) {
        MVELAnalysisResult result = null;
        if (expr.trim().length() > 0) {
            ExpressionCompiler compiler = new ExpressionCompiler(expr);
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            ParserContext parserContext = new ParserContext(dialect.getImports(), null, "xxx");
            parserContext.getParserConfiguration().setClassLoader((ClassLoader)context.getPackageBuilder().getRootClassLoader());
            if (dialect.getPackgeImports() != null && !dialect.getPackgeImports().isEmpty()) {
                for (String packageImport : dialect.getPackgeImports().values()) {
                    parserContext.addPackageImport(packageImport);
                }
            }
            parserContext.setStrictTypeEnforcement(false);
            parserContext.setInterceptors(dialect.getInterceptors());
            compiler.compile(parserContext);
            result = this.analyze(compiler.getParserContextState().getInputs().keySet(), availableIdentifiers);
            result.setMvelVariables(compiler.getParserContextState().getVariables());
        } else {
            result = this.analyze(Collections.EMPTY_SET, availableIdentifiers);
            result.setMvelVariables(new HashMap());
        }
        return result;
    }

    private MVELAnalysisResult analyze(Set identifiers, Set[] availableIdentifiers) {
        int i;
        MVELAnalysisResult result = new MVELAnalysisResult();
        result.setIdentifiers(new ArrayList(identifiers));
        HashSet notBound = new HashSet(identifiers);
        List[] used = new List[availableIdentifiers.length];
        int length = used.length;
        for (i = 0; i < length; ++i) {
            used[i] = new ArrayList();
        }
        length = availableIdentifiers.length;
        for (i = 0; i < length; ++i) {
            Set set = availableIdentifiers[i];
            for (String eachDecl : set) {
                if (!identifiers.contains(eachDecl)) continue;
                used[i].add(eachDecl);
                notBound.remove(eachDecl);
            }
        }
        result.setBoundIdentifiers(used);
        result.setNotBoundedIdentifiers(new ArrayList(notBound));
        return result;
    }
}

