/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.drools.guvnor.client.modeldriven.testing.ExecutionTrace;
import org.drools.guvnor.client.modeldriven.testing.Expectation;
import org.drools.guvnor.client.modeldriven.testing.FactData;
import org.drools.guvnor.client.modeldriven.testing.FieldData;
import org.drools.guvnor.client.modeldriven.testing.Fixture;
import org.drools.guvnor.client.modeldriven.testing.RetractFact;
import org.drools.guvnor.client.modeldriven.testing.Scenario;
import org.drools.guvnor.client.modeldriven.testing.VerifyFact;
import org.drools.guvnor.client.modeldriven.testing.VerifyField;
import org.drools.guvnor.client.modeldriven.testing.VerifyRuleFired;

public class ScenarioXMLPersistence {
    private XStream xt = new XStream((HierarchicalStreamDriver)new DomDriver());
    private static final ScenarioXMLPersistence INSTANCE = new ScenarioXMLPersistence();

    private ScenarioXMLPersistence() {
        this.xt.alias("scenario", Scenario.class);
        this.xt.alias("execution-trace", ExecutionTrace.class);
        this.xt.alias("expectation", Expectation.class);
        this.xt.alias("fact-data", FactData.class);
        this.xt.alias("field-data", FieldData.class);
        this.xt.alias("fixture", Fixture.class);
        this.xt.alias("retract-fact", RetractFact.class);
        this.xt.alias("expect-fact", VerifyFact.class);
        this.xt.alias("expect-field", VerifyField.class);
        this.xt.alias("expect-rule", VerifyRuleFired.class);
        this.xt.omitField(ExecutionTrace.class, "rulesFired");
    }

    public static ScenarioXMLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(Scenario sc) {
        Fixture f;
        if (sc.fixtures.size() > 1 && sc.fixtures.get(sc.fixtures.size() - 1) instanceof ExecutionTrace && (f = sc.fixtures.get(sc.fixtures.size() - 2)) instanceof Expectation) {
            sc.fixtures.remove(sc.fixtures.size() - 1);
        }
        return this.xt.toXML((Object)sc);
    }

    public Scenario unmarshal(String xml) {
        if (xml == null) {
            return new Scenario();
        }
        if (xml.trim().equals("")) {
            return new Scenario();
        }
        return (Scenario)this.xt.fromXML(xml);
    }
}

